/*
 * Decompiled with CFR 0.152.
 */
package rikmuld.camping;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.logging.Level;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.MinecraftForge;
import rikmuld.camping.core.handler.CraftHandler;
import rikmuld.camping.core.handler.EventsHandler;
import rikmuld.camping.core.handler.KeyHandler;
import rikmuld.camping.core.handler.PlayerHandlerClient;
import rikmuld.camping.core.proxys.CommonProxy;
import rikmuld.camping.core.register.ModAchievements;
import rikmuld.camping.core.register.ModBlocks;
import rikmuld.camping.core.register.ModConfig;
import rikmuld.camping.core.register.ModCookingEquipment;
import rikmuld.camping.core.register.ModDamageSources;
import rikmuld.camping.core.register.ModEntitys;
import rikmuld.camping.core.register.ModItems;
import rikmuld.camping.core.register.ModLogger;
import rikmuld.camping.core.register.ModModels;
import rikmuld.camping.core.register.ModPackets;
import rikmuld.camping.core.register.ModPotions;
import rikmuld.camping.core.register.ModRecipes;
import rikmuld.camping.core.register.ModStructures;
import rikmuld.camping.core.register.ModTabs;
import rikmuld.camping.core.register.ModTileentitys;
import rikmuld.camping.core.util.KeyUtil;
import rikmuld.camping.misc.key.KeyListner;
import rikmuld.camping.network.PacketHandler;
import rikmuld.camping.world.WorldGen;

@Mod(modid="camping", name="The Camping Mod 2.0", version="2.0e", dependencies="required-after:Forge@[v9.11.0.899,)")
@NetworkMod(channels={"camping"}, clientSideRequired=true, serverSideRequired=false, packetHandler=PacketHandler.class)
public class CampingMod {
    @Mod.Instance(value="camping")
    public static CampingMod instance;
    @SidedProxy(clientSide="rikmuld.camping.core.proxys.ClientProxy", serverSide="rikmuld.camping.core.proxys.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderers();
        proxy.registerTickHandler();
        proxy.checkVersion();
        MinecraftForge.EVENT_BUS.register((Object)new EventsHandler());
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        GameRegistry.registerCraftingHandler((ICraftingHandler)new CraftHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGen());
        KeyUtil.registerKeyListner(new KeyListner());
        if (event.getSide() == Side.CLIENT) {
            GameRegistry.registerPlayerTracker((IPlayerTracker)new PlayerHandlerClient());
            KeyUtil.putKeyBindings();
            KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyHandler());
            ModModels.init();
        }
        ModPackets.init();
        ModEntitys.init();
        ModTabs.init();
        ModTileentitys.init();
        ModRecipes.init();
        ModCookingEquipment.init();
        ModStructures.init();
        ModDamageSources.init();
        ModPotions.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.registerGuide();
        ModLogger.log(Level.INFO, "The Camping Mod 2.0 is loaded successfully.");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModLogger.init();
        ModConfig.init(new File(event.getModConfigurationDirectory().getAbsolutePath() + "/The Camping Mod/" + "camping" + ".cfg"));
        ModBlocks.init();
        ModItems.init();
        ModAchievements.init();
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("Camping Millestones", ModAchievements.getAll()));
    }
}

