/*
 * Decompiled with CFR 0.152.
 */
package rikmuld.camping.core.handler;

import cpw.mods.fml.common.network.Player;
import org.lwjgl.input.Mouse;
import rikmuld.camping.core.util.PacketUtil;
import rikmuld.camping.core.util.PlayerUtil;
import rikmuld.camping.network.packets.PacketCampInvPos;

public class GuiContendHandler {
    public int[] guiXFlag;
    public int[] guiYFlag;
    public int[] guiXStart;
    public int[] guiYStart;
    public boolean[] clickFlag;
    public boolean[] clickedFlag;
    String name;

    public GuiContendHandler(int contendNum, String name) {
        this.name = name;
        this.guiXFlag = new int[contendNum];
        this.guiYFlag = new int[contendNum];
        this.guiXStart = new int[contendNum];
        this.guiYStart = new int[contendNum];
        this.clickFlag = new boolean[contendNum];
        this.clickedFlag = new boolean[contendNum];
    }

    public static GuiContendHandler readFromNBT(uf player, String name) {
        if (!PlayerUtil.getPlayerDataTag(player).b(name + ".guiContends")) {
            return null;
        }
        by tag = PlayerUtil.getPlayerDataTag(player).l(name + ".guiContends");
        int contendNum = tag.e("contendNum");
        GuiContendHandler handler = new GuiContendHandler(contendNum, name);
        handler.guiXFlag = tag.k("guiXFlag");
        handler.guiYFlag = tag.k("guiYFlag");
        handler.guiXStart = tag.k("guiXStart");
        handler.guiYStart = tag.k("guiYStart");
        return handler;
    }

    public static void sendServerContendsToClient(String name, uf player, by tag) {
        if (PlayerUtil.getPlayerDataTag(player).b(name + ".guiContends")) {
            PacketUtil.sendToPlayer(new PacketCampInvPos(name + ".guiContends", tag), (Player)player);
        }
    }

    private void move(int contend, int pointX, int pointY) {
        this.guiXFlag[contend] = pointX - this.guiXStart[contend];
        this.guiYFlag[contend] = pointY - this.guiYStart[contend];
    }

    public int posX(int contend) {
        return this.guiXFlag[contend];
    }

    public int posY(int contend) {
        return this.guiYFlag[contend];
    }

    public void resetAll() {
        this.guiXFlag = new int[this.guiXFlag.length];
        this.guiYFlag = new int[this.guiYFlag.length];
        this.guiXStart = new int[this.guiXStart.length];
        this.guiYStart = new int[this.guiYStart.length];
        this.clickFlag = new boolean[this.clickFlag.length];
        this.clickedFlag = new boolean[this.clickedFlag.length];
    }

    private void resetContend(int contend) {
        this.guiXFlag[contend] = 0;
        this.guiYFlag[contend] = 0;
    }

    public void sendClientContendsToServer(String name, uf player, by tag) {
        if (PlayerUtil.getPlayerDataTag(player).b(name + ".guiContends")) {
            PacketUtil.sendToSever(new PacketCampInvPos(name + ".guiContends", tag));
        }
    }

    private void startMovement(int contend, int pointX, int pointY) {
        this.guiXStart[contend] = pointX - this.guiXFlag[contend];
        this.guiYStart[contend] = pointY - this.guiYFlag[contend];
    }

    private void stopMovement(int contend) {
        this.guiXStart[contend] = -1000;
        this.guiYStart[contend] = -1000;
    }

    public void updateContend(int contend, int pointX, int pointY, boolean pointed) {
        if (Mouse.isButtonDown((int)1)) {
            if (pointed && this.clickedFlag[contend]) {
                this.clickFlag[contend] = true;
            }
            if (this.clickFlag[contend]) {
                if (this.guiXStart[contend] == -1000) {
                    this.startMovement(contend, pointX, pointY);
                }
                this.move(contend, pointX, pointY);
            } else {
                this.clickedFlag[contend] = false;
            }
        } else {
            this.stopMovement(contend);
            this.clickFlag[contend] = false;
            this.clickedFlag[contend] = true;
        }
        if (Mouse.isButtonDown((int)2) && pointed) {
            this.resetContend(contend);
        }
    }

    public void writeToNBT(uf player) {
        by tag = new by();
        tag.a("guiXFlag", this.guiXFlag);
        tag.a("guiYFlag", this.guiYFlag);
        tag.a("guiXStart", this.guiXStart);
        tag.a("guiYStart", this.guiYStart);
        tag.a("contendNum", this.guiYStart.length);
        PlayerUtil.getPlayerDataTag(player).a(this.name + ".guiContends", tag);
        this.sendClientContendsToServer(this.name, player, tag);
    }
}

