/*
 * Decompiled with CFR 0.152.
 */
package rikmuld.camping.core.register;

import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import net.minecraftforge.common.Configuration;
import rikmuld.camping.core.lib.AchievementInfo;
import rikmuld.camping.core.lib.BlockInfo;
import rikmuld.camping.core.lib.ConfigInfo;
import rikmuld.camping.core.lib.ItemInfo;
import rikmuld.camping.core.register.ModLogger;

public class ModConfig {
    public static Configuration config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File file) {
        config = new Configuration(file);
        ConfigInfo.putAll();
        BlockInfo.putAll();
        ItemInfo.putAll();
        AchievementInfo.putAll();
        try {
            config.load();
            ModConfig.loadBlockIds();
            ModConfig.loadItemIds();
            ModConfig.loadAchievementIds();
            ModConfig.loadBooleanOptions();
            ModConfig.loadIntegerOptions();
            ModConfig.loadDoubleOptions();
        }
        catch (Exception e) {
            ModLogger.log(Level.SEVERE, "The Camping Mod 2.0 could not load its configuration properly.");
        }
        finally {
            config.save();
        }
    }

    private static void loadAchievementIds() {
        Iterator<String> nameIDs = AchievementInfo.names.keySet().iterator();
        Iterator<String> gameNames = AchievementInfo.names.values().iterator();
        Iterator<Integer> IDs = AchievementInfo.devIDs.values().iterator();
        while (nameIDs.hasNext()) {
            int ID = IDs.next();
            String name = nameIDs.next();
            String gameName = gameNames.next();
            AchievementInfo.IDs.put(name, config.get("Achievement IDs", gameName, ID).getInt(ID));
        }
    }

    public static void loadBlockIds() {
        Iterator<String> nameIDs = BlockInfo.names.keySet().iterator();
        Iterator<String> gameNames = BlockInfo.names.values().iterator();
        Iterator<Integer> IDs = BlockInfo.devIDs.values().iterator();
        while (nameIDs.hasNext()) {
            int ID = IDs.next();
            String name = nameIDs.next();
            String gameName = gameNames.next();
            BlockInfo.IDs.put(name, config.getBlock(gameName, ID).getInt(ID));
        }
    }

    public static void loadBooleanOptions() {
        Iterator<String> nameIDs = ConfigInfo.ConfigInfoBoolean.names.keySet().iterator();
        Iterator<String> gameNames = ConfigInfo.ConfigInfoBoolean.names.values().iterator();
        Iterator<Boolean> values = ConfigInfo.ConfigInfoBoolean.devValues.values().iterator();
        Iterator<String> types = ConfigInfo.ConfigInfoBoolean.catagories.values().iterator();
        while (nameIDs.hasNext()) {
            String type = types.next();
            boolean value = values.next();
            String name = nameIDs.next();
            String gameName = gameNames.next();
            ConfigInfo.ConfigInfoBoolean.values.put(name, config.get(type, gameName, value).getBoolean(value));
        }
    }

    public static void loadDoubleOptions() {
        Iterator<String> nameIDs = ConfigInfo.ConfigInfoDouble.names.keySet().iterator();
        Iterator<String> gameNames = ConfigInfo.ConfigInfoDouble.names.values().iterator();
        Iterator<Double> values = ConfigInfo.ConfigInfoDouble.devValues.values().iterator();
        Iterator<String> types = ConfigInfo.ConfigInfoDouble.catagories.values().iterator();
        while (nameIDs.hasNext()) {
            String type = types.next();
            double value = values.next();
            String name = nameIDs.next();
            String gameName = gameNames.next();
            ConfigInfo.ConfigInfoDouble.values.put(name, config.get(type, gameName, value).getDouble(value));
        }
    }

    public static void loadIntegerOptions() {
        Iterator<String> nameIDs = ConfigInfo.ConfigInfoInteger.names.keySet().iterator();
        Iterator<String> gameNames = ConfigInfo.ConfigInfoInteger.names.values().iterator();
        Iterator<Integer> values = ConfigInfo.ConfigInfoInteger.devValues.values().iterator();
        Iterator<String> types = ConfigInfo.ConfigInfoInteger.catagories.values().iterator();
        while (nameIDs.hasNext()) {
            String type = types.next();
            int value = values.next();
            String name = nameIDs.next();
            String gameName = gameNames.next();
            ConfigInfo.ConfigInfoInteger.values.put(name, config.get(type, gameName, value).getInt(value));
        }
    }

    public static void loadItemIds() {
        Iterator<String> nameIDs = ItemInfo.names.keySet().iterator();
        Iterator<String> gameNames = ItemInfo.names.values().iterator();
        Iterator<Integer> IDs = ItemInfo.devIDs.values().iterator();
        while (nameIDs.hasNext()) {
            int ID = IDs.next();
            String name = nameIDs.next();
            String gameName = gameNames.next();
            ItemInfo.IDs.put(name, config.getItem(gameName, ID).getInt(ID));
        }
    }
}

