/*
 * Decompiled with CFR 0.152.
 */
package rikmuld.camping.entity.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import rikmuld.camping.core.register.ModBlocks;
import rikmuld.camping.core.register.ModStructures;
import rikmuld.camping.core.util.ItemStackUtil;
import rikmuld.camping.core.util.MathUtil;
import rikmuld.camping.core.util.PacketUtil;
import rikmuld.camping.entity.tileentity.TileEntityRotation;
import rikmuld.camping.inventory.slot.SlotState;
import rikmuld.camping.misc.bounds.Bounds;
import rikmuld.camping.misc.bounds.BoundsStructure;
import rikmuld.camping.misc.bounds.BoundsTracker;
import rikmuld.camping.network.packets.PacketPlayerSleepIntent;

public class TileEntityTent
extends TileEntityRotation {
    public SlotState[][] slots;
    public BoundsStructure[] structures;
    public BoundsTracker[] tracker = new BoundsTracker[4];
    public static Bounds[] bounds = new Bounds[]{new Bounds(-0.5f, 0.0f, 0.0f, 1.5f, 1.5f, 3.0f), new Bounds(-2.0f, 0.0f, -0.5f, 1.0f, 1.5f, 1.5f), new Bounds(-0.5f, 0.0f, -2.0f, 1.5f, 1.5f, 1.0f), new Bounds(0.0f, 0.0f, -0.5f, 3.0f, 1.5f, 1.5f)};
    boolean isNew = true;
    public boolean dropped;
    int[] contendList;
    public int maxContends;
    public int chestCost;
    public int bedCost;
    public int lanternCost;
    public int chests;
    public int beds;
    public int lanterns;
    public int maxChests;
    public int maxBeds;
    public int maxLanterns;
    public int contends;
    public static int LANTERN = 0;
    public static int CHEST = 1;
    public static int BEDS = 2;
    public int time;
    public int oldTime;
    public int lanternDamage;
    public int update;
    public uf sleepingPlayer;
    public boolean needLightUpdate;
    int lanternUpdateTick;
    public int slide;
    public int maxSlide;
    public int chestTracker;
    public int lanternTracker;
    public int color;

    public TileEntityTent() {
        this.contendList = new int[]{ModBlocks.lantern.cF, aqz.az.cF, ModBlocks.sleepingbag.cF};
        this.maxContends = 10;
        this.chestCost = 2;
        this.bedCost = 5;
        this.lanternCost = 1;
        this.maxChests = 5;
        this.maxBeds = 1;
        this.maxLanterns = 1;
        this.time = -1;
        this.lanternDamage = 0;
        this.needLightUpdate = true;
        this.lanternUpdateTick = 3;
        this.maxSlide = 144;
        this.color = 15;
    }

    public boolean addBed() {
        if (this.contends + this.bedCost <= this.maxContends && this.beds < this.maxBeds) {
            this.setContends(this.beds + 1, BEDS, true, 0);
            return true;
        }
        return false;
    }

    public boolean addChests() {
        if (this.contends + this.chestCost <= this.maxContends && this.chests < this.maxChests) {
            this.setContends(this.chests + 1, CHEST, true, 0);
            return true;
        }
        return false;
    }

    public boolean addContends(ye stack) {
        int id = stack.d;
        if (id == this.contendList[0]) {
            return this.addLentern(stack);
        }
        if (id == this.contendList[1]) {
            return this.addChests();
        }
        if (id == this.contendList[2]) {
            return this.addBed();
        }
        return false;
    }

    public boolean addLentern(ye stack) {
        if (this.contends + this.lanternCost <= this.maxContends && this.lanterns < this.maxLanterns) {
            this.time = stack.p() ? stack.q().e("time") : -1;
            this.lanternDamage = this.time > 0 ? 0 : 1;
            this.sendTileData(3, true, this.lanternDamage);
            this.setContends(this.lanterns + 1, LANTERN, true, 0);
            return true;
        }
        return false;
    }

    public ArrayList<ye> getContends() {
        ArrayList<ye> stacks = new ArrayList<ye>();
        ye lanternStack = new ye(this.contendList[0], this.lanterns, this.time > 0 ? 0 : 1);
        if (this.time > 0) {
            lanternStack.d(new by());
            lanternStack.q().a("time", this.time);
        }
        if (this.lanterns > 0) {
            stacks.add(lanternStack);
        }
        if (this.chests > 0) {
            stacks.add(new ye(this.contendList[1], this.chests, 0));
        }
        if (this.beds > 0) {
            stacks.add(new ye(this.contendList[2], this.beds, 0));
        }
        return stacks;
    }

    public ye getContendsFor(int id) {
        if (id == ModBlocks.lantern.cF) {
            ye lanternStack = new ye(this.contendList[0], this.lanterns, this.time > 0 ? 0 : 1);
            if (this.time > 0) {
                lanternStack.d(new by());
                lanternStack.q().a("time", this.time);
            }
            return lanternStack;
        }
        if (id == aqz.az.cF) {
            return new ye(this.contendList[1], 1, 0);
        }
        if (id == ModBlocks.sleepingbag.cF) {
            return new ye(this.contendList[2], 1, 0);
        }
        return null;
    }

    private ArrayList<ye> getExcesChestContends() {
        ArrayList<ye> list = new ArrayList<ye>();
        for (int i = this.chests * 5 * 6; i < 150; ++i) {
            if (this.a(i + 1) == null) continue;
            list.add(this.a(i + 1));
            this.a(i + 1, null);
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public asx getRenderBoundingBox() {
        asx bb = INFINITE_EXTENT_AABB;
        Bounds bound = bounds[this.rotation];
        asx.a((double)bound.xMin, (double)bound.yMin, (double)bound.zMin, (double)bound.xMax, (double)bound.yMax, (double)bound.zMax);
        return bb;
    }

    @Override
    public int j_() {
        return 151;
    }

    public void initalize() {
        if (!this.k.I) {
            this.structures = ModStructures.tent;
            for (int i = 0; i < 4; ++i) {
                this.tracker[i] = new BoundsTracker(this.l, this.m, this.n, bounds[i]);
            }
            this.isNew = false;
        }
    }

    public void manageSlots() {
        block7: {
            if (this.slots == null) break block7;
            if (this.chests > 2) {
                int scaledSlide = (int)MathUtil.getScaledNumber(this.slide, 144, 5 * this.chests - 11);
                for (int i = 0; i < 5 * this.chests; ++i) {
                    for (int j = 0; j < 6; ++j) {
                        this.slots[i][j].setStateX(scaledSlide);
                        if (i < scaledSlide || i >= scaledSlide + 11) {
                            this.slots[i][j].disable();
                            continue;
                        }
                        this.slots[i][j].enable();
                    }
                }
            } else {
                for (int i = 0; i < 5 * this.chests; ++i) {
                    for (int j = 0; j < 6; ++j) {
                        this.slots[i][j].setStateX(0);
                        this.slots[i][j].enable();
                    }
                }
            }
        }
    }

    @Override
    public void a(by tag) {
        super.a(tag);
        this.contends = tag.e("contends");
        this.beds = tag.e("beds");
        this.lanterns = tag.e("lanterns");
        this.chests = tag.e("chests");
        this.lanternDamage = tag.e("lanternDamage");
        this.time = tag.e("time");
        this.color = tag.e("color");
    }

    public void removeAll() {
        this.setContends(0, 0, true, 2);
        this.setContends(0, 1, true, 0);
        this.setContends(0, 2, true, 0);
    }

    public boolean removeBed() {
        if (this.beds > 0) {
            this.setContends(this.beds - 1, BEDS, true, 1);
            ItemStackUtil.dropItemInWorld(this.getContendsFor(ModBlocks.sleepingbag.cF), this.k, this.l, this.m, this.n);
            return true;
        }
        return false;
    }

    public boolean removeChest() {
        if (this.chests > 0) {
            this.setContends(this.chests - 1, CHEST, true, 1);
            ItemStackUtil.dropItemInWorld(this.getContendsFor(aqz.az.cF), this.k, this.l, this.m, this.n);
            return true;
        }
        return false;
    }

    public boolean removeLantern() {
        if (this.lanterns > 0) {
            this.setContends(this.lanterns - 1, LANTERN, true, 1);
            ItemStackUtil.dropItemInWorld(this.getContendsFor(ModBlocks.lantern.cF), this.k, this.l, this.m, this.n);
            return true;
        }
        return false;
    }

    public void setColor(int color) {
        if (!this.k.I) {
            this.color = color;
            this.sendTileData(6, true, color);
        }
    }

    public void setContends(int contendNum, int contendId, boolean sendData, int drop) {
        if (drop == 1) {
            ItemStackUtil.dropItemInWorld(this.getContendsFor(this.contendList[contendId]), this.k, this.l, this.m, this.n);
        }
        if (drop == 2) {
            ItemStackUtil.dropItemsInWorld(this.getContends(), this.k, this.l, this.m, this.n);
        }
        if (sendData) {
            this.sendTileData(1, !this.k.I, contendNum, contendId, drop);
        }
        if (contendId == LANTERN) {
            this.lanterns = contendNum;
        }
        if (contendId == CHEST) {
            this.chests = contendNum;
        }
        if (contendId == BEDS) {
            this.beds = contendNum;
        }
        this.contends = this.beds * this.bedCost + this.chests * this.chestCost + this.lanterns * this.lanternCost;
        this.sendTileData(2, !this.k.I, this.contends);
        this.k.j(this.l, this.m, this.n);
        this.k.p(this.l, this.m, this.n);
    }

    @Override
    public void setRotation(int rotation) {
        if (!this.k.I) {
            if (this.isNew) {
                this.initalize();
            } else {
                this.structures[this.rotation].destroyStructure(this.k, this.tracker[this.rotation]);
            }
            this.rotation = rotation;
            this.sendTileData(0, true, this.rotation);
            this.structures[this.rotation].createStructure(this.k, this.tracker[this.rotation]);
        }
    }

    public void setSlideState(int slideState) {
        this.slide = slideState;
        this.manageSlots();
        this.sendTileData(4, false, slideState);
    }

    public void setSlots(SlotState[][] slots) {
        this.slots = slots;
    }

    @Override
    public void setTileData(int id, int[] data) {
        super.setTileData(id, data);
        if (id == 1) {
            this.setContends(data[0], data[1], false, data[2]);
        }
        if (id == 2) {
            this.contends = data[0];
        }
        if (id == 3) {
            this.lanternDamage = data[0];
        }
        if (id == 4) {
            this.slide = data[0];
            this.manageSlots();
        }
        if (id == 5) {
            this.time = data[0];
        }
        if (id == 6) {
            this.color = data[0];
        }
    }

    public void sleep(uf player) {
        if (!this.k.I) {
            if (this.sleepingPlayer == null) {
                ug state = null;
                if (this.rotation == 0) {
                    state = player.a(this.l, this.m, this.n + 1);
                }
                if (this.rotation == 1) {
                    state = player.a(this.l - 1, this.m, this.n);
                }
                if (this.rotation == 2) {
                    state = player.a(this.l, this.m, this.n - 1);
                }
                if (this.rotation == 3) {
                    state = player.a(this.l + 1, this.m, this.n);
                }
                if (state != ug.a) {
                    if (state == ug.c) {
                        player.a("tile.bed.noSleep");
                    } else if (state == ug.f) {
                        player.a("tile.bed.notSafe");
                    }
                }
            } else {
                player.a("This sleeping bag is occupied!");
            }
        } else {
            PacketUtil.sendToSever(new PacketPlayerSleepIntent(this.l, this.m, this.n));
        }
    }

    public void h() {
        if (!this.k.I) {
            this.oldTime = this.time;
            if (this.chestTracker != this.chests) {
                this.chestTracker = this.chests;
                ItemStackUtil.dropItemsInWorld(this.getExcesChestContends(), this.k, this.l, this.m, this.n);
            }
            if (this.lanternTracker != this.lanterns) {
                this.lanternTracker = this.lanterns;
                if (this.lanterns == 0) {
                    if (this.a(0) != null) {
                        ItemStackUtil.dropItemInWorld(this.a(0), this.k, this.l, this.m, this.n);
                    }
                    this.a(0, null);
                }
            }
            if (this.needLightUpdate) {
                this.k.j(this.l, this.m, this.n);
                this.k.p(this.l, this.m, this.n);
                if (this.lanternUpdateTick == 0) {
                    this.needLightUpdate = false;
                }
                if (this.lanternUpdateTick > 0) {
                    --this.lanternUpdateTick;
                }
            }
            if (this.isNew) {
                this.initalize();
            }
            ++this.update;
            if (this.update > 10 && this.time > 0) {
                --this.time;
                this.update = 0;
            }
            if (this.time == 0) {
                this.time = -1;
                this.lanternDamage = 1;
                this.sendTileData(3, true, this.lanternDamage);
                this.k.j(this.l, this.m, this.n);
                this.k.p(this.l, this.m, this.n);
            }
            if (this.sleepingPlayer != null && !this.sleepingPlayer.bh()) {
                this.sleepingPlayer = null;
            }
            if (this.time <= 0 && this.a(0) != null) {
                this.a(0, 1);
                this.time = 1500;
                this.lanternDamage = 0;
                this.sendTileData(3, true, this.lanternDamage);
                this.k.j(this.l, this.m, this.n);
                this.k.p(this.l, this.m, this.n);
            }
            if (this.time != this.oldTime) {
                this.sendTileData(5, true, this.time);
            }
        }
    }

    @Override
    public void b(by tag) {
        super.b(tag);
        tag.a("contends", this.contends);
        tag.a("beds", this.beds);
        tag.a("lanterns", this.lanterns);
        tag.a("chests", this.chests);
        tag.a("lanternDamage", this.lanternDamage);
        tag.a("time", this.time);
        tag.a("color", this.color);
    }
}

