/*
 * Decompiled with CFR 0.152.
 */
package rikmuld.camping.misc.models;

import cpw.mods.fml.common.FMLLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.ModelFormatException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CustomModel
extends bbo
implements IModelCustom {
    public int u = 64;
    public int t = 32;
    public static final List<String> cubeTypes = Arrays.asList("d9e621f7-957f-4b77-b1ae-20dcd0da7751", "de81aa14-bd60-4228-8d8d-5238bcd3caaa");
    private String fileName;
    private Map<String, byte[]> zipContents = new HashMap<String, byte[]>();
    private Map<String, bcu> parts = new LinkedHashMap<String, bcu>();
    private String texture = null;

    public CustomModel(String fileName, URL resource, int width, int height) throws ModelFormatException {
        this.fileName = fileName;
        this.u = height;
        this.t = width;
        this.loadTechneModel(resource);
    }

    public String getType() {
        return "tcn";
    }

    private void loadTechneModel(URL fileURL) throws ModelFormatException {
        try {
            ZipEntry entry;
            ZipInputStream zipInput = new ZipInputStream(fileURL.openStream());
            while ((entry = zipInput.getNextEntry()) != null) {
                byte[] data = new byte[(int)entry.getSize()];
                int i = 0;
                while (zipInput.available() > 0 && i < data.length) {
                    data[i++] = (byte)zipInput.read();
                }
                this.zipContents.put(entry.getName(), data);
            }
            byte[] modelXml = this.zipContents.get("model.xml");
            if (modelXml == null) {
                throw new ModelFormatException("Model " + this.fileName + " contains no model.xml file");
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(modelXml));
            NodeList nodeListTechne = document.getElementsByTagName("Techne");
            if (nodeListTechne.getLength() < 1) {
                throw new ModelFormatException("Model " + this.fileName + " contains no Techne tag");
            }
            NodeList nodeListModel = document.getElementsByTagName("Model");
            if (nodeListModel.getLength() < 1) {
                throw new ModelFormatException("Model " + this.fileName + " contains no Model tag");
            }
            NamedNodeMap modelAttributes = nodeListModel.item(0).getAttributes();
            if (modelAttributes == null) {
                throw new ModelFormatException("Model " + this.fileName + " contains a Model tag with no attributes");
            }
            Node modelTexture = modelAttributes.getNamedItem("texture");
            if (modelTexture != null) {
                this.texture = modelTexture.getTextContent();
            }
            NodeList shapes = document.getElementsByTagName("Shape");
            for (int i = 0; i < shapes.getLength(); ++i) {
                Node shape = shapes.item(i);
                NamedNodeMap shapeAttributes = shape.getAttributes();
                if (shapeAttributes == null) {
                    throw new ModelFormatException("Shape #" + (i + 1) + " in " + this.fileName + " has no attributes");
                }
                Node name = shapeAttributes.getNamedItem("name");
                String shapeName = null;
                if (name != null) {
                    shapeName = name.getNodeValue();
                }
                if (shapeName == null) {
                    shapeName = "Shape #" + (i + 1);
                }
                String shapeType = null;
                Node type = shapeAttributes.getNamedItem("type");
                if (type != null) {
                    shapeType = type.getNodeValue();
                }
                if (shapeType != null && !cubeTypes.contains(shapeType)) {
                    FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " is not a cube, ignoring"), (Object[])new Object[0]);
                    continue;
                }
                try {
                    boolean mirrored = false;
                    String[] offset = new String[3];
                    String[] position = new String[3];
                    String[] rotation = new String[3];
                    String[] size = new String[3];
                    String[] textureOffset = new String[2];
                    NodeList shapeChildren = shape.getChildNodes();
                    for (int j = 0; j < shapeChildren.getLength(); ++j) {
                        Node shapeChild = shapeChildren.item(j);
                        String shapeChildName = shapeChild.getNodeName();
                        String shapeChildValue = shapeChild.getTextContent();
                        if (shapeChildValue == null) continue;
                        shapeChildValue = shapeChildValue.trim();
                        if (shapeChildName.equals("IsMirrored")) {
                            mirrored = !shapeChildValue.equals("False");
                            continue;
                        }
                        if (shapeChildName.equals("Offset")) {
                            offset = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Position")) {
                            position = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Rotation")) {
                            rotation = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Size")) {
                            size = shapeChildValue.split(",");
                            continue;
                        }
                        if (!shapeChildName.equals("TextureOffset")) continue;
                        textureOffset = shapeChildValue.split(",");
                    }
                    bcu cube = new bcu((bbo)this, Integer.parseInt(textureOffset[0]), Integer.parseInt(textureOffset[1]));
                    cube.b = this.u;
                    cube.a = this.t;
                    cube.i = mirrored;
                    cube.a(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]), Integer.parseInt(size[0]), Integer.parseInt(size[1]), Integer.parseInt(size[2]));
                    cube.a(Float.parseFloat(position[0]), Float.parseFloat(position[1]) - 23.4f, Float.parseFloat(position[2]));
                    cube.f = (float)Math.toRadians(Float.parseFloat(rotation[0]));
                    cube.g = (float)Math.toRadians(Float.parseFloat(rotation[1]));
                    cube.h = (float)Math.toRadians(Float.parseFloat(rotation[2]));
                    this.parts.put(shapeName, cube);
                    continue;
                }
                catch (NumberFormatException e) {
                    FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " contains malformed integers within its data, ignoring"), (Object[])new Object[0]);
                    e.printStackTrace();
                }
            }
        }
        catch (ZipException e) {
            throw new ModelFormatException("Model " + this.fileName + " is not a valid zip file");
        }
        catch (IOException e) {
            throw new ModelFormatException("Model " + this.fileName + " could not be read", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
            throw new ModelFormatException("Model " + this.fileName + " contains invalid XML", (Throwable)e);
        }
    }

    public void renderAll() {
        for (bcu part : this.parts.values()) {
            part.b(1.0f);
        }
    }

    public void renderAllExcept(String ... excludedGroupNames) {
        int i = 0;
        for (bcu part : this.parts.values()) {
            String name = (String)this.parts.keySet().toArray()[i];
            boolean skipPart = false;
            for (String excludedGroupName : excludedGroupNames) {
                if (!excludedGroupName.equalsIgnoreCase(name)) continue;
                skipPart = true;
            }
            if (!skipPart) {
                part.b(1.0f);
            }
            ++i;
        }
    }

    public void renderOnly(String ... groupNames) {
        int i = 0;
        for (bcu part : this.parts.values()) {
            String name = (String)this.parts.keySet().toArray()[i];
            for (String groupName : groupNames) {
                if (!groupName.equalsIgnoreCase(name)) continue;
                part.b(1.0f);
            }
            ++i;
        }
    }

    public void renderPart(String partName) {
        bcu part = this.parts.get(partName);
        if (part != null) {
            part.b(1.0f);
        }
    }
}

