/*
 * Decompiled with CFR 0.152.
 */
package rikmuld.camping.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import rikmuld.camping.entity.tileentity.TileEntityMain;
import rikmuld.camping.network.packets.PacketMain;

public class PacketTileData
extends PacketMain {
    public int x;
    public int y;
    public int z;
    public int id;
    public int length;
    public byte[] data;

    public PacketTileData() {
        super(true);
    }

    public PacketTileData(int id, int x, int y, int z, int ... data) {
        super(true);
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.length = data.length * 4;
        this.data = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            byte[] intData = ByteBuffer.allocate(4).putInt(data[i]).array();
            for (int o = 0; o < 4; ++o) {
                this.data[i * 4 + o] = intData[o];
            }
        }
    }

    @Override
    public void execute(cm network, uf player) {
        int[] intData = new int[this.length / 4];
        for (int i = 0; i < this.length / 4; ++i) {
            byte[] wrap = new byte[4];
            for (int o = i * 4; o < i * 4 + 4; ++o) {
                wrap[o - i * 4] = this.data[o];
            }
            intData[i] = ByteBuffer.wrap(wrap).getInt();
        }
        if (player.q.r(this.x, this.y, this.z) != null) {
            ((TileEntityMain)player.q.r(this.x, this.y, this.z)).setTileData(this.id, intData);
        }
    }

    @Override
    public void readData(DataInputStream dataStream) throws IOException {
        this.id = dataStream.readInt();
        this.x = dataStream.readInt();
        this.y = dataStream.readInt();
        this.z = dataStream.readInt();
        this.length = dataStream.readInt();
        this.data = new byte[this.length];
        dataStream.read(this.data);
    }

    @Override
    public void writeData(DataOutputStream dataStream) throws IOException {
        dataStream.writeInt(this.id);
        dataStream.writeInt(this.x);
        dataStream.writeInt(this.y);
        dataStream.writeInt(this.z);
        dataStream.writeInt(this.length);
        dataStream.write(this.data);
    }
}

