/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.CommonProxy;
import hunternif.mc.atlas.client.BiomeTextureConfig;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.client.TextureSetConfig;
import hunternif.mc.atlas.client.TextureSetMap;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.gui.GuiAtlas;
import hunternif.mc.atlas.ext.ExtTileTextureConfig;
import hunternif.mc.atlas.ext.ExtTileTextureMap;
import hunternif.mc.atlas.marker.MarkerTextureConfig;
import hunternif.mc.atlas.marker.MarkerTextureMap;
import hunternif.mc.atlas.util.Log;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientProxy
extends CommonProxy {
    private TextureSetMap textureSetMap;
    private TextureSetConfig textureSetConfig;
    private BiomeTextureMap biomeTextureMap;
    private BiomeTextureConfig biomeTextureConfig;
    private ExtTileTextureMap tileTextureMap;
    private ExtTileTextureConfig tileTextureConfig;
    private MarkerTextureMap markerTextureMap;
    private MarkerTextureConfig markerTextureConfig;
    private GuiAtlas guiAtlas;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        this.textureSetMap = TextureSetMap.instance();
        this.textureSetConfig = new TextureSetConfig(new File(this.configDir, "texture_sets.json"));
        this.registerDefaultTextureSets(this.textureSetMap);
        this.textureSetConfig.load(this.textureSetMap);
        this.textureSetMap.setDirty(false);
        this.textureSetMap.register(TextureSet.TEST);
        File biomeTextureConfigFile = new File(this.configDir, "textures.json");
        if (biomeTextureConfigFile.exists()) {
            biomeTextureConfigFile.renameTo(new File(this.configDir, "biome_textures.json"));
        }
        this.biomeTextureMap = BiomeTextureMap.instance();
        this.biomeTextureConfig = new BiomeTextureConfig(new File(this.configDir, "biome_textures.json"), this.textureSetMap);
        this.biomeTextureConfig.load(this.biomeTextureMap);
        this.biomeTextureMap.setDirty(false);
        this.assignVanillaBiomeTextures();
        this.tileTextureMap = ExtTileTextureMap.instance();
        this.tileTextureConfig = new ExtTileTextureConfig(new File(this.configDir, "tile_textures.json"), this.textureSetMap);
        this.tileTextureConfig.load(this.tileTextureMap);
        this.tileTextureMap.setDirty(false);
        this.registerVanillaCustomTileTextures();
        this.markerTextureMap = MarkerTextureMap.instance();
        this.markerTextureConfig = new MarkerTextureConfig(new File(this.configDir, "marker_textures.json"));
        this.markerTextureConfig.load(this.markerTextureMap);
        this.markerTextureMap.setDirty(false);
        this.registerDefaultMarkers();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.guiAtlas = new GuiAtlas();
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a((Item)AntiqueAtlasMod.itemAtlas, new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return new ModelResourceLocation("antiqueatlas:antiqueAtlas", "inventory");
            }
        });
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)AntiqueAtlasMod.itemEmptyAtlas, 0, new ModelResourceLocation("antiqueatlas:emptyAntiqueAtlas", "inventory"));
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        this.guiAtlas.setMapScale(AntiqueAtlasMod.settings.defaultScale);
    }

    @Override
    public void openAtlasGUI(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            this.guiAtlas.updateL18n();
            mc.func_147108_a((GuiScreen)this.guiAtlas.setAtlasItemStack(stack));
        }
    }

    private void registerDefaultTextureSets(TextureSetMap map) {
        map.register(TextureSet.ICE);
        map.register(TextureSet.SHORE);
        map.register(TextureSet.ROCK_SHORE);
        map.register(TextureSet.DESERT);
        map.register(TextureSet.PLAINS);
        map.register(TextureSet.SUNFLOWERS);
        map.register(TextureSet.HILLS);
        map.register(TextureSet.DESERT_HILLS);
        map.register(TextureSet.ICE_SPIKES);
        map.register(TextureSet.SNOW_PINES);
        map.register(TextureSet.SNOW_PINES_HILLS);
        map.register(TextureSet.SNOW_HILLS);
        map.register(TextureSet.SNOW);
        map.register(TextureSet.MOUNTAINS_NAKED);
        map.register(TextureSet.MOUNTAINS);
        map.register(TextureSet.MOUNTAINS_SNOW_CAPS);
        map.register(TextureSet.MOUNTAINS_ALL);
        map.register(TextureSet.FOREST);
        map.register(TextureSet.FOREST_HILLS);
        map.register(TextureSet.FOREST_FLOWERS);
        map.register(TextureSet.DENSE_FOREST);
        map.register(TextureSet.DENSE_FOREST_HILLS);
        map.register(TextureSet.BIRCH);
        map.register(TextureSet.BIRCH_HILLS);
        map.register(TextureSet.TALL_BIRCH);
        map.register(TextureSet.TALL_BIRCH_HILLS);
        map.register(TextureSet.DENSE_BIRCH);
        map.register(TextureSet.JUNGLE);
        map.register(TextureSet.JUNGLE_HILLS);
        map.register(TextureSet.JUNGLE_CLIFFS);
        map.register(TextureSet.JUNGLE_EDGE);
        map.register(TextureSet.JUNGLE_EDGE_HILLS);
        map.register(TextureSet.PINES);
        map.register(TextureSet.PINES_HILLS);
        map.register(TextureSet.SAVANNA);
        map.register(TextureSet.SAVANNA_CLIFFS);
        map.register(TextureSet.PLATEAU_SAVANNA_M);
        map.register(TextureSet.MESA);
        map.register(TextureSet.BRYCE);
        map.register(TextureSet.PLATEAU_MESA);
        map.register(TextureSet.PLATEAU_MESA_LOW);
        map.register(TextureSet.PLATEAU_MESA_TREES);
        map.register(TextureSet.PLATEAU_MESA_TREES_LOW);
        map.register(TextureSet.PLATEAU_SAVANNA);
        map.register(TextureSet.MEGA_SPRUCE);
        map.register(TextureSet.MEGA_SPRUCE_HILLS);
        map.register(TextureSet.MEGA_TAIGA);
        map.register(TextureSet.MEGA_TAIGA_HILLS);
        map.register(TextureSet.SWAMP);
        map.register(TextureSet.SWAMP_HILLS);
        map.register(TextureSet.MUSHROOM);
        map.register(TextureSet.WATER);
        map.register(TextureSet.LAVA);
        map.register(TextureSet.LAVA_SHORE);
        map.register(TextureSet.CAVE_WALLS);
        map.register(TextureSet.HOUSE);
        map.register(TextureSet.FENCE);
        map.register(TextureSet.LIBRARY);
        map.register(TextureSet.L_HOUSE);
        map.register(TextureSet.SMITHY);
        map.register(TextureSet.FARMLAND_LARGE);
        map.register(TextureSet.FARMLAND_SMALL);
        map.register(TextureSet.WELL);
        map.register(TextureSet.VILLAGE_TORCH);
        map.register(TextureSet.HUT);
        map.register(TextureSet.HOUSE_SMALL);
        map.register(TextureSet.BUTCHERS_SHOP);
        map.register(TextureSet.CHURCH);
        map.register(TextureSet.NETHER_BRIDGE);
        map.register(TextureSet.NETHER_BRIDGE_X);
        map.register(TextureSet.NETHER_BRIDGE_Z);
        map.register(TextureSet.NETHER_BRIDGE_END_X);
        map.register(TextureSet.NETHER_BRIDGE_END_Z);
        map.register(TextureSet.NETHER_BRIDGE_GATE);
        map.register(TextureSet.NETHER_TOWER);
        map.register(TextureSet.NETHER_WALL);
        map.register(TextureSet.NETHER_HALL);
        map.register(TextureSet.NETHER_FORT_STAIRS);
        map.register(TextureSet.NETHER_THRONE);
    }

    private void assignVanillaBiomeTextures() {
        this.setBiomeTextureIfNone(BiomeGenBase.field_76771_b, TextureSet.WATER);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150575_M, TextureSet.WATER);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76781_i, TextureSet.WATER);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76776_l, TextureSet.ICE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76777_m, TextureSet.ICE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76787_r, TextureSet.SHORE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150577_O, TextureSet.SHORE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150576_N, TextureSet.ROCK_SHORE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76769_d, TextureSet.DESERT);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76769_d.field_76756_M + 128, TextureSet.DESERT);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76786_s, TextureSet.DESERT_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76772_c, TextureSet.PLAINS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76772_c.field_76756_M + 128, TextureSet.SUNFLOWERS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76774_n, TextureSet.SNOW);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76774_n.field_76756_M + 128, TextureSet.ICE_SPIKES);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76775_o, TextureSet.SNOW_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76770_e, TextureSet.MOUNTAINS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76783_v, TextureSet.MOUNTAINS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76770_e.field_76756_M + 128, TextureSet.MOUNTAINS_SNOW_CAPS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150580_W, TextureSet.MOUNTAINS_ALL);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150580_W.field_76756_M + 128, TextureSet.MOUNTAINS_SNOW_CAPS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76767_f, TextureSet.FOREST);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76767_f.field_76756_M + 128, TextureSet.FOREST_FLOWERS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76785_t, TextureSet.FOREST_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150585_R, TextureSet.DENSE_FOREST);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150585_R.field_76756_M + 128, TextureSet.DENSE_FOREST_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150583_P, TextureSet.BIRCH);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150583_P.field_76756_M + 128, TextureSet.TALL_BIRCH);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150582_Q, TextureSet.BIRCH_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150582_Q.field_76756_M + 128, TextureSet.TALL_BIRCH_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76782_w, TextureSet.JUNGLE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76782_w.field_76756_M + 128, TextureSet.JUNGLE_CLIFFS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76792_x, TextureSet.JUNGLE_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150574_L, TextureSet.JUNGLE_EDGE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150574_L.field_76756_M + 128, TextureSet.JUNGLE_EDGE_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76768_g, TextureSet.PINES);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76768_g.field_76756_M + 128, TextureSet.PINES_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76784_u, TextureSet.PINES_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150584_S, TextureSet.SNOW_PINES);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150584_S.field_76756_M + 128, TextureSet.SNOW_PINES_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150579_T, TextureSet.SNOW_PINES_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150578_U, TextureSet.MEGA_TAIGA);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150578_U.field_76756_M + 128, TextureSet.MEGA_SPRUCE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150581_V, TextureSet.MEGA_TAIGA_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150581_V.field_76756_M + 128, TextureSet.MEGA_SPRUCE_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76780_h, TextureSet.SWAMP);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76780_h.field_76756_M + 128, TextureSet.SWAMP_HILLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76779_k, TextureSet.SHORE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76778_j, TextureSet.CAVE_WALLS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76789_p, TextureSet.MUSHROOM);
        this.setBiomeTextureIfNone(BiomeGenBase.field_76788_q, TextureSet.SHORE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150588_X, TextureSet.SAVANNA);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150588_X.field_76756_M + 128, TextureSet.SAVANNA_CLIFFS);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150589_Z, TextureSet.MESA);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150589_Z.field_76756_M + 128, TextureSet.BRYCE);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150608_ab, TextureSet.PLATEAU_MESA);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150607_aa, TextureSet.PLATEAU_MESA_TREES);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150608_ab.field_76756_M + 128, TextureSet.PLATEAU_MESA_LOW);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150607_aa.field_76756_M + 128, TextureSet.PLATEAU_MESA_TREES_LOW);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150587_Y, TextureSet.PLATEAU_SAVANNA);
        this.setBiomeTextureIfNone(BiomeGenBase.field_150587_Y.field_76756_M + 128, TextureSet.PLATEAU_SAVANNA_M);
    }

    private void setBiomeTextureIfNone(int biomeID, TextureSet textureSet) {
        if (!this.biomeTextureMap.isRegistered(biomeID)) {
            this.biomeTextureMap.setTexture(biomeID, textureSet);
        }
    }

    private void setBiomeTextureIfNone(BiomeGenBase biome, TextureSet textureSet) {
        this.setBiomeTextureIfNone(biome.field_76756_M, textureSet);
    }

    private void registerDefaultMarkers() {
        this.setMarkerTextureIfNone("google", Textures.MARKER_GOOGLE_MARKER);
        this.setMarkerTextureIfNone("red_x_large", Textures.MARKER_RED_X_LARGE);
        this.setMarkerTextureIfNone("red_x_small", Textures.MARKER_RED_X_SMALL);
        this.setMarkerTextureIfNone("village", Textures.MARKER_VILLAGE);
        this.setMarkerTextureIfNone("diamond", Textures.MARKER_DIAMOND);
        this.setMarkerTextureIfNone("bed", Textures.MARKER_BED);
        this.setMarkerTextureIfNone("pickaxe", Textures.MARKER_PICKAXE);
        this.setMarkerTextureIfNone("sword", Textures.MARKER_SWORD);
        this.setMarkerTextureIfNone("nether_portal", Textures.MARKER_NETHER_PORTAL);
        this.setMarkerTextureIfNone("skull", Textures.MARKER_SKULL);
        this.setMarkerTextureIfNone("tower", Textures.MARKER_TOWER);
        this.setMarkerTextureIfNone("scroll", Textures.MARKER_SCROLL);
        this.setMarkerTextureIfNone("tomb", Textures.MARKER_TOMB);
    }

    private void setMarkerTextureIfNone(String markerType, ResourceLocation texture) {
        if (!this.markerTextureMap.isRegistered(markerType)) {
            this.markerTextureMap.setTexture(markerType, texture);
        }
    }

    private void registerVanillaCustomTileTextures() {
        this.setCustomTileTextureIfNone("npcVillageLibrary", TextureSet.LIBRARY);
        this.setCustomTileTextureIfNone("npcVillageSmithy", TextureSet.SMITHY);
        this.setCustomTileTextureIfNone("npcVillageLHouse", TextureSet.L_HOUSE);
        this.setCustomTileTextureIfNone("npcVillageFarmlandLarge", TextureSet.FARMLAND_LARGE);
        this.setCustomTileTextureIfNone("npcVillageFarmlandSmall", TextureSet.FARMLAND_SMALL);
        this.setCustomTileTextureIfNone("npcVillageWell", TextureSet.WELL);
        this.setCustomTileTextureIfNone("npcVillageTorch", TextureSet.VILLAGE_TORCH);
        this.setCustomTileTextureIfNone("npcVillageHut", TextureSet.HUT);
        this.setCustomTileTextureIfNone("npcVillageSmallHouse", TextureSet.HOUSE_SMALL);
        this.setCustomTileTextureIfNone("npcVillageButchersShop", TextureSet.BUTCHERS_SHOP);
        this.setCustomTileTextureIfNone("npcVillageChurch", TextureSet.CHURCH);
        this.setCustomTileTextureIfNone("lava", TextureSet.LAVA);
        this.setCustomTileTextureIfNone("lavaShore", TextureSet.LAVA_SHORE);
        this.setCustomTileTextureIfNone("netherBridge", TextureSet.NETHER_BRIDGE);
        this.setCustomTileTextureIfNone("netherBridgeX", TextureSet.NETHER_BRIDGE_X);
        this.setCustomTileTextureIfNone("netherBridgeZ", TextureSet.NETHER_BRIDGE_Z);
        this.setCustomTileTextureIfNone("netherBridgeEndX", TextureSet.NETHER_BRIDGE_END_X);
        this.setCustomTileTextureIfNone("netherBridgeEndZ", TextureSet.NETHER_BRIDGE_END_Z);
        this.setCustomTileTextureIfNone("netherBridgeGate", TextureSet.NETHER_BRIDGE_GATE);
        this.setCustomTileTextureIfNone("netherTower", TextureSet.NETHER_TOWER);
        this.setCustomTileTextureIfNone("netherWall", TextureSet.NETHER_WALL);
        this.setCustomTileTextureIfNone("netherHall", TextureSet.NETHER_HALL);
        this.setCustomTileTextureIfNone("netherFortStairs", TextureSet.NETHER_FORT_STAIRS);
        this.setCustomTileTextureIfNone("netherThrone", TextureSet.NETHER_THRONE);
    }

    private void setCustomTileTextureIfNone(String tileName, TextureSet textureSet) {
        if (!this.tileTextureMap.isRegistered(tileName)) {
            this.tileTextureMap.setTexture(tileName, textureSet);
        }
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromContext(ctx);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.textureSetMap.isDirty()) {
            Log.info("Saving texture set config", new Object[0]);
            this.textureSetConfig.save(this.textureSetMap);
            this.textureSetMap.setDirty(false);
        }
        if (this.biomeTextureMap.isDirty()) {
            Log.info("Saving biome texture config", new Object[0]);
            this.biomeTextureConfig.save(this.biomeTextureMap);
            this.biomeTextureMap.setDirty(false);
        }
        if (this.tileTextureMap.isDirty()) {
            Log.info("Saving tile texture config", new Object[0]);
            this.tileTextureConfig.save(this.tileTextureMap);
            this.tileTextureMap.setDirty(false);
        }
        if (this.markerTextureMap.isDirty()) {
            Log.info("Saving marker texture config", new Object[0]);
            this.markerTextureConfig.save(this.markerTextureMap);
            this.markerTextureMap.setDirty(false);
        }
    }
}

