/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class SettingsConfig {
    private static final int VERSION = 4;
    private static final String GAMEPLAY = "Gameplay";
    private static final String INTERFACE = "Interface";
    private static final String PERFORMANCE = "Performance";
    private File configFile;
    private Configuration config;
    public boolean doSaveBrowsingPos = true;
    public boolean autoDeathMarker = true;
    public boolean autoVillageMarkers = true;
    public boolean doScaleMarkers = false;
    public double defaultScale = 0.5;
    public double minScale = 0.03125;
    public double maxScale = 4.0;
    public boolean doReverseWheelZoom = false;
    public int scanRadius = 11;
    public boolean forceChunkLoading = false;
    public float newScanInterval = 1.0f;
    public boolean doRescan = true;
    public int rescanRate = 4;
    public boolean doScanPonds = true;
    public boolean debugRender = false;

    public void load(File file) {
        Configuration config = new Configuration(file, String.valueOf(4));
        config.setCategoryComment(GAMEPLAY, "These settings will affect how the mod behaves in certain situations and the players' overall gameplay,\nbut generally won't affect performance.");
        config.setCategoryComment(INTERFACE, "These setting will affect the look and feel of the Atlas' interface.");
        config.setCategoryComment(PERFORMANCE, "These settings affect the algorithms for scanning the world, drawing the map etc. Changing them may\nimprove the game's overall stability and performance at the cost of Atlas' functionality.");
        this.doSaveBrowsingPos = config.getBoolean("do_save_browsing_pos", GAMEPLAY, this.doSaveBrowsingPos, "Whether to remember last open browsing position and zoom level for each dimension in every atlas.\nIf disabled, all dimensions and all atlases will be \"synchronized\" at the same coordinates and\nzoom level, and map will \"follow\" player by default.");
        this.autoDeathMarker = config.getBoolean("auto_death_marker", GAMEPLAY, this.autoDeathMarker, "Whether to add local marker for the spot where the player died.");
        this.autoVillageMarkers = config.getBoolean("auto_village_markers", GAMEPLAY, this.autoVillageMarkers, "Whether to add global markers for NPC villages.");
        this.defaultScale = config.getFloat("default_scale", INTERFACE, (float)this.defaultScale, 0.001953125f, 16.0f, "Default zoom level. The number corresponds to the size of a block on the map relative to the size of\na GUI pixel. Preferrably a power of 2.");
        this.minScale = config.getFloat("min_scale", INTERFACE, (float)this.minScale, 0.001953125f, 16.0f, "Minimum zoom level. The number corresponds to the size of a block on the map relative to the size of\na GUI pixel. Preferrably a power of 2. Smaller values may decrease performance!");
        this.maxScale = config.getFloat("max_scale", INTERFACE, (float)this.maxScale, 0.001953125f, 16.0f, "Maximum zoom level. The number corresponds to the size of a block on the map relative to the size of\na GUI pixel. Preferrably a power of 2.");
        this.doScaleMarkers = config.getBoolean("do_scale_markers", INTERFACE, this.doScaleMarkers, "Whether to change markers size depending on zoom level.");
        this.doReverseWheelZoom = config.getBoolean("do_reverse_wheel_zoom", INTERFACE, this.doReverseWheelZoom, "If false (by default), then mousewheel up is zoom in, mousewheel down is zoom out.\nIf true, then the direction is reversed.");
        this.scanRadius = config.getInt("area_scan_radius", PERFORMANCE, this.scanRadius, 1, 256, "The radius of the area around the player which is scanned by the Atlas at regular intervals.\nNote that this will not force faraway chunks to load, unless force_chunk_loading is enabled.\nLower value gives better performance.");
        this.forceChunkLoading = config.getBoolean("force_chunk_loading", PERFORMANCE, this.forceChunkLoading, "Force loading of chunks within scan radius even if it exceeds regular chunk loading distance.\nEnabling this may SEVERELY decrease performance!");
        this.newScanInterval = config.getFloat("area_scan_interval", PERFORMANCE, this.newScanInterval, 0.05f, 3600.0f, "Time in seconds between two scans of the area.\nHigher value gives better performance.");
        this.doRescan = config.getBoolean("do_rescan", PERFORMANCE, this.doRescan, "Whether to rescan chunks in the area that have been previously mapped. This is useful in case of\nchanges in coastline (including small ponds of water and lava), or if land disappears completely\n(for sky worlds).\nDisable for better performance.");
        this.rescanRate = config.getInt("area_rescan_rate", PERFORMANCE, this.rescanRate, 1, 1000, "The number of area scans between full rescans.\nHigher value gives better performance.");
        this.doScanPonds = config.getBoolean("do_scan_ponds", PERFORMANCE, this.doScanPonds, "Whether to perform additional scanning to locate small ponds of water or lava.\nDisable for better performance.");
        this.debugRender = config.getBoolean("debug_rendering", PERFORMANCE, this.debugRender, "If true, map render time will be output.");
        config.save();
    }

    public void save(File file) {
        if (this.configFile == null || !this.configFile.equals(file)) {
            this.load(file);
        }
        this.config.save();
    }
}

