/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.api.impl;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.TileAPI;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.client.TextureSetMap;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.ext.ExtBiomeData;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.ext.ExtTileTextureMap;
import hunternif.mc.atlas.ext.TileIdRegisteredEvent;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.bidirectional.PutBiomeTilePacket;
import hunternif.mc.atlas.network.client.DeleteCustomGlobalTilePacket;
import hunternif.mc.atlas.network.client.TileNameIDPacket;
import hunternif.mc.atlas.network.client.TilesPacket;
import hunternif.mc.atlas.network.server.RegisterTileIdPacket;
import hunternif.mc.atlas.util.Log;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TileApiImpl
implements TileAPI {
    private final Map<String, TileData> pendingTiles = new HashMap<String, TileData>();

    public TileApiImpl() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public TextureSet registerTextureSet(String name, ResourceLocation ... textures) {
        TextureSet textureSet = new TextureSet(name, textures);
        TextureSetMap.instance().register(textureSet);
        return textureSet;
    }

    @Override
    public void setBiomeTexture(int biomeID, String textureSetName, ResourceLocation ... textures) {
        TextureSetMap.instance().register(new TextureSet(textureSetName, textures));
        this.setBiomeTexture(biomeID, textureSetName, new ResourceLocation[0]);
    }

    @Override
    public void setBiomeTexture(BiomeGenBase biome, String textureSetName, ResourceLocation ... textures) {
        this.setBiomeTexture(biome.field_76756_M, textureSetName, textures);
    }

    @Override
    public void setBiomeTexture(int biomeID, TextureSet textureSet) {
        BiomeTextureMap.instance().setTexture(biomeID, textureSet);
    }

    @Override
    public void setBiomeTexture(BiomeGenBase biome, TextureSet textureSet) {
        this.setBiomeTexture(biome.field_76756_M, textureSet);
    }

    @Override
    public void setCustomTileTexture(String uniqueTileName, ResourceLocation ... textures) {
        TextureSet set = new TextureSet(uniqueTileName, textures);
        TextureSetMap.instance().register(set);
        this.setCustomTileTexture(uniqueTileName, set);
    }

    @Override
    public void setCustomTileTexture(String uniqueTileName, TextureSet textureSet) {
        ExtTileTextureMap.instance().setTexture(uniqueTileName, textureSet);
    }

    @Override
    public void putBiomeTile(World world, int atlasID, int biomeID, int chunkX, int chunkZ) {
        int dimension = world.field_73011_w.func_177502_q();
        PutBiomeTilePacket packet = new PutBiomeTilePacket(atlasID, dimension, chunkX, chunkZ, biomeID);
        if (world.field_72995_K) {
            PacketDispatcher.sendToServer(packet);
        } else {
            AtlasData data = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, world);
            Tile tile = new Tile(biomeID);
            data.setTile(dimension, chunkX, chunkZ, tile);
            for (EntityPlayer syncedPlayer : data.getSyncedPlayers()) {
                PacketDispatcher.sendTo(new PutBiomeTilePacket(atlasID, dimension, chunkX, chunkZ, biomeID), (EntityPlayerMP)syncedPlayer);
            }
        }
    }

    @Override
    public void putBiomeTile(World world, int atlasID, BiomeGenBase biome, int chunkX, int chunkZ) {
        this.putBiomeTile(world, atlasID, biome.field_76756_M, chunkX, chunkZ);
    }

    @Override
    public void putCustomTile(World world, int atlasID, String tileName, int chunkX, int chunkZ) {
        if (tileName == null) {
            Log.error("Attempted to put custom tile with null name", new Object[0]);
            return;
        }
        if (world.field_72995_K) {
            int biomeID = ExtTileIdMap.instance().getPseudoBiomeID(tileName);
            if (biomeID != -1) {
                this.putBiomeTile(world, atlasID, biomeID, chunkX, chunkZ);
            } else {
                this.pendingTiles.put(tileName, new TileData(world, atlasID, chunkX, chunkZ));
                PacketDispatcher.sendToServer(new RegisterTileIdPacket(tileName));
            }
        } else {
            int biomeID = ExtTileIdMap.instance().getPseudoBiomeID(tileName);
            if (biomeID == -1) {
                biomeID = ExtTileIdMap.instance().getOrCreatePseudoBiomeID(tileName);
                TileNameIDPacket packet = new TileNameIDPacket();
                packet.put(tileName, biomeID);
                PacketDispatcher.sendToAll(packet);
            }
            this.putBiomeTile(world, atlasID, biomeID, chunkX, chunkZ);
        }
    }

    @Override
    public void putCustomGlobalTile(World world, String tileName, int chunkX, int chunkZ) {
        AbstractMessage.AbstractClientMessage packet;
        if (tileName == null) {
            Log.error("Attempted to put custom global tile with null name", new Object[0]);
            return;
        }
        if (world.field_72995_K) {
            Log.warn("Client attempted to put global tile", new Object[0]);
            return;
        }
        boolean isIdRegistered = ExtTileIdMap.instance().getPseudoBiomeID(tileName) != -1;
        int biomeID = ExtTileIdMap.instance().getOrCreatePseudoBiomeID(tileName);
        ExtBiomeData data = AntiqueAtlasMod.extBiomeData.getData();
        data.setBiomeIdAt(world.field_73011_w.func_177502_q(), chunkX, chunkZ, biomeID);
        if (!isIdRegistered) {
            packet = new TileNameIDPacket();
            ((TileNameIDPacket)packet).put(tileName, biomeID);
            PacketDispatcher.sendToAll(packet);
        }
        packet = new TilesPacket(world.field_73011_w.func_177502_q());
        ((TilesPacket)packet).addTile(chunkX, chunkZ, biomeID);
        PacketDispatcher.sendToAll(packet);
    }

    @SubscribeEvent
    public void onTileIdRegistered(TileIdRegisteredEvent event) {
        for (Map.Entry<String, Integer> entry : event.nameToIdMap.entrySet()) {
            TileData tile = this.pendingTiles.remove(entry.getKey());
            if (tile == null) continue;
            this.putBiomeTile(tile.world, tile.atlasID, entry.getValue(), tile.x, tile.z);
        }
    }

    @Override
    public void deleteCustomGlobalTile(World world, int chunkX, int chunkZ) {
        int dimension;
        if (world.field_72995_K) {
            Log.warn("Client attempted to delete global tile", new Object[0]);
            return;
        }
        ExtBiomeData data = AntiqueAtlasMod.extBiomeData.getData();
        if (data.getBiomeIdAt(dimension = world.field_73011_w.func_177502_q(), chunkX, chunkZ) != -1) {
            data.removeBiomeAt(dimension, chunkX, chunkZ);
            PacketDispatcher.sendToAll(new DeleteCustomGlobalTilePacket(dimension, chunkX, chunkZ));
        }
    }

    private static class TileData {
        World world;
        int atlasID;
        int x;
        int z;

        TileData(World world, int atlasID, int x, int z) {
            this.world = world;
            this.atlasID = atlasID;
            this.x = x;
            this.z = z;
        }
    }
}

