/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.util.SaveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureSetMap
extends SaveData {
    private static final TextureSetMap INSTANCE = new TextureSetMap();
    private final Map<String, TextureSet> map = new HashMap<String, TextureSet>();

    public static final TextureSetMap instance() {
        return INSTANCE;
    }

    public void register(TextureSet set) {
        TextureSet old = this.map.put(set.name, set);
        if (!set.equals(old)) {
            this.markDirty();
        }
    }

    public TextureSet createAndRegister(ResourceLocation ... textures) {
        TextureSet set = new TextureSet(UUID.randomUUID().toString(), textures);
        this.register(set);
        return set;
    }

    public TextureSet getByName(String name) {
        return this.map.get(name);
    }

    public TextureSet getByNameNonNull(String name) {
        TextureSet set = this.getByName(name);
        return set == null ? TextureSet.TEST : set;
    }

    public boolean isRegistered(String name) {
        return this.map.containsKey(name);
    }

    public Collection<TextureSet> getAllTextureSets() {
        return this.map.values();
    }

    public Collection<TextureSet> getAllNonStandardTextureSets() {
        ArrayList<TextureSet> list = new ArrayList<TextureSet>(this.map.size());
        for (TextureSet set : this.map.values()) {
            if (set.isStandard) continue;
            list.add(set);
        }
        return list;
    }
}

