/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.SubTile;
import hunternif.mc.atlas.client.SubTileQuartet;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.TileRenderIterator;
import hunternif.mc.atlas.client.gui.GuiArrowButton;
import hunternif.mc.atlas.client.gui.GuiBlinkingMarker;
import hunternif.mc.atlas.client.gui.GuiBookmarkButton;
import hunternif.mc.atlas.client.gui.GuiMarkerFinalizer;
import hunternif.mc.atlas.client.gui.GuiPositionButton;
import hunternif.mc.atlas.client.gui.GuiScaleBar;
import hunternif.mc.atlas.client.gui.ProgressBarOverlay;
import hunternif.mc.atlas.client.gui.core.GuiComponent;
import hunternif.mc.atlas.client.gui.core.GuiComponentButton;
import hunternif.mc.atlas.client.gui.core.GuiCursor;
import hunternif.mc.atlas.client.gui.core.GuiStates;
import hunternif.mc.atlas.client.gui.core.IButtonListener;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkerTextureMap;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.server.BrowsingPositionPacket;
import hunternif.mc.atlas.util.AtlasRenderHelper;
import hunternif.mc.atlas.util.ExportImageUtil;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.MathUtil;
import hunternif.mc.atlas.util.Rect;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiAtlas
extends GuiComponent {
    public static final int WIDTH = 310;
    public static final int HEIGHT = 218;
    private static final int CONTENT_X = 17;
    private static final int CONTENT_Y = 11;
    private static final int MAP_WIDTH = 276;
    private static final int MAP_HEIGHT = 194;
    private static final float PLAYER_ROTATION_STEPS = 16.0f;
    private static final int PLAYER_ICON_WIDTH = 7;
    private static final int PLAYER_ICON_HEIGHT = 8;
    public static final int MARKER_SIZE = 32;
    private static final int MARKER_RADIUS = 7;
    public static final double MIN_SCALE_THRESHOLD = 0.5;
    private long[] renderTimes = new long[30];
    private int renderTimesIndex = 0;
    private final GuiStates state = new GuiStates();
    private final GuiStates.IState NORMAL = new GuiStates.SimpleState();
    private final GuiStates.IState HIDING_MARKERS = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle(I18n.func_135052_a((String)"gui.antiqueatlas.showMarkers", (Object[])new Object[0]));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_SHOW_MARKERS);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle(I18n.func_135052_a((String)"gui.antiqueatlas.hideMarkers", (Object[])new Object[0]));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_HIDE_MARKERS);
        }
    };
    private final GuiStates.IState PLACING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnMarker.setSelected(false);
        }
    };
    private final GuiStates.IState DELETING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.field_146297_k.field_71417_B.func_74372_a();
            GuiAtlas.this.addChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.field_146297_k.field_71417_B.func_74373_b();
            GuiAtlas.this.removeChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(false);
        }
    };
    private final GuiCursor eraser = new GuiCursor();
    private final GuiStates.IState EXPORTING_IMAGE = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnExportPng.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnExportPng.setSelected(false);
        }
    };
    private final GuiArrowButton btnUp;
    private final GuiArrowButton btnDown;
    private final GuiArrowButton btnLeft;
    private final GuiArrowButton btnRight;
    private final GuiBookmarkButton btnExportPng;
    private final GuiBookmarkButton btnMarker;
    private final GuiBookmarkButton btnDelMarker;
    private final GuiBookmarkButton btnShowMarkers;
    private final GuiPositionButton btnPosition;
    private static final int BUTTON_PAUSE = 8;
    public static int navigateStep = 24;
    private GuiComponentButton selectedButton = null;
    private long timeButtonPressed = 0L;
    private boolean isDragging = false;
    private int dragMouseX;
    private int dragMouseY;
    private int dragMapOffsetX;
    private int dragMapOffsetY;
    private int mapOffsetX;
    private int mapOffsetY;
    private boolean followPlayer = true;
    private GuiScaleBar scaleBar = new GuiScaleBar();
    private double mapScale;
    private int tileHalfSize;
    private int tile2ChunkScale;
    private DimensionMarkersData localMarkersData;
    private DimensionMarkersData globalMarkersData;
    private Marker toDelete;
    private GuiMarkerFinalizer markerFinalizer = new GuiMarkerFinalizer();
    private GuiBlinkingMarker blinkingIcon = new GuiBlinkingMarker();
    private EntityPlayer player;
    private ItemStack stack;
    private DimensionData biomeData;
    private int screenScale;
    private ProgressBarOverlay progressBar = new ProgressBarOverlay(100, 2);

    public GuiAtlas() {
        this.setSize(310, 218);
        this.setMapScale(0.5);
        this.followPlayer = true;
        this.setInterceptKeyboard(false);
        this.btnUp = GuiArrowButton.up();
        this.addChild(this.btnUp).offsetGuiCoords(148, 10);
        this.btnDown = GuiArrowButton.down();
        this.addChild(this.btnDown).offsetGuiCoords(148, 194);
        this.btnLeft = GuiArrowButton.left();
        this.addChild(this.btnLeft).offsetGuiCoords(15, 100);
        this.btnRight = GuiArrowButton.right();
        this.addChild(this.btnRight).offsetGuiCoords(283, 100);
        this.btnPosition = new GuiPositionButton();
        this.btnPosition.setEnabled(!this.followPlayer);
        this.addChild(this.btnPosition).offsetGuiCoords(283, 194);
        IButtonListener positionListener = new IButtonListener(){

            public void onClick(GuiComponentButton button) {
                GuiAtlas.this.selectedButton = button;
                if (((Object)((Object)button)).equals((Object)GuiAtlas.this.btnPosition)) {
                    GuiAtlas.this.followPlayer = true;
                    GuiAtlas.this.btnPosition.setEnabled(false);
                } else {
                    GuiAtlas.this.navigateByButton(GuiAtlas.this.selectedButton);
                    GuiAtlas.this.timeButtonPressed = ((GuiAtlas)GuiAtlas.this).player.field_70170_p.func_82737_E();
                }
            }
        };
        this.btnUp.addListener(positionListener);
        this.btnDown.addListener(positionListener);
        this.btnLeft.addListener(positionListener);
        this.btnRight.addListener(positionListener);
        this.btnPosition.addListener(positionListener);
        this.btnExportPng = new GuiBookmarkButton(1, Textures.ICON_EXPORT, I18n.func_135052_a((String)"gui.antiqueatlas.exportImage", (Object[])new Object[0]));
        this.addChild(this.btnExportPng).offsetGuiCoords(300, 75);
        this.btnExportPng.addListener(new IButtonListener<GuiBookmarkButton>(){

            @Override
            public void onClick(GuiBookmarkButton button) {
                GuiAtlas.this.progressBar.reset();
                if (GuiAtlas.this.stack != null) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            GuiAtlas.this.exportImage(GuiAtlas.this.stack.func_77946_l());
                        }
                    }).start();
                }
            }
        });
        this.btnMarker = new GuiBookmarkButton(0, Textures.ICON_ADD_MARKER, I18n.func_135052_a((String)"gui.antiqueatlas.addMarker", (Object[])new Object[0]));
        this.addChild(this.btnMarker).offsetGuiCoords(300, 14);
        this.btnMarker.addListener(new IButtonListener(){

            public void onClick(GuiComponentButton button) {
                if (GuiAtlas.this.stack != null) {
                    if (GuiAtlas.this.state.is(GuiAtlas.this.PLACING_MARKER)) {
                        GuiAtlas.this.selectedButton = null;
                        GuiAtlas.this.state.switchTo(GuiAtlas.this.NORMAL);
                    } else {
                        GuiAtlas.this.selectedButton = button;
                        GuiAtlas.this.state.switchTo(GuiAtlas.this.PLACING_MARKER);
                    }
                }
            }
        });
        this.btnDelMarker = new GuiBookmarkButton(2, Textures.ICON_DELETE_MARKER, I18n.func_135052_a((String)"gui.antiqueatlas.delMarker", (Object[])new Object[0]));
        this.addChild(this.btnDelMarker).offsetGuiCoords(300, 33);
        this.btnDelMarker.addListener(new IButtonListener(){

            public void onClick(GuiComponentButton button) {
                if (GuiAtlas.this.stack != null) {
                    if (GuiAtlas.this.state.is(GuiAtlas.this.DELETING_MARKER)) {
                        GuiAtlas.this.selectedButton = null;
                        GuiAtlas.this.state.switchTo(GuiAtlas.this.NORMAL);
                    } else {
                        GuiAtlas.this.selectedButton = button;
                        GuiAtlas.this.state.switchTo(GuiAtlas.this.DELETING_MARKER);
                    }
                }
            }
        });
        this.btnShowMarkers = new GuiBookmarkButton(3, Textures.ICON_HIDE_MARKERS, I18n.func_135052_a((String)"gui.antiqueatlas.hideMarkers", (Object[])new Object[0]));
        this.addChild(this.btnShowMarkers).offsetGuiCoords(300, 52);
        this.btnShowMarkers.addListener(new IButtonListener(){

            public void onClick(GuiComponentButton button) {
                if (GuiAtlas.this.stack != null) {
                    GuiAtlas.this.selectedButton = null;
                    GuiAtlas.this.state.switchTo(GuiAtlas.this.state.is(GuiAtlas.this.HIDING_MARKERS) ? GuiAtlas.this.NORMAL : GuiAtlas.this.HIDING_MARKERS);
                }
            }
        });
        this.addChild(this.scaleBar).offsetGuiCoords(20, 198);
        this.scaleBar.setMapScale(1.0);
        this.markerFinalizer.addListener(this.blinkingIcon);
        this.eraser.setTexture(Textures.ERASER, 12, 14, 2, 11);
    }

    public GuiAtlas setAtlasItemStack(ItemStack stack) {
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.stack = stack;
        this.updateAtlasData();
        if (!this.followPlayer && AntiqueAtlasMod.settings.doSaveBrowsingPos) {
            this.loadSavedBrowsingPosition();
        }
        return this;
    }

    public void loadSavedBrowsingPosition() {
        this.setMapScale(this.biomeData.getBrowsingZoom());
        this.mapOffsetX = this.biomeData.getBrowsingX();
        this.mapOffsetY = this.biomeData.getBrowsingY();
        this.isDragging = false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.state.switchTo(this.NORMAL);
        Keyboard.enableRepeatEvents((boolean)true);
        this.screenScale = new ScaledResolution(this.field_146297_k).func_78325_e();
        this.setCentered();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseState) throws IOException {
        boolean isMouseOverMap;
        super.func_73864_a(mouseX, mouseY, mouseState);
        if (this.state.is(this.EXPORTING_IMAGE)) {
            return;
        }
        int mapX = (this.field_146294_l - 276) / 2;
        int mapY = (this.field_146295_m - 194) / 2;
        boolean bl = isMouseOverMap = mouseX >= mapX && mouseX <= mapX + 276 && mouseY >= mapY && mouseY <= mapY + 194;
        if (!this.state.is(this.NORMAL) && !this.state.is(this.HIDING_MARKERS)) {
            if (this.state.is(this.PLACING_MARKER) && isMouseOverMap && mouseState == 0) {
                this.markerFinalizer.setMarkerData(this.player.field_70170_p, this.stack.func_77952_i(), this.player.field_71093_bK, this.screenXToWorldX(mouseX), this.screenYToWorldZ(mouseY));
                this.addChild(this.markerFinalizer);
                this.blinkingIcon.setTexture(MarkerTextureMap.instance().getTexture(this.markerFinalizer.selectedType), 32, 32);
                this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords(mouseX - this.getGuiX() - 16, mouseY - this.getGuiY() - 16);
                this.setInterceptKeyboard(true);
                KeyBinding.func_74506_a();
            } else if (this.state.is(this.DELETING_MARKER) && this.toDelete != null && isMouseOverMap && mouseState == 0) {
                AtlasAPI.markers.deleteMarker(this.player.field_70170_p, this.stack.func_77952_i(), this.toDelete.getId());
            }
            this.state.switchTo(this.NORMAL);
        } else if (isMouseOverMap && this.selectedButton == null) {
            this.isDragging = true;
            this.dragMouseX = mouseX;
            this.dragMouseY = mouseY;
            this.dragMapOffsetX = this.mapOffsetX;
            this.dragMapOffsetY = this.mapOffsetY;
        }
    }

    private void exportImage(ItemStack stack) {
        boolean showMarkers = !this.state.is(this.HIDING_MARKERS);
        this.state.switchTo(this.EXPORTING_IMAGE);
        File file = ExportImageUtil.selectPngFileToSave("Atlas " + stack.func_77952_i(), this.progressBar);
        if (file != null) {
            try {
                Log.info("Exporting image from Atlas #%d to file %s", stack.func_77952_i(), file.getAbsolutePath());
                ExportImageUtil.exportPngImage(this.biomeData, this.globalMarkersData, this.localMarkersData, file, this.progressBar, showMarkers);
                Log.info("Finished exporting image", new Object[0]);
            }
            catch (OutOfMemoryError e) {
                Log.error(e, "Image is too large", new Object[0]);
                this.progressBar.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.tooLarge", (Object[])new Object[0]));
                return;
            }
        }
        this.state.switchTo(showMarkers ? this.NORMAL : this.HIDING_MARKERS);
    }

    @Override
    public void func_146282_l() throws IOException {
        super.func_146282_l();
        if (Keyboard.getEventKeyState()) {
            int key = Keyboard.getEventKey();
            if (key == 200) {
                this.navigateMap(0, navigateStep);
            } else if (key == 208) {
                this.navigateMap(0, -navigateStep);
            } else if (key == 203) {
                this.navigateMap(navigateStep, 0);
            } else if (key == 205) {
                this.navigateMap(-navigateStep, 0);
            } else if (key == 78 || key == 13) {
                this.setMapScale(this.mapScale * 2.0);
            } else if (key == 74 || key == 12) {
                this.setMapScale(this.mapScale / 2.0);
            } else {
                KeyBinding[] hotbarKeys;
                for (KeyBinding bind : hotbarKeys = this.field_146297_k.field_71474_y.field_151456_ac) {
                    if (key != bind.func_151463_i()) continue;
                    this.close();
                    break;
                }
            }
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheelMove = Mouse.getEventDWheel();
        if (wheelMove != 0) {
            int n = wheelMove = wheelMove > 0 ? 1 : -1;
            if (AntiqueAtlasMod.settings.doReverseWheelZoom) {
                wheelMove *= -1;
            }
            this.setMapScale(this.mapScale * Math.pow(2.0, wheelMove));
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseState) {
        super.func_146286_b(mouseX, mouseY, mouseState);
        if (mouseState != -1) {
            this.selectedButton = null;
            this.isDragging = false;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int lastMouseButton, long timeSinceMouseClick) {
        super.func_146273_a(mouseX, mouseY, lastMouseButton, timeSinceMouseClick);
        if (this.isDragging) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
            this.mapOffsetX = this.dragMapOffsetX + mouseX - this.dragMouseX;
            this.mapOffsetY = this.dragMapOffsetY + mouseY - this.dragMouseY;
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.player == null) {
            return;
        }
        if (this.followPlayer) {
            this.mapOffsetX = (int)(-this.player.field_70165_t * this.mapScale);
            this.mapOffsetY = (int)(-this.player.field_70161_v * this.mapScale);
        }
        if (this.player.field_70170_p.func_82737_E() > this.timeButtonPressed + 8L) {
            this.navigateByButton(this.selectedButton);
        }
        this.updateAtlasData();
    }

    private void updateAtlasData() {
        this.biomeData = AntiqueAtlasMod.atlasData.getAtlasData(this.stack, this.player.field_70170_p).getDimensionData(this.player.field_71093_bK);
        this.globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInDimension(this.player.field_71093_bK);
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(this.stack, this.player.field_70170_p);
        this.localMarkersData = markersData != null ? markersData.getMarkersDataInDimension(this.player.field_71093_bK) : null;
    }

    private void navigateByButton(GuiComponentButton btn) {
        if (btn == null) {
            return;
        }
        if (((Object)((Object)btn)).equals((Object)this.btnUp)) {
            this.navigateMap(0, navigateStep);
        } else if (((Object)((Object)btn)).equals((Object)this.btnDown)) {
            this.navigateMap(0, -navigateStep);
        } else if (((Object)((Object)btn)).equals((Object)this.btnLeft)) {
            this.navigateMap(navigateStep, 0);
        } else if (((Object)((Object)btn)).equals((Object)this.btnRight)) {
            this.navigateMap(-navigateStep, 0);
        }
    }

    public void navigateMap(int dx, int dy) {
        this.mapOffsetX += dx;
        this.mapOffsetY += dy;
        this.followPlayer = false;
        this.btnPosition.setEnabled(true);
    }

    public void setMapScale(double scale) {
        double oldScale = this.mapScale;
        this.mapScale = scale;
        if (this.mapScale < AntiqueAtlasMod.settings.minScale) {
            this.mapScale = AntiqueAtlasMod.settings.minScale;
        }
        if (this.mapScale > AntiqueAtlasMod.settings.maxScale) {
            this.mapScale = AntiqueAtlasMod.settings.maxScale;
        }
        if (this.mapScale >= 0.5) {
            this.tileHalfSize = (int)Math.round(8.0 * this.mapScale);
            this.tile2ChunkScale = 1;
        } else {
            this.tileHalfSize = (int)Math.round(4.0);
            this.tile2ChunkScale = (int)Math.round(0.5 / this.mapScale);
        }
        this.scaleBar.setMapScale(this.mapScale * 2.0);
        this.mapOffsetX = (int)((double)this.mapOffsetX * (this.mapScale / oldScale));
        this.mapOffsetY = (int)((double)this.mapOffsetY * (this.mapScale / oldScale));
        this.dragMapOffsetX = (int)((double)this.dragMapOffsetX * (this.mapScale / oldScale));
        this.dragMapOffsetY = (int)((double)this.dragMapOffsetY * (this.mapScale / oldScale));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        if (AntiqueAtlasMod.settings.debugRender) {
            this.renderTimes[this.renderTimesIndex++] = System.currentTimeMillis();
            if (this.renderTimesIndex == this.renderTimes.length) {
                this.renderTimesIndex = 0;
                double elapsed = 0.0;
                for (int i = 0; i < this.renderTimes.length - 1; ++i) {
                    elapsed += (double)(this.renderTimes[i + 1] - this.renderTimes[i]);
                }
                System.out.printf("GuiAtlas avg. render time: %.3f\n", elapsed / (double)this.renderTimes.length);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK, this.getGuiX(), this.getGuiY(), 310, 218);
        if (this.stack == null || this.biomeData == null) {
            return;
        }
        if (this.state.is(this.DELETING_MARKER)) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((this.getGuiX() + 17) * this.screenScale), (int)(this.field_146297_k.field_71440_d - (this.getGuiY() + 11 + 194) * this.screenScale), (int)(276 * this.screenScale), (int)(194 * this.screenScale));
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int mapStartX = MathUtil.roundToBase((int)Math.floor(-(138.0 + (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartZ = MathUtil.roundToBase((int)Math.floor(-(97.0 + (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndX = MathUtil.roundToBase((int)Math.ceil((138.0 - (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndZ = MathUtil.roundToBase((int)Math.ceil((97.0 - (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartScreenX = this.getGuiX() + 155 + (int)((double)(mapStartX << 4) * this.mapScale) + this.mapOffsetX;
        int mapStartScreenY = this.getGuiY() + 109 + (int)((double)(mapStartZ << 4) * this.mapScale) + this.mapOffsetY;
        TileRenderIterator iter = new TileRenderIterator(this.biomeData);
        iter.setScope(new Rect().setOrigin(mapStartX, mapStartZ).set(mapStartX, mapStartZ, mapEndX, mapEndZ));
        iter.setStep(this.tile2ChunkScale);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                AtlasRenderHelper.drawAutotileCorner(BiomeTextureMap.instance().getTexture(subtile.tile), mapStartScreenX + subtile.x * this.tileHalfSize, mapStartScreenY + subtile.y * this.tileHalfSize, subtile.getTextureU(), subtile.getTextureV(), this.tileHalfSize);
            }
        }
        if (!this.state.is(this.HIDING_MARKERS)) {
            List<Marker> markers;
            int z;
            int x;
            int markersStartX = MathUtil.roundToBase(mapStartX, 8) / 8 - 1;
            int markersStartZ = MathUtil.roundToBase(mapStartZ, 8) / 8 - 1;
            int markersEndX = MathUtil.roundToBase(mapEndX, 8) / 8 + 1;
            int markersEndZ = MathUtil.roundToBase(mapEndZ, 8) / 8 + 1;
            double iconScale = this.getIconScale();
            for (x = markersStartX; x <= markersEndX; ++x) {
                for (z = markersStartZ; z <= markersEndZ; ++z) {
                    markers = this.globalMarkersData.getMarkersAtChunk(x, z);
                    if (markers == null) continue;
                    for (Marker marker : markers) {
                        this.renderMarker(marker, iconScale);
                    }
                }
            }
            if (this.localMarkersData != null) {
                for (x = markersStartX; x <= markersEndX; ++x) {
                    for (z = markersStartZ; z <= markersEndZ; ++z) {
                        markers = this.localMarkersData.getMarkersAtChunk(x, z);
                        if (markers == null) continue;
                        for (Marker marker : markers) {
                            this.renderMarker(marker, iconScale);
                        }
                    }
                }
            }
        }
        GL11.glDisable((int)3089);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK_FRAME, this.getGuiX(), this.getGuiY(), 310, 218);
        double iconScale = this.getIconScale();
        if (!this.state.is(this.HIDING_MARKERS)) {
            int playerOffsetX = (int)(this.player.field_70165_t * this.mapScale) + this.mapOffsetX;
            int playerOffsetZ = (int)(this.player.field_70161_v * this.mapScale) + this.mapOffsetY;
            if (playerOffsetX < -138) {
                playerOffsetX = -138;
            }
            if (playerOffsetX > 138) {
                playerOffsetX = 138;
            }
            if (playerOffsetZ < -97) {
                playerOffsetZ = -97;
            }
            if (playerOffsetZ > 95) {
                playerOffsetZ = 95;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.state.is(this.PLACING_MARKER) ? 0.5f : 1.0f));
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.getGuiX() + 155 + playerOffsetX), (float)(this.getGuiY() + 109 + playerOffsetZ), (float)0.0f);
            float playerRotation = (float)Math.round(this.player.field_70177_z / 360.0f * 16.0f) / 16.0f * 360.0f;
            GlStateManager.func_179114_b((float)(180.0f + playerRotation), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-3.0 * iconScale), (double)(-4.0 * iconScale), (double)0.0);
            AtlasRenderHelper.drawFullTexture(Textures.PLAYER, 0.0, 0.0, (int)Math.round(7.0 * iconScale), (int)Math.round(8.0 * iconScale));
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        super.func_73863_a(mouseX, mouseY, par3);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (this.state.is(this.PLACING_MARKER)) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            AtlasRenderHelper.drawFullTexture(MarkerTextureMap.instance().getTexture(this.markerFinalizer.selectedType), (double)mouseX - 16.0 * iconScale, (double)mouseY - 16.0 * iconScale, (int)Math.round(32.0 * iconScale), (int)Math.round(32.0 * iconScale));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.state.is(this.EXPORTING_IMAGE)) {
            this.func_146276_q_();
            this.progressBar.draw((this.field_146294_l - 100) / 2, this.field_146295_m / 2 - 34);
        }
    }

    private void renderMarker(Marker marker, double scale) {
        int markerX = this.worldXToScreenX(marker.getX());
        int markerY = this.worldZToScreenY(marker.getZ());
        if (!marker.isVisibleAhead() && !this.biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        boolean mouseIsOverMarker = this.isMouseInRadius(markerX, markerY, (int)Math.ceil(7.0 * scale));
        if (this.state.is(this.PLACING_MARKER)) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else if (this.state.is(this.DELETING_MARKER)) {
            if (marker.isGlobal()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            } else if (mouseIsOverMarker) {
                GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                this.toDelete = marker;
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.toDelete == marker) {
                    this.toDelete = null;
                }
            }
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        AtlasRenderHelper.drawFullTexture(MarkerTextureMap.instance().getTexture(marker.getType()), (double)markerX - 16.0 * scale, (double)markerY - 16.0 * scale, (int)Math.round(32.0 * scale), (int)Math.round(32.0 * scale));
        if (this.isMouseOver && mouseIsOverMarker && marker.getLabel().length() > 0) {
            this.drawTooltip(Arrays.asList(marker.getLocalizedLabel()), this.field_146297_k.field_71466_p);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        this.removeChild(this.markerFinalizer);
        this.removeChild(this.blinkingIcon);
        Keyboard.enableRepeatEvents((boolean)false);
        this.biomeData.setBrowsingPosition(this.mapOffsetX, this.mapOffsetY, this.mapScale);
        PacketDispatcher.sendToServer(new BrowsingPositionPacket(this.stack.func_77952_i(), this.player.field_71093_bK, this.mapOffsetX, this.mapOffsetY, this.mapScale));
    }

    private int screenXToWorldX(int mouseX) {
        return (int)Math.round((double)(mouseX - this.field_146294_l / 2 - this.mapOffsetX) / this.mapScale);
    }

    private int screenYToWorldZ(int mouseY) {
        return (int)Math.round((double)(mouseY - this.field_146295_m / 2 - this.mapOffsetY) / this.mapScale);
    }

    private int worldXToScreenX(int x) {
        return (int)Math.round((double)x * this.mapScale + (double)(this.field_146294_l / 2) + (double)this.mapOffsetX);
    }

    private int worldZToScreenY(int z) {
        return (int)Math.round((double)z * this.mapScale + (double)(this.field_146295_m / 2) + (double)this.mapOffsetY);
    }

    @Override
    protected void onChildClosed(GuiComponent child) {
        if (((Object)((Object)child)).equals((Object)this.markerFinalizer)) {
            this.setInterceptKeyboard(false);
            this.removeChild(this.blinkingIcon);
        }
    }

    public void updateL18n() {
        this.btnExportPng.setTitle(I18n.func_135052_a((String)"gui.antiqueatlas.exportImage", (Object[])new Object[0]));
        this.btnMarker.setTitle(I18n.func_135052_a((String)"gui.antiqueatlas.addMarker", (Object[])new Object[0]));
    }

    private double getIconScale() {
        return AntiqueAtlasMod.settings.doScaleMarkers ? (this.mapScale < 0.5 ? 0.5 : (this.mapScale > 1.0 ? 2.0 : 1.0)) : 1.0;
    }
}

