/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui.core;

import hunternif.mc.atlas.client.gui.core.GuiComponent;
import hunternif.mc.atlas.client.gui.core.GuiViewport;
import java.io.IOException;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public abstract class AGuiScrollbar
extends GuiComponent {
    protected ResourceLocation texture;
    protected int textureWidth;
    protected int textureHeight;
    protected int capLength;
    protected int textureBodyLength;
    private static int scrollStep = 18;
    protected boolean visible = false;
    private boolean isDragged = false;
    private boolean wasClicking = false;
    private boolean usesWheel = true;
    private float contentRatio = 1.0f;
    private float scrollRatio = 0.0f;
    protected int anchorPos = 0;
    protected int anchorSize;
    protected double bodyTextureScale = 1.0;
    protected int scrollPos = 0;
    protected final GuiViewport viewport;

    public AGuiScrollbar(GuiViewport viewport) {
        this.viewport = viewport;
    }

    public void setTexture(ResourceLocation texture, int width, int height, int capLength) {
        this.texture = texture;
        this.textureWidth = width;
        this.textureHeight = height;
        this.capLength = capLength;
        this.textureBodyLength = this.getTextureLength() - capLength * 2;
        this.setScrollbarWidth(width, height);
    }

    public void setUsesWheel(boolean value) {
        this.usesWheel = value;
    }

    public void updateContent() {
        this.contentRatio = (float)this.getViewportSize() / (float)this.getContentSize();
        this.visible = this.contentRatio < 1.0f;
        this.updateAnchorSize();
        this.updateAnchorPos();
    }

    public void setScrollPos(int scrollPos) {
        this.viewport.content.validateSize();
        this.viewport.validateSize();
        this.doSetScrollPos(scrollPos);
    }

    private void doSetScrollPos(int scrollPos) {
        this.scrollPos = scrollPos = Math.max(0, Math.min(scrollPos, this.getContentSize() - this.getViewportSize()));
        this.scrollRatio = (float)scrollPos / (float)(this.getContentSize() - this.getViewportSize());
        this.updateAnchorPos();
    }

    public void setScrollRatio(float scrollRatio) {
        this.viewport.content.validateSize();
        this.viewport.validateSize();
        this.doSetScrollRatio(scrollRatio);
    }

    private void doSetScrollRatio(float scrollRatio) {
        if (scrollRatio < 0.0f) {
            scrollRatio = 0.0f;
        }
        if (scrollRatio > 1.0f) {
            scrollRatio = 1.0f;
        }
        this.scrollRatio = scrollRatio;
        this.scrollPos = Math.round(scrollRatio * (float)(this.getContentSize() - this.getViewportSize()));
        this.updateAnchorPos();
    }

    @Override
    public void func_146274_d() throws IOException {
        int wheelMove;
        super.func_146274_d();
        if (this.usesWheel && (wheelMove = Mouse.getEventDWheel()) != 0 && this.visible) {
            wheelMove = wheelMove > 0 ? -1 : 1;
            this.doSetScrollPos(this.scrollPos + wheelMove * scrollStep);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            this.isDragged = false;
            return;
        }
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && mouseDown && this.isMouseOver) {
            this.isDragged = true;
        }
        if (!mouseDown) {
            this.isDragged = false;
        }
        this.wasClicking = mouseDown;
        if (this.isDragged) {
            this.doSetScrollRatio((float)(this.getMousePos(mouseX, mouseY) - this.anchorSize / 2) / (float)(this.getScrollbarLength() - this.anchorSize));
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawAnchor();
        GlStateManager.func_179084_k();
    }

    private void updateAnchorSize() {
        this.anchorSize = Math.max(this.capLength * 2, Math.round(Math.min(1.0f, this.contentRatio) * (float)this.getScrollbarLength()));
        this.bodyTextureScale = (double)(this.anchorSize - this.capLength * 2) / (double)this.textureBodyLength;
    }

    private void updateAnchorPos() {
        this.anchorPos = Math.round(this.scrollRatio * (float)(this.getViewportSize() - this.anchorSize));
        this.updateContentPos();
    }

    protected abstract int getTextureLength();

    protected abstract int getScrollbarLength();

    protected abstract int getViewportSize();

    protected abstract int getContentSize();

    protected abstract int getMousePos(int var1, int var2);

    protected abstract void drawAnchor();

    protected abstract void updateContentPos();

    protected abstract void setScrollbarWidth(int var1, int var2);
}

