/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.MapDataPacket;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class AtlasData
extends WorldSavedData {
    private static final int VERSION = 2;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_DIMENSION_MAP_LIST = "qDimensionMap";
    private static final String TAG_DIMENSION_ID = "qDimensionID";
    private static final String TAG_VISITED_CHUNKS = "qVisitedChunks";
    private static final String TAG_BROWSING_X = "qBrowseX";
    private static final String TAG_BROWSING_Y = "qBrowseY";
    private static final String TAG_BROWSING_ZOOM = "qBrowseZoom";
    private Map<Integer, DimensionData> dimensionMap = new ConcurrentHashMap<Integer, DimensionData>(2, 0.75f, 2);
    private final Set<EntityPlayer> playersSentTo = new HashSet<EntityPlayer>();
    private NBTTagCompound nbt;

    public AtlasData(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.nbt = compound;
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 2) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 2);
            this.func_76185_a();
        }
        NBTTagList dimensionMapList = compound.func_150295_c(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.func_74745_c(); ++d) {
            NBTTagCompound dimTag = dimensionMapList.func_150305_b(d);
            int dimensionID = dimTag.func_74762_e(TAG_DIMENSION_ID);
            int[] intArray = dimTag.func_74759_k(TAG_VISITED_CHUNKS);
            DimensionData dimData = this.getDimensionData(dimensionID);
            for (int i = 0; i < intArray.length; i += 3) {
                dimData.setTile(intArray[i], intArray[i + 1], new Tile(intArray[i + 2]));
            }
            double zoom = (double)dimTag.func_74762_e(TAG_BROWSING_ZOOM) / 1024.0;
            if (zoom == 0.0) {
                zoom = 0.5;
            }
            dimData.setBrowsingPosition(dimTag.func_74762_e(TAG_BROWSING_X), dimTag.func_74762_e(TAG_BROWSING_Y), zoom);
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        compound.func_74768_a(TAG_VERSION, 2);
        NBTTagList dimensionMapList = new NBTTagList();
        for (Map.Entry<Integer, DimensionData> dimensionEntry : this.dimensionMap.entrySet()) {
            NBTTagCompound dimTag = new NBTTagCompound();
            dimTag.func_74768_a(TAG_DIMENSION_ID, dimensionEntry.getKey().intValue());
            DimensionData dimData = dimensionEntry.getValue();
            Map<ShortVec2, Tile> seenChunks = dimData.getSeenChunks();
            int[] intArray = new int[seenChunks.size() * 3];
            int i = 0;
            for (Map.Entry<ShortVec2, Tile> entry : seenChunks.entrySet()) {
                intArray[i++] = entry.getKey().x;
                intArray[i++] = entry.getKey().y;
                intArray[i++] = entry.getValue().biomeID;
            }
            dimTag.func_74783_a(TAG_VISITED_CHUNKS, intArray);
            dimTag.func_74768_a(TAG_BROWSING_X, dimData.getBrowsingX());
            dimTag.func_74768_a(TAG_BROWSING_Y, dimData.getBrowsingY());
            dimTag.func_74768_a(TAG_BROWSING_ZOOM, (int)Math.round(dimData.getBrowsingZoom() * 1024.0));
            dimensionMapList.func_74742_a((NBTBase)dimTag);
        }
        compound.func_74782_a(TAG_DIMENSION_MAP_LIST, (NBTBase)dimensionMapList);
    }

    public void setTile(int dimension, int x, int y, Tile tile) {
        DimensionData dimData = this.getDimensionData(dimension);
        dimData.setTile(x, y, tile);
    }

    public Tile removeTile(int dimension, int x, int y) {
        DimensionData dimData = this.getDimensionData(dimension);
        return dimData.removeTile(x, y);
    }

    public Set<Integer> getVisitedDimensions() {
        return this.dimensionMap.keySet();
    }

    public DimensionData getDimensionData(int dimension) {
        DimensionData dimData = this.dimensionMap.get(dimension);
        if (dimData == null) {
            dimData = new DimensionData(this, dimension);
            this.dimensionMap.put(dimension, dimData);
        }
        return dimData;
    }

    public Map<ShortVec2, Tile> getSeenChunksInDimension(int dimension) {
        return this.getDimensionData(dimension).getSeenChunks();
    }

    public Collection<EntityPlayer> getSyncedPlayers() {
        return Collections.unmodifiableCollection(this.playersSentTo);
    }

    public boolean isSyncedOnPlayer(EntityPlayer player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, EntityPlayer player) {
        if (this.nbt == null) {
            this.nbt = new NBTTagCompound();
        }
        this.func_76187_b(this.nbt);
        PacketDispatcher.sendTo(new MapDataPacket(atlasID, this.nbt), (EntityPlayerMP)player);
        Log.info("Sent Atlas #%d data to player %s", atlasID, player.func_174793_f().func_70005_c_());
        this.playersSentTo.add(player);
    }

    public boolean isEmpty() {
        return this.dimensionMap.isEmpty();
    }
}

