/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.util.ByteUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class BiomeDetectorNether
extends BiomeDetectorBase
implements IBiomeDetector {
    private static final int airProbeLevel = 50;
    private static final int lavaSeaLevel = 31;
    private static final int priorityLava = 1;

    @Override
    public int getBiomeID(Chunk chunk) {
        BiomeGenBase[] biomes = BiomeGenBase.func_150565_n();
        int[] chunkBiomes = ByteUtil.unsignedByteToIntArray(chunk.func_76605_m());
        int[] biomeOccurrences = new int[biomes.length];
        int lavaOccurences = 0;
        int groundOccurences = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int biomeID = chunkBiomes[x << 4 | z];
                if (biomeID == BiomeGenBase.field_76778_j.field_76756_M) {
                    Block netherBlock = chunk.func_177438_a(x, 31, z);
                    if (netherBlock == Blocks.field_150353_l) {
                        ++lavaOccurences;
                        continue;
                    }
                    netherBlock = chunk.func_177438_a(x, 50, z);
                    if (netherBlock == null || netherBlock == Blocks.field_150350_a) {
                        ++groundOccurences;
                        continue;
                    }
                    int n = biomeID;
                    biomeOccurrences[n] = biomeOccurrences[n] + 1;
                    continue;
                }
                if (biomeID < 0 || biomeID >= biomes.length || biomes[biomeID] == null) continue;
                int n = biomeID;
                biomeOccurrences[n] = biomeOccurrences[n] + this.priorityForBiome(biomes[biomeID]);
            }
        }
        int meanBiomeId = -1;
        int meanBiomeOccurences = 0;
        for (int i = 0; i < biomeOccurrences.length; ++i) {
            if (biomeOccurrences[i] <= meanBiomeOccurences) continue;
            meanBiomeId = i;
            meanBiomeOccurences = biomeOccurrences[i];
        }
        if (meanBiomeOccurences < lavaOccurences) {
            meanBiomeId = ExtTileIdMap.instance().getPseudoBiomeID("lava");
        } else if (meanBiomeOccurences < groundOccurences) {
            meanBiomeId = ExtTileIdMap.instance().getPseudoBiomeID("lavaShore");
        }
        return meanBiomeId;
    }
}

