/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.item;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.core.BiomeDetectorNether;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.marker.MarkersData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ItemAtlas
extends Item {
    protected static final String WORLD_ATLAS_DATA_ID = "aAtlas";
    private final Map<Integer, IBiomeDetector> biomeAnalyzers = new HashMap<Integer, IBiomeDetector>();
    private final BiomeDetectorBase biomeDetectorOverworld = new BiomeDetectorBase();
    private final BiomeDetectorNether biomeDetectorNether = new BiomeDetectorNether();
    private SettingsConfig settings;

    public ItemAtlas(SettingsConfig settings) {
        this.settings = settings;
        this.biomeDetectorOverworld.setScanPonds(settings.doScanPonds);
        this.setBiomeDetectorForDimension(0, this.biomeDetectorOverworld);
        this.setBiomeDetectorForDimension(-1, this.biomeDetectorNether);
        this.func_77627_a(true);
    }

    public void setBiomeDetectorForDimension(int dimension, IBiomeDetector biomeAnalyzer) {
        this.biomeAnalyzers.put(dimension, biomeAnalyzer);
    }

    private IBiomeDetector getBiomeDetectorForDimension(int dimension) {
        IBiomeDetector biomeAnalyzer = this.biomeAnalyzers.get(dimension);
        return biomeAnalyzer == null ? this.biomeDetectorOverworld : biomeAnalyzer;
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack) + " #" + stack.func_77952_i();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            AntiqueAtlasMod.proxy.openAtlasGUI(stack);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isEquipped) {
        AtlasData data = AntiqueAtlasMod.atlasData.getAtlasData(stack, world);
        if (data == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!(world.field_72995_K || data.isSyncedOnPlayer(player) || data.isEmpty())) {
            data.syncOnPlayer(stack.func_77952_i(), player);
        }
        MarkersData markers = AntiqueAtlasMod.markersData.getMarkersData(stack, world);
        if (!(world.field_72995_K || markers.isSyncedOnPlayer(player) || markers.isEmpty())) {
            markers.syncOnPlayer(stack.func_77952_i(), player);
        }
        markers = null;
        int newScanInterval = Math.round(this.settings.newScanInterval * 20.0f);
        int rescanInterval = newScanInterval * this.settings.rescanRate;
        if (player.field_70173_aa % newScanInterval != 0) {
            return;
        }
        int playerX = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
        int playerZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
        DimensionData seenChunks = data.getDimensionData(player.field_71093_bK);
        IBiomeDetector biomeDetector = this.getBiomeDetectorForDimension(player.field_71093_bK);
        int scanRadius = this.settings.scanRadius;
        for (double dx = (double)(-scanRadius); dx <= (double)scanRadius; dx += 1.0) {
            for (double dz = (double)(-scanRadius); dz <= (double)scanRadius; dz += 1.0) {
                if (dx * dx + dz * dz > (double)(scanRadius * scanRadius)) continue;
                int x = (int)((double)playerX + dx);
                int z = (int)((double)playerZ + dz);
                Tile oldTile = seenChunks.getTile(x, z);
                int biomeId = AntiqueAtlasMod.extBiomeData.getData().getBiomeIdAt(player.field_71093_bK, x, z);
                if (biomeId == -1) {
                    Chunk chunk = player.field_70170_p.func_72964_e(x, z);
                    if (this.settings.forceChunkLoading && !chunk.func_177410_o()) {
                        player.field_70170_p.func_72863_F().func_73154_d(x << 4, z << 4);
                    }
                    if (!chunk.func_177410_o()) continue;
                    if (oldTile != null) {
                        if (!this.settings.doRescan || player.field_70173_aa % rescanInterval != 0) continue;
                        biomeId = biomeDetector.getBiomeID(chunk);
                        if (biomeId == -1) {
                            data.removeTile(player.field_71093_bK, x, z);
                            continue;
                        }
                        if (oldTile.biomeID == biomeId) continue;
                        data.setTile(player.field_71093_bK, x, z, new Tile(biomeId));
                        continue;
                    }
                    biomeId = biomeDetector.getBiomeID(chunk);
                    if (biomeId == -1) continue;
                    data.setTile(player.field_71093_bK, x, z, new Tile(biomeId));
                    continue;
                }
                if (oldTile != null && oldTile.biomeID == biomeId) continue;
                data.setTile(player.field_71093_bK, x, z, new Tile(biomeId));
                data.func_76185_a();
            }
        }
    }
}

