/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hunternif.mc.atlas.marker.MarkerTextureMap;
import hunternif.mc.atlas.util.AbstractJSONConfig;
import java.io.File;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MarkerTextureConfig
extends AbstractJSONConfig<MarkerTextureMap> {
    private static final int VERSION = 1;

    public MarkerTextureConfig(File file) {
        super(file);
    }

    @Override
    public int currentVersion() {
        return 1;
    }

    @Override
    protected void loadData(JsonObject json, MarkerTextureMap data, int version) {
        for (Map.Entry entry : json.entrySet()) {
            String markerType = (String)entry.getKey();
            ResourceLocation texture = new ResourceLocation(((JsonElement)entry.getValue()).getAsString());
            data.setTexture(markerType, texture);
        }
    }

    @Override
    protected void saveData(JsonObject json, MarkerTextureMap data) {
        PriorityQueue<String> queue = new PriorityQueue<String>(data.textureMap.keySet());
        while (!queue.isEmpty()) {
            String markerType = (String)queue.poll();
            json.addProperty(markerType, ((ResourceLocation)data.textureMap.get(markerType)).toString());
        }
    }
}

