/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.util.SaveData;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MarkerTextureMap
extends SaveData {
    private static final MarkerTextureMap INSTANCE = new MarkerTextureMap();
    final SortedMap<String, ResourceLocation> textureMap = new TreeMap<String, ResourceLocation>();
    public static final ResourceLocation defaultTexture = Textures.MARKER_RED_X_SMALL;

    public static MarkerTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(String markerType, ResourceLocation texture) {
        ResourceLocation oldTexture = (ResourceLocation)this.textureMap.get(markerType);
        if (!texture.equals((Object)oldTexture)) {
            this.textureMap.put(markerType, texture);
            this.markDirty();
        }
    }

    public ResourceLocation getTexture(String markerType) {
        ResourceLocation texture = (ResourceLocation)this.textureMap.get(markerType);
        return texture == null ? defaultTexture : texture;
    }

    public boolean isRegistered(String markerType) {
        return this.textureMap.containsKey(markerType);
    }

    public Collection<String> getAllTypes() {
        return this.textureMap.keySet();
    }

    public Collection<ResourceLocation> getAllTextures() {
        return this.textureMap.values();
    }
}

