/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.util.DummyWorldAccess;
import hunternif.mc.atlas.util.Log;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NetherPortalWatcher
extends DummyWorldAccess {
    private static final String[] inPortalFieldNames = new String[]{"inPortal", "field_71087_bX", "bX"};
    public static final String MARKER_PORTAL = "nether_portal";
    private final Set<Integer> teleportingPlayerIDs = Collections.newSetFromMap(new ConcurrentHashMap());

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            event.world.func_72954_a((IWorldAccess)this);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            event.world.func_72848_b((IWorldAccess)this);
        }
    }

    @Override
    public void func_72703_a(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (this.teleportingPlayerIDs.remove(entity.func_145782_y())) {
                Log.info("Entering", new Object[0]);
                int dimension = player.field_71093_bK;
                Log.info("Player %s teleported to the %s", player.func_146103_bH().getName(), dimension == 0 ? "Overworld" : "Nether");
                this.addPortalMarkerIfNone(player, dimension);
            }
        }
    }

    @Override
    public void func_72709_b(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (NetherPortalWatcher.isEntityInPortal(entity)) {
                Log.info("Exiting", new Object[0]);
                int dimension = player.field_70170_p.field_73011_w.func_177502_q();
                Log.info("Player %s left the %s", player.func_146103_bH().getName(), dimension == 0 ? "Overworld" : "Nether");
                this.teleportingPlayerIDs.add(entity.func_145782_y());
                this.addPortalMarkerIfNone(player, dimension);
            }
        }
    }

    public void addPortalMarkerIfNone(EntityPlayer player, int dimension) {
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimension);
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            int z;
            int x;
            if (stack == null || stack.func_77973_b() != AntiqueAtlasMod.itemAtlas) continue;
            DimensionMarkersData data = AntiqueAtlasMod.markersData.getMarkersData(stack, (World)world).getMarkersDataInDimension(dimension);
            List<Marker> markers = data.getMarkersAtChunk(((x = (int)player.field_70165_t) >> 4) / 8, ((z = (int)player.field_70161_v) >> 4) / 8);
            if (markers != null) {
                for (Marker marker : markers) {
                    if (!marker.getType().equals(MARKER_PORTAL)) continue;
                    return;
                }
            }
            AtlasAPI.markers.putMarker((World)world, false, stack.func_77952_i(), MARKER_PORTAL, "gui.antiqueatlas.marker.netherPortal", x, z);
        }
    }

    public static boolean isEntityInPortal(Entity entity) {
        return (Boolean)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)entity, (String[])inPortalFieldNames);
    }
}

