/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.server;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.MarkersPacket;
import hunternif.mc.atlas.util.Log;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class AddMarkerPacket
extends AbstractMessage.AbstractServerMessage<AddMarkerPacket> {
    private int atlasID;
    private int dimension;
    private String type;
    private String label;
    private int x;
    private int y;
    private boolean visibleAhead;

    public AddMarkerPacket() {
    }

    public AddMarkerPacket(int atlasID, int dimension, String type, String label, int x, int y, boolean visibleAhead) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        this.type = type;
        this.label = label;
        this.x = x;
        this.y = y;
        this.visibleAhead = visibleAhead;
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        this.atlasID = buffer.func_150792_a();
        this.dimension = buffer.func_150792_a();
        this.type = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.label = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.visibleAhead = buffer.readBoolean();
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.atlasID);
        buffer.func_150787_b(this.dimension);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.type);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.label);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeBoolean(this.visibleAhead);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (!player.field_71071_by.func_70431_c(new ItemStack((Item)AntiqueAtlasMod.itemAtlas, 1, this.atlasID))) {
            Log.warn("Player %s attempted to put marker into someone else's Atlas #%d", player.func_146103_bH().getName(), this.atlasID);
            return;
        }
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, player.field_70170_p);
        Marker marker = markersData.createAndSaveMarker(this.type, this.label, this.dimension, this.x, this.y, this.visibleAhead);
        MarkersPacket packetForClients = new MarkersPacket(this.atlasID, this.dimension, marker);
        PacketDispatcher.sendToAll(packetForClients);
    }
}

