/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.util;

import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.SubTile;
import hunternif.mc.atlas.client.SubTileQuartet;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.TileRenderIterator;
import hunternif.mc.atlas.client.gui.ExportUpdateListener;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkerTextureMap;
import hunternif.mc.atlas.util.Log;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ExportImageUtil {
    public static final int TILE_SIZE = 16;
    public static final int MARKER_SIZE = 32;
    public static final int BG_TILE_SIZE = 22;

    public static File selectPngFileToSave(String atlasName, ExportUpdateListener listener) {
        listener.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.opening", (Object[])new Object[0]));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            Log.error(e, "Setting system Look&Feel for JFileChooser", new Object[0]);
        }
        catch (InstantiationException e) {
            Log.error(e, "Setting system Look&Feel for JFileChooser", new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.error(e, "Setting system Look&Feel for JFileChooser", new Object[0]);
        }
        catch (UnsupportedLookAndFeelException e) {
            Log.error(e, "Setting system Look&Feel for JFileChooser", new Object[0]);
        }
        Frame frame = new Frame();
        frame.setUndecorated(true);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.toFront();
        frame.setVisible(false);
        frame.dispose();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(I18n.func_135052_a((String)"gui.antiqueatlas.exportImage", (Object[])new Object[0]));
        chooser.setSelectedFile(new File(atlasName + ".png"));
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "PNG Image";
            }

            @Override
            public boolean accept(File file) {
                return true;
            }
        });
        listener.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.selectFile", (Object[])new Object[0]));
        if (chooser.showSaveDialog(frame) == 0) {
            File file = chooser.getSelectedFile();
            if (file.getName().length() < 4 || !file.getName().substring(file.getName().length() - 4).equalsIgnoreCase(".png")) {
                file = new File(file.getAbsolutePath() + ".png");
            }
            return file;
        }
        return null;
    }

    public static void exportPngImage(DimensionData biomeData, DimensionMarkersData globalMarkers, DimensionMarkersData localMarkers, File file, ExportUpdateListener listener, boolean showMarkers) {
        int y;
        int x;
        float updateUnitsTotal = biomeData.getSeenChunks().size();
        if (showMarkers) {
            updateUnitsTotal += (float)globalMarkers.getAllMarkers().size();
            if (localMarkers != null) {
                updateUnitsTotal += (float)localMarkers.getAllMarkers().size();
            }
        }
        int updateUnits = 0;
        int minX = (biomeData.getScope().minX - 1) * 16;
        int minY = (biomeData.getScope().minY - 1) * 16;
        int outWidth = (biomeData.getScope().maxX + 2) * 16 - minX;
        int outHeight = (biomeData.getScope().maxY + 2) * 16 - minY;
        Log.info("Image size: %dx%d", outWidth, outHeight);
        BufferedImage outImage = new BufferedImage(outWidth, outHeight, 2);
        Graphics2D graphics = outImage.createGraphics();
        int scale = 2;
        int bgTilesX = Math.round((float)outWidth / 22.0f / (float)scale);
        int bgTilesY = Math.round((float)outHeight / 22.0f / (float)scale);
        updateUnitsTotal += (float)((bgTilesX + 1) * (bgTilesY + 1));
        listener.setStatusString("Loading textures...");
        BufferedImage bg = null;
        HashMap<ResourceLocation, BufferedImage> textureImageMap = new HashMap<ResourceLocation, BufferedImage>();
        try {
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(Textures.EXPORTED_BG).func_110527_b();
            bg = ImageIO.read(is);
            is.close();
            ArrayList<ResourceLocation> allTextures = new ArrayList<ResourceLocation>(64);
            allTextures.addAll(BiomeTextureMap.instance().getAllTextures());
            if (showMarkers) {
                allTextures.addAll(MarkerTextureMap.instance().getAllTextures());
            }
            updateUnitsTotal += (float)allTextures.size();
            for (ResourceLocation texture : allTextures) {
                try {
                    is = Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b();
                    BufferedImage tileImage = ImageIO.read(is);
                    is.close();
                    textureImageMap.put(texture, tileImage);
                }
                catch (FileNotFoundException e) {
                    Log.warn("Texture %s not found!", texture.toString());
                }
                ++updateUnits;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        listener.update((float)updateUnits / updateUnitsTotal);
        listener.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.rendering", (Object[])new Object[0]));
        graphics.drawImage(bg, 0, 0, 22 * scale, 22 * scale, 0, 0, 22, 22, null);
        ++updateUnits;
        for (x = 1; x < bgTilesX; ++x) {
            graphics.drawImage(bg, x * 22 * scale, 0, (x + 1) * 22 * scale, 22 * scale, 22, 0, 44, 22, null);
            ++updateUnits;
        }
        for (y = 1; y < bgTilesY; ++y) {
            graphics.drawImage(bg, 0, y * 22 * scale, 22 * scale, (y + 1) * 22 * scale, 0, 22, 22, 44, null);
            ++updateUnits;
        }
        listener.update((float)updateUnits / updateUnitsTotal);
        for (x = 1; x < bgTilesX; ++x) {
            for (int y2 = 1; y2 < bgTilesY; ++y2) {
                graphics.drawImage(bg, x * 22 * scale, y2 * 22 * scale, (x + 1) * 22 * scale, (y2 + 1) * 22 * scale, 22, 22, 44, 44, null);
                ++updateUnits;
            }
        }
        listener.update((float)updateUnits / updateUnitsTotal);
        graphics.drawImage(bg, outWidth - 22 * scale, 0, outWidth, 22 * scale, 44, 0, 66, 22, null);
        ++updateUnits;
        for (y = 1; y < bgTilesY; ++y) {
            graphics.drawImage(bg, outWidth - 22 * scale, y * 22 * scale, outWidth, (y + 1) * 22 * scale, 44, 22, 66, 44, null);
            ++updateUnits;
        }
        graphics.drawImage(bg, 0, outHeight - 22 * scale, 22 * scale, outHeight, 0, 44, 22, 66, null);
        ++updateUnits;
        for (x = 1; x < bgTilesX; ++x) {
            graphics.drawImage(bg, x * 22 * scale, outHeight - 22 * scale, (x + 1) * 22 * scale, outHeight, 22, 44, 44, 66, null);
            ++updateUnits;
        }
        graphics.drawImage(bg, outWidth - 22 * scale, outHeight - 22 * scale, outWidth, outHeight, 44, 44, 66, 66, null);
        listener.update((float)(++updateUnits) / updateUnitsTotal);
        TileRenderIterator iter = new TileRenderIterator(biomeData);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                ResourceLocation texture;
                BufferedImage tileImage;
                if (subtile == null || subtile.tile == null || (tileImage = (BufferedImage)textureImageMap.get(texture = BiomeTextureMap.instance().getTexture(subtile.tile))) == null) continue;
                graphics.drawImage(tileImage, 16 + subtile.x * 16 / 2, 16 + subtile.y * 16 / 2, 16 + (subtile.x + 1) * 16 / 2, 16 + (subtile.y + 1) * 16 / 2, subtile.getTextureU() * 16 / 2, subtile.getTextureV() * 16 / 2, (subtile.getTextureU() + 1) * 16 / 2, (subtile.getTextureV() + 1) * 16 / 2, null);
            }
            if (++updateUnits % 10 != 0) continue;
            listener.update((float)updateUnits / updateUnitsTotal);
        }
        if (showMarkers) {
            ArrayList<Marker> markers = new ArrayList<Marker>();
            for (int x2 = biomeData.getScope().minX / 8; x2 <= biomeData.getScope().maxX / 8; ++x2) {
                for (int z = biomeData.getScope().minY / 8; z <= biomeData.getScope().maxY / 8; ++z) {
                    List<Marker> localMarkersAt;
                    markers.clear();
                    List<Marker> globalMarkersAt = globalMarkers.getMarkersAtChunk(x2, z);
                    if (globalMarkersAt != null) {
                        markers.addAll(globalMarkers.getMarkersAtChunk(x2, z));
                    }
                    if (localMarkers != null && (localMarkersAt = localMarkers.getMarkersAtChunk(x2, z)) != null) {
                        markers.addAll(localMarkersAt);
                    }
                    for (Marker marker : markers) {
                        ResourceLocation texture;
                        BufferedImage markerImage;
                        ++updateUnits;
                        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ()) || (markerImage = (BufferedImage)textureImageMap.get(texture = MarkerTextureMap.instance().getTexture(marker.getType()))) == null) continue;
                        int markerX = marker.getX() - minX;
                        int markerY = marker.getZ() - minY;
                        graphics.drawImage(markerImage, markerX - 16, markerY - 16, markerX + 16, markerY + 16, 0, 0, 32, 32, null);
                        if (updateUnits % 10 != 0) continue;
                        listener.update((float)updateUnits / updateUnitsTotal);
                    }
                }
            }
        }
        try {
            listener.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.writing", (Object[])new Object[0]));
            ImageIO.write((RenderedImage)outImage, "PNG", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

