/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.loader;

import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class BetterFoliageTransformer
implements IClassTransformer {
    Logger log = LogManager.getLogger((String)"BetterFoliageCore");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (transformedName.equals("net.minecraft.client.renderer.RenderBlocks")) {
            this.log.info(String.format("Found class %s", transformedName));
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode mn : classNode.methods) {
                boolean found = false;
                boolean obf = false;
                if (mn.desc.equals("(Lnet/minecraft/block/Block;III)Z") && mn.name.equals("renderBlockByRenderType")) {
                    found = true;
                } else if (mn.desc.equals("(Lahu;III)Z") && mn.name.equals("b")) {
                    found = true;
                    obf = true;
                }
                if (!found) continue;
                this.log.info("Overriding RenderBlocks.renderBlockByRenderType()");
                int invokeNodeIdx = 0;
                for (int idx = 0; idx < mn.instructions.size(); ++idx) {
                    if (!(mn.instructions.get(idx) instanceof MethodInsnNode)) continue;
                    invokeNodeIdx = idx;
                    break;
                }
                mn.instructions.remove(mn.instructions.get(invokeNodeIdx));
                MethodInsnNode replacement = new MethodInsnNode(184, "mods/betterfoliage/BlockRenderTypeOverride", "getRenderType", obf ? "(Lahu;)I" : "(Lnet/minecraft/block/Block;)I");
                mn.instructions.insertBefore(mn.instructions.get(invokeNodeIdx), (AbstractInsnNode)replacement);
                break;
            }
            ClassWriter writer = new ClassWriter(0);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }
}

