/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.resource.discovery;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.BlockModelsReloadCallback;
import mods.betterfoliage.ModelLoadingCallback;
import mods.betterfoliage.resource.discovery.BlockTypeCache;
import mods.betterfoliage.resource.discovery.ModelBakingContext;
import mods.betterfoliage.resource.discovery.ModelBakingKey;
import mods.betterfoliage.resource.discovery.ModelDiscovery;
import mods.betterfoliage.util.HasLogger;
import mods.betterfoliage.util.Invalidator;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_773;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J<\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00192\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0013J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016R&\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lmods/betterfoliage/resource/discovery/BakeWrapperManager;", "Lmods/betterfoliage/util/HasLogger;", "Lmods/betterfoliage/util/Invalidator;", "Lmods/betterfoliage/ModelLoadingCallback;", "Lnet/fabricmc/fabric/api/event/client/ClientSpriteRegistryCallback;", "Lmods/betterfoliage/BlockModelsReloadCallback;", "()V", "callbacks", "", "Ljava/lang/ref/WeakReference;", "Lkotlin/Function0;", "", "getCallbacks", "()Ljava/util/List;", "discoverers", "Lmods/betterfoliage/resource/discovery/ModelDiscovery;", "getDiscoverers", "replacements", "", "Lnet/minecraft/util/Identifier;", "Lmods/betterfoliage/resource/discovery/ModelBakingKey;", "sprites", "", "beginLoadModels", "loader", "Lnet/minecraft/client/render/model/ModelLoader;", "manager", "Lnet/minecraft/resource/ResourceManager;", "onBake", "Lnet/minecraft/client/render/model/BakedModel;", "unbaked", "Lnet/minecraft/client/render/model/UnbakedModel;", "bakery", "spriteGetter", "Ljava/util/function/Function;", "Lnet/minecraft/client/util/SpriteIdentifier;", "Lnet/minecraft/client/texture/Sprite;", "transform", "Lnet/minecraft/client/render/model/ModelBakeSettings;", "location", "registerSprites", "atlas", "Lnet/minecraft/client/texture/SpriteAtlasTexture;", "registry", "Lnet/fabricmc/fabric/api/event/client/ClientSpriteRegistryCallback$Registry;", "reloadBlockModels", "blockModels", "Lnet/minecraft/client/render/block/BlockModels;", "betterfoliage"})
public final class BakeWrapperManager
extends HasLogger
implements Invalidator,
ModelLoadingCallback,
ClientSpriteRegistryCallback,
BlockModelsReloadCallback {
    @NotNull
    private static final List<ModelDiscovery> discoverers;
    @NotNull
    private static final List<WeakReference<Function0<Unit>>> callbacks;
    private static final Map<class_2960, ModelBakingKey> replacements;
    private static final Set<class_2960> sprites;
    @NotNull
    public static final BakeWrapperManager INSTANCE;

    @NotNull
    public final List<ModelDiscovery> getDiscoverers() {
        return discoverers;
    }

    @Override
    @NotNull
    public List<WeakReference<Function0<Unit>>> getCallbacks() {
        return callbacks;
    }

    @Override
    public void beginLoadModels(@NotNull class_1088 loader, @NotNull class_3300 manager) {
        long startTime = System.currentTimeMillis();
        replacements.clear();
        sprites.clear();
        this.invalidate();
        BetterFoliage.INSTANCE.setBlockTypes(new BlockTypeCache());
        this.getLogger().log(Level.INFO, "starting model discovery (" + discoverers.size() + " listeners)");
        Iterable $this$forEach$iv = discoverers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelDiscovery listener = (ModelDiscovery)element$iv;
            boolean bl = false;
            boolean bl2 = false;
            Map replacementsLocal = new LinkedHashMap();
            listener.onModelsLoaded(loader, sprites, replacements);
        }
        long elapsed = System.currentTimeMillis() - startTime;
        this.getLogger().log(Level.INFO, "finished model discovery in " + elapsed + " ms, " + replacements.size() + " top-level replacements");
    }

    public void registerSprites(@NotNull class_1059 atlas, @NotNull ClientSpriteRegistryCallback.Registry registry) {
        this.getLogger().log(Level.INFO, "Adding " + sprites.size() + " sprites to block atlas");
        Iterable $this$forEach$iv = sprites;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2960 it = (class_2960)element$iv;
            boolean bl = false;
            registry.register(it);
        }
        sprites.clear();
    }

    @Override
    public void reloadBlockModels(@NotNull class_773 blockModels) {
        replacements.clear();
    }

    @Nullable
    public final class_1087 onBake(@NotNull class_1100 unbaked, @NotNull class_1088 bakery, @NotNull Function<class_4730, class_1058> spriteGetter, @NotNull class_3665 transform, @NotNull class_2960 location) {
        ModelBakingContext ctx = new ModelBakingContext(bakery, spriteGetter, location, transform, (Logger)this.getDetailLogger());
        ModelBakingKey modelBakingKey = replacements.get(location);
        if (modelBakingKey != null) {
            ModelBakingKey modelBakingKey2 = modelBakingKey;
            boolean bl = false;
            boolean bl2 = false;
            ModelBakingKey replacement = modelBakingKey2;
            boolean bl3 = false;
            INSTANCE.getDetailLogger().log(Level.INFO, "Baking replacement for [" + unbaked.getClass().getSimpleName() + "] " + location + " -> " + replacement);
            try {
                return replacement.bake(ctx);
            }
            catch (Exception e) {
                INSTANCE.getDetailLogger().log(Level.WARN, "Error while baking " + replacement, (Throwable)e);
                INSTANCE.getLogger().log(Level.WARN, "Error while baking " + replacement, (Throwable)e);
            }
        }
        return unbaked.method_4753(bakery, spriteGetter, transform, location);
    }

    private BakeWrapperManager() {
    }

    static {
        BakeWrapperManager bakeWrapperManager;
        INSTANCE = bakeWrapperManager = new BakeWrapperManager();
        ModelLoadingCallback.EVENT.register((Object)bakeWrapperManager);
        ClientSpriteRegistryCallback.event((class_2960)class_1059.field_5275).register((Object)bakeWrapperManager);
        boolean bl = false;
        discoverers = new ArrayList();
        bl = false;
        callbacks = new ArrayList();
        bl = false;
        replacements = new LinkedHashMap();
        bl = false;
        sprites = new LinkedHashSet();
    }

    @Override
    public void invalidate() {
        Invalidator.DefaultImpls.invalidate(this);
    }

    @Override
    public void onInvalidate(@NotNull Function0<Unit> callback) {
        Invalidator.DefaultImpls.onInvalidate(this, callback);
    }
}

