/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur;

import com.mojang.blaze3d.shaders.AbstractUniform;
import com.tterrag.blur.config.BlurConfig;
import com.tterrag.blur.integration.ClothConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="blur")
public class Blur {
    public static final String MODID = "blur";
    public static List<String> defaultExclusions = new ArrayList<String>();
    private long start;
    public int colorFirst;
    public int colorSecond;
    public static Blur INSTANCE;
    private float prevProgress = -1.0f;

    public Blur() {
        INSTANCE = this;
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        if (ModList.get().isLoaded("cloth_config")) {
            ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory(ClothConfig::getConfigScreen));
        }
        defaultExclusions.add(ChatScreen.class.getName());
        defaultExclusions.add("com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiOverlay$UserInputGuiScreen");
        defaultExclusions.add("ai.arcblroth.projectInception.client.InceptionInterfaceScreen");
        defaultExclusions.add("net.optifine.gui.GuiChatOF");
        defaultExclusions.add("io.github.darkkronicle.advancedchatcore.chat.AdvancedChatScreen");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BlurConfig.configSpec);
        MinecraftForge.EVENT_BUS.addListener(this::onScreenChange);
        MinecraftForge.EVENT_BUS.addListener(this::onRenderTick);
    }

    public void onScreenChange(ScreenOpenEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null) {
            boolean excluded;
            boolean bl = excluded = event.getScreen() == null || ((List)BlurConfig.blurExclusions.get()).contains(event.getScreen().getClass().getName());
            if (minecraft.f_91063_.m_109149_() == null && !excluded) {
                minecraft.f_91063_.m_109128_(new ResourceLocation(MODID, "shaders/post/fade_in_blur.json"));
                this.updateUniform("Radius", ((Integer)BlurConfig.radius.get()).intValue());
                this.colorFirst = Integer.parseUnsignedInt(String.valueOf(BlurConfig.gradientStartColor), 16);
                this.colorSecond = Integer.parseUnsignedInt(String.valueOf(BlurConfig.gradientEndColor), 16);
                this.start = System.currentTimeMillis();
            } else if (minecraft.f_91063_.m_109149_() != null && excluded) {
                minecraft.f_91063_.m_109086_();
                this.start = -1L;
            }
        }
    }

    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            float progress;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91080_ != null && minecraft.f_91063_.m_109149_() != null && (progress = this.getProgress()) != this.prevProgress) {
                this.prevProgress = progress;
                this.updateUniform("Progress", progress);
            }
        }
    }

    public void updateUniform(String name, float value) {
        PostChain shaderEffect = Minecraft.m_91087_().f_91063_.m_109149_();
        if (shaderEffect == null) {
            return;
        }
        for (PostPass s : shaderEffect.f_110009_) {
            AbstractUniform su = s.m_110074_().m_108960_(name);
            if (su == null) continue;
            su.m_5985_(value);
        }
    }

    private float getProgress() {
        return Math.min((float)(System.currentTimeMillis() - this.start) / (float)((Integer)BlurConfig.fadeTimeMillis.get()).intValue(), 1.0f);
    }

    public int getBackgroundColor(boolean second) {
        int color = second ? this.colorSecond : this.colorFirst;
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int g = color & 0xFF;
        float prog = INSTANCE.getProgress();
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }
}

