/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cherishedworlds.event;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ErrorScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionList;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import top.theillusivec4.cherishedworlds.CherishedWorlds;
import top.theillusivec4.cherishedworlds.util.FavoriteWorldsList;
import top.theillusivec4.cherishedworlds.util.ReflectionAccessor;

public class GuiEventHandler {
    private static final ResourceLocation STAR_ICON = new ResourceLocation("cherishedworlds", "textures/gui/staricon.png");
    private static final ResourceLocation EMPTY_STAR_ICON = new ResourceLocation("cherishedworlds", "textures/gui/emptystaricon.png");

    private static void refreshList(WorldSelectionList listWorldSelection) {
        GuiEventHandler.refreshList(listWorldSelection, null);
    }

    private static void refreshList(WorldSelectionList listWorldSelection, Supplier<String> supplier) {
        List list;
        Minecraft mc = Minecraft.func_71410_x();
        SaveFormat saveformat = mc.func_71359_d();
        try {
            list = saveformat.func_75799_b();
        }
        catch (AnvilConverterException anvilconverterexception) {
            CherishedWorlds.LOGGER.error("Couldn't load level list", (Throwable)anvilconverterexception);
            mc.func_147108_a((Screen)new ErrorScreen((ITextComponent)new TranslationTextComponent("selectWorld.unable_to_load"), (ITextComponent)new StringTextComponent(anvilconverterexception.getMessage())));
            return;
        }
        List entries = listWorldSelection.func_231039_at__();
        entries.clear();
        ListIterator iter = list.listIterator();
        ArrayList favorites = Lists.newArrayList();
        while (iter.hasNext()) {
            WorldSummary summ = (WorldSummary)iter.next();
            if (!FavoriteWorldsList.isFavorite(summ.func_75786_a())) continue;
            favorites.add(summ);
            iter.remove();
        }
        Collections.sort(favorites);
        Collections.sort(list);
        String s = supplier == null ? "" : supplier.get().toLowerCase(Locale.ROOT);
        for (WorldSummary worldsummary : favorites) {
            if (!s.isEmpty() && !worldsummary.func_75788_b().toLowerCase(Locale.ROOT).contains(s) && !worldsummary.func_75786_a().toLowerCase(Locale.ROOT).contains(s)) continue;
            WorldSelectionList worldSelectionList = listWorldSelection;
            worldSelectionList.getClass();
            entries.add(new WorldSelectionList.Entry(worldSelectionList, listWorldSelection, worldsummary, mc.func_71359_d()));
        }
        for (WorldSummary worldsummary : list) {
            if (!s.isEmpty() && !worldsummary.func_75788_b().toLowerCase(Locale.ROOT).contains(s) && !worldsummary.func_75786_a().toLowerCase(Locale.ROOT).contains(s)) continue;
            WorldSelectionList worldSelectionList = listWorldSelection;
            worldSelectionList.getClass();
            entries.add(new WorldSelectionList.Entry(worldSelectionList, listWorldSelection, worldsummary, mc.func_71359_d()));
        }
        WorldSelectionList.Entry entry = (WorldSelectionList.Entry)listWorldSelection.func_230958_g_();
        if (entry != null) {
            Button deleteButton = ReflectionAccessor.getDeleteButton(listWorldSelection.func_186796_g());
            GuiEventHandler.disableDeletingFavorites(entry, deleteButton);
        }
    }

    private static void disableDeletingFavorites(WorldSelectionList.Entry entry, Button deleteButton) {
        WorldSummary summary = ReflectionAccessor.getWorldSummary(entry);
        boolean isFavorite = summary != null && FavoriteWorldsList.isFavorite(summary.func_75786_a());
        deleteButton.field_230693_o_ = !isFavorite;
    }

    @SubscribeEvent
    public void onGuiDrawScreen(GuiScreenEvent.DrawScreenEvent.Post evt) {
        WorldSelectionScreen worldSelect;
        WorldSelectionList selectionList;
        Screen gui = evt.getGui();
        if (gui instanceof WorldSelectionScreen && (selectionList = ReflectionAccessor.getSelectionList(worldSelect = (WorldSelectionScreen)gui)) != null) {
            for (int i = 0; i < selectionList.func_231039_at__().size(); ++i) {
                WorldSummary summary;
                WorldSelectionList.Entry entry = (WorldSelectionList.Entry)selectionList.func_231039_at__().get(i);
                if (entry == null || (summary = ReflectionAccessor.getWorldSummary(entry)) == null) continue;
                boolean isFavorite = FavoriteWorldsList.isFavorite(summary.func_75786_a());
                ResourceLocation icon = isFavorite ? STAR_ICON : EMPTY_STAR_ICON;
                int top = (int)((double)(selectionList.getTop() + 15 + 36 * i) - selectionList.func_230966_l_());
                int x = evt.getGui().field_230708_k_ / 2 - 148;
                if (top < selectionList.getBottom() - 8 && top > selectionList.getTop()) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
                    AbstractGui.func_238463_a_((MatrixStack)evt.getMatrixStack(), (int)x, (int)top, (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
                }
                int mouseX = evt.getMouseX();
                int mouseY = evt.getMouseY();
                if (mouseY < top || mouseY > top + 9 || mouseX < x || mouseX > x + 9) continue;
                TranslationTextComponent component = new TranslationTextComponent("selectWorld.cherishedworlds." + (isFavorite ? "unfavorite" : "favorite"));
                GuiUtils.drawHoveringText((MatrixStack)evt.getMatrixStack(), Collections.singletonList(component), (int)mouseX, (int)mouseY, (int)gui.field_230708_k_, (int)gui.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            }
        }
    }

    @SubscribeEvent
    public void onGuiMouseClick(GuiScreenEvent.MouseClickedEvent.Pre evt) {
        WorldSelectionScreen worldSelect;
        WorldSelectionList selectionList;
        Screen gui = evt.getGui();
        if (gui instanceof WorldSelectionScreen && (selectionList = ReflectionAccessor.getSelectionList(worldSelect = (WorldSelectionScreen)gui)) != null) {
            for (int i = 0; i < selectionList.func_231039_at__().size(); ++i) {
                WorldSummary summary;
                WorldSelectionList.Entry entry = (WorldSelectionList.Entry)selectionList.func_231039_at__().get(i);
                if (entry == null || (summary = ReflectionAccessor.getWorldSummary(entry)) == null) continue;
                boolean isFavorite = FavoriteWorldsList.isFavorite(summary.func_75786_a());
                int top = (int)((double)(selectionList.getTop() + 15 + 36 * i) - selectionList.func_230966_l_());
                int x = evt.getGui().field_230708_k_ / 2 - 148;
                double mouseX = evt.getMouseX();
                double mouseY = evt.getMouseY();
                if (!(mouseY >= (double)top) || !(mouseY <= (double)(top + 9)) || !(mouseX >= (double)x) || !(mouseX <= (double)(x + 9))) continue;
                String s = summary.func_75786_a();
                if (isFavorite) {
                    FavoriteWorldsList.removeFavorite(s);
                } else {
                    FavoriteWorldsList.addFavorite(s);
                }
                FavoriteWorldsList.saveFavoritesList();
                GuiEventHandler.refreshList(selectionList);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onGuiMouseClicked(GuiScreenEvent.MouseClickedEvent.Post evt) {
        WorldSelectionList.Entry entry;
        WorldSelectionScreen worldSelect;
        WorldSelectionList selectionList;
        Screen gui = evt.getGui();
        if (gui instanceof WorldSelectionScreen && (selectionList = ReflectionAccessor.getSelectionList(worldSelect = (WorldSelectionScreen)gui)) != null && (entry = (WorldSelectionList.Entry)selectionList.func_230958_g_()) != null) {
            Button deleteButton = ReflectionAccessor.getDeleteButton(worldSelect);
            GuiEventHandler.disableDeletingFavorites(entry, deleteButton);
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post evt) {
        Screen gui = evt.getGui();
        if (gui instanceof WorldSelectionScreen) {
            WorldSelectionScreen worldSelect = (WorldSelectionScreen)gui;
            WorldSelectionList selectionList = ReflectionAccessor.getSelectionList(worldSelect);
            TextFieldWidget textField = ReflectionAccessor.getTextField(worldSelect);
            if (selectionList != null) {
                FavoriteWorldsList.loadFavoritesList();
                textField.func_212954_a(s -> GuiEventHandler.refreshList(selectionList, () -> s));
                GuiEventHandler.refreshList(selectionList);
            }
        }
    }
}

