/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.fabric.xray.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3fc;
import pro.mikey.fabric.xray.ScanController;
import pro.mikey.fabric.xray.records.BlockPosWithColor;
import pro.mikey.fabric.xray.storage.SettingsStore;

public class RenderOutlines {
    private static class_291 vertexBuffer;
    public static AtomicBoolean requestedRefresh;
    private static int canvasLoaded;

    public static synchronized void render(WorldRenderContext context) {
        if (canvasLoaded == -1) {
            int n = canvasLoaded = FabricLoader.getInstance().isModLoaded("canvas") ? 1 : 0;
        }
        if (ScanController.renderQueue.isEmpty() || !SettingsStore.getInstance().get().isActive()) {
            return;
        }
        if (vertexBuffer == null || requestedRefresh.get()) {
            requestedRefresh.set(false);
            vertexBuffer = new class_291(class_291.class_8555.field_44793);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            ScanController.renderQueue.forEach(blockProps -> {
                if (blockProps == null) {
                    return;
                }
                RenderOutlines.renderBlock(buffer, blockProps, 1.0f);
            });
            vertexBuffer.method_1353();
            vertexBuffer.method_1352(buffer.method_1326());
            class_291.method_1354();
        }
        if (vertexBuffer != null) {
            class_4184 camera = context.camera();
            class_243 cameraPos = camera.method_19326();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_4587 poseStack = RenderSystem.getModelViewStack();
            poseStack.method_22903();
            if (canvasLoaded == 1) {
                float f = camera.method_19329() * ((float)Math.PI / 180);
                poseStack.method_22907(new Quaternionf(1.0 * (double)class_3532.method_15374((float)(f / 2.0f)), 0.0, 0.0, (double)class_3532.method_15362((float)(f / 2.0f))));
                f = (camera.method_19330() + 180.0f) * ((float)Math.PI / 180);
                poseStack.method_22907(new Quaternionf(0.0, 1.0 * (double)class_3532.method_15374((float)(f / 2.0f)), 0.0, (double)class_3532.method_15362((float)(f / 2.0f))));
            }
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.depthFunc((int)519);
            context.projectionMatrix().lookAt((Vector3fc)cameraPos.method_46409(), (Vector3fc)cameraPos.method_46409().add((Vector3fc)camera.method_19335()), (Vector3fc)camera.method_19336());
            vertexBuffer.method_1353();
            vertexBuffer.method_34427(poseStack.method_23760().method_23761(), new Matrix4f((Matrix4fc)context.projectionMatrix()), RenderSystem.getShader());
            class_291.method_1354();
            RenderSystem.depthFunc((int)515);
            poseStack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    private static void renderBlock(class_287 buffer, BlockPosWithColor blockProps, float opacity) {
        float size = 1.0f;
        double x = blockProps.pos().method_10263();
        double y = blockProps.pos().method_10264();
        double z = blockProps.pos().method_10260();
        float red = (float)blockProps.color().red() / 255.0f;
        float green = (float)blockProps.color().green() / 255.0f;
        float blue = (float)blockProps.color().blue() / 255.0f;
        buffer.method_22912(x, y + 1.0, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y + 1.0, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y, z).method_22915(red, green, blue, opacity).method_1344();
        buffer.method_22912(x, y + 1.0, z).method_22915(red, green, blue, opacity).method_1344();
    }

    static {
        requestedRefresh = new AtomicBoolean(false);
        canvasLoaded = -1;
    }
}

