/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.fabric.xray.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import net.minecraft.class_310;
import pro.mikey.fabric.xray.XRay;

public abstract class Store<T> {
    private static final String CONFIG_PATH = String.format("%s/config/%s", class_310.method_1551().field_1697, "advanced-xray-fabric");
    private final String name;
    private final String file;
    public boolean justCreated = false;

    Store(String name) {
        this.name = name;
        this.file = String.format("%s/%s.json", CONFIG_PATH, this.name);
        this.read();
    }

    public Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public T read() {
        block4: {
            Gson gson = this.getGson();
            try {
                try {
                    return (T)gson.fromJson((Reader)new FileReader(this.file), this.getType());
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    XRay.LOGGER.fatal("Fatal error with json loading on {}.json", (Object)this.name, (Object)e);
                }
            }
            catch (FileNotFoundException ignored) {
                this.justCreated = true;
                if (!new File(CONFIG_PATH).mkdirs()) break block4;
                this.write(true);
            }
        }
        return this.providedDefault();
    }

    public void write() {
        this.write(false);
    }

    private void write(Boolean firstWrite) {
        Gson gson = this.getGson();
        try (FileWriter writer = new FileWriter(this.file);){
            gson.toJson(firstWrite != false ? this.providedDefault() : this.get(), (Appendable)writer);
            writer.flush();
        }
        catch (JsonIOException | IOException e) {
            XRay.LOGGER.catching(e);
        }
    }

    public abstract T providedDefault();

    public abstract T get();

    abstract Type getType();
}

