/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.functions.RayTraceFunctions;
import com.natamus.collective.functions.WorldFunctions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockPosFunctions {
    public static List<BlockPos> getBlocksAround(BlockPos pos, boolean down) {
        ArrayList<BlockPos> around = new ArrayList<BlockPos>();
        around.add(pos.m_142127_());
        around.add(pos.m_142126_());
        around.add(pos.m_142128_());
        around.add(pos.m_142125_());
        around.add(pos.m_7494_());
        if (down) {
            around.add(pos.m_7495_());
        }
        return around;
    }

    public static List<BlockPos> getBlocksNextToEachOther(Level world, BlockPos startpos, List<Block> possibleblocks) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possibleblocks.contains(world.m_8055_(startpos).m_60734_())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        BlockPosFunctions.recursiveGetNextBlocks(world, startpos, possibleblocks, theblocksaround, checkedblocks);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocks(Level world, BlockPos pos, List<Block> possibleblocks, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks) {
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possibleblocks.contains(world.m_8055_(pba).m_60734_()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            BlockPosFunctions.recursiveGetNextBlocks(world, pba, possibleblocks, theblocksaround, checkedblocks);
        }
    }

    public static List<BlockPos> getBlocksNextToEachOtherMaterial(Level world, BlockPos startpos, List<Material> possiblematerials) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possiblematerials.contains(world.m_8055_(startpos).m_60767_())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, possiblematerials, theblocksaround, checkedblocks);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocksMaterial(Level world, BlockPos pos, List<Material> possiblematerials, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks) {
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possiblematerials.contains(world.m_8055_(pba).m_60767_()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            BlockPosFunctions.recursiveGetNextBlocksMaterial(world, pba, possiblematerials, theblocksaround, checkedblocks);
        }
    }

    public static BlockPos getSurfaceBlockPos(ServerLevel serverworld, int x, int z) {
        int height = serverworld.m_141928_();
        BlockPos returnpos = new BlockPos(x, height - 1, z);
        if (!WorldFunctions.isNether((Level)serverworld)) {
            BlockPos pos = new BlockPos(x, height, z);
            for (int y = height; y > 0; --y) {
                BlockState blockstate = serverworld.m_8055_(pos);
                Material material = blockstate.m_60767_();
                if (blockstate.m_60739_((BlockGetter)serverworld, pos) >= 15 || material.equals(Material.f_76276_) || material.equals(Material.f_76316_)) {
                    returnpos = pos.m_7494_().m_7949_();
                    break;
                }
                pos = pos.m_7495_();
            }
        } else {
            int maxheight = 128;
            BlockPos pos = new BlockPos(x, 0, z);
            for (int y = 0; y < maxheight; ++y) {
                BlockState upstate;
                BlockState blockstate = serverworld.m_8055_(pos);
                if (blockstate.m_60734_().equals(Blocks.f_50016_) && (upstate = serverworld.m_8055_(pos.m_7494_())).m_60734_().equals(Blocks.f_50016_)) {
                    returnpos = pos.m_7949_();
                    break;
                }
                pos = pos.m_7494_();
            }
        }
        return returnpos;
    }

    public static BlockPos getCenterNearbyVillage(ServerLevel serverworld) {
        return BlockPosFunctions.getNearbyVillage(serverworld, new BlockPos(0, 0, 0));
    }

    public static BlockPos getNearbyVillage(ServerLevel serverworld, BlockPos nearpos) {
        return BlockPosFunctions.getNearbyStructure(serverworld, StructureFeature.f_67028_, nearpos, 9999);
    }

    public static BlockPos getCenterNearbyStructure(ServerLevel serverworld, StructureFeature<?> structure) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, new BlockPos(0, 0, 0));
    }

    public static BlockPos getNearbyStructure(ServerLevel serverworld, StructureFeature<?> structure, BlockPos nearpos) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, nearpos, 9999);
    }

    public static BlockPos getNearbyStructure(ServerLevel serverworld, StructureFeature<?> structure, BlockPos nearpos, int radius) {
        BlockPos villagepos = serverworld.m_8717_(structure, nearpos, radius, false);
        if (villagepos == null) {
            return null;
        }
        BlockPos spawnpos = null;
        for (int y = serverworld.m_141928_() - 1; y > 0; --y) {
            BlockPos checkpos = new BlockPos(villagepos.m_123341_(), y, villagepos.m_123343_());
            if (serverworld.m_8055_(checkpos).m_60734_().equals(Blocks.f_50016_)) continue;
            spawnpos = checkpos.m_7494_().m_7949_();
            break;
        }
        return spawnpos;
    }

    public static BlockPos getCenterBiome(ServerLevel serverworld, Biome biome) {
        BlockPos centerpos = new BlockPos(0, 0, 0);
        BlockPos biomepos = serverworld.m_8705_(biome, centerpos, 999999, 0);
        if (biomepos == null) {
            return null;
        }
        BlockPos spawnpos = null;
        for (int y = serverworld.m_141928_() - 1; y > 0; --y) {
            BlockPos checkpos = new BlockPos(biomepos.m_123341_(), y, biomepos.m_123343_());
            if (serverworld.m_8055_(checkpos).m_60734_().equals(Blocks.f_50016_)) continue;
            spawnpos = checkpos.m_7494_().m_7949_();
            break;
        }
        return spawnpos;
    }

    public static BlockPos getBlockPlayerIsLookingAt(Level world, Player player, boolean stopOnLiquid) {
        HitResult raytraceresult = RayTraceFunctions.rayTrace(world, player, stopOnLiquid);
        double posX = raytraceresult.m_82450_().f_82479_;
        double posY = Math.floor(raytraceresult.m_82450_().f_82480_);
        double posZ = raytraceresult.m_82450_().f_82481_;
        return new BlockPos(posX, posY, posZ);
    }

    public static Boolean isOnSurface(Level world, BlockPos pos) {
        return world.m_45527_(pos);
    }

    public static Boolean isOnSurface(Level world, Vec3 vecpos) {
        return BlockPosFunctions.isOnSurface(world, new BlockPos(vecpos.f_82479_, vecpos.f_82480_, vecpos.f_82481_));
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, int distance) {
        return BlockPosFunctions.withinDistance(start, end, (double)distance);
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, double distance) {
        return start.m_123314_((Vec3i)end, distance);
    }
}

