/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.quetzi.morpheus.Morpheus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.comforts.client.EventHandlerClient;
import top.theillusivec4.comforts.client.renderer.TileEntityHammockRenderer;
import top.theillusivec4.comforts.client.renderer.TileEntitySleepingBagRenderer;
import top.theillusivec4.comforts.common.ComfortsConfig;
import top.theillusivec4.comforts.common.EventHandlerCommon;
import top.theillusivec4.comforts.common.block.BlockHammock;
import top.theillusivec4.comforts.common.block.BlockRopeAndNail;
import top.theillusivec4.comforts.common.block.BlockSleepingBag;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;
import top.theillusivec4.comforts.common.init.ComfortsBlocks;
import top.theillusivec4.comforts.common.init.ComfortsTileEntities;
import top.theillusivec4.comforts.common.item.ItemComfortsBase;
import top.theillusivec4.comforts.common.item.ItemHammock;
import top.theillusivec4.comforts.common.item.ItemSleepingBag;
import top.theillusivec4.comforts.common.tileentity.TileEntityHammock;
import top.theillusivec4.comforts.common.tileentity.TileEntitySleepingBag;

@Mod(value="comforts")
public class Comforts {
    public static final String MODID = "comforts";
    public static final ItemGroup CREATIVE_TAB = new ItemGroup(-1, "comforts"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ComfortsBlocks.SLEEPING_BAGS.get(EnumDyeColor.RED));
        }
    };
    public static final Logger LOGGER = LogManager.getLogger();

    public Comforts() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ComfortsConfig.serverSpec);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCommon());
        CapabilitySleepData.register();
        if (ModList.get().isLoaded("morpheus")) {
            Morpheus.register.registerHandler(() -> {
                WorldServer world = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.OVERWORLD);
                boolean skipToNight = false;
                for (EntityPlayer entityplayer : world.field_73010_i) {
                    BlockPos bedLocation = entityplayer.field_71081_bT;
                    if (!entityplayer.func_71026_bH() || bedLocation == null || !(world.func_180495_p(bedLocation).func_177230_c() instanceof BlockHammock)) continue;
                    long worldTime = world.func_72820_D() % 24000L;
                    if (worldTime <= 500L || worldTime >= 11500L) break;
                    skipToNight = true;
                    break;
                }
                long worldTime = world.func_72820_D();
                long i = worldTime + 24000L;
                if (skipToNight) {
                    world.func_72877_b(i - i % 24000L - 12001L);
                } else {
                    world.func_72877_b(i - i % 24000L);
                }
            }, 0);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> evt) {
            IForgeRegistry registry = evt.getRegistry();
            Arrays.stream(EnumDyeColor.values()).forEach(color -> {
                BlockSleepingBag sleepingBag = new BlockSleepingBag((EnumDyeColor)color);
                ComfortsBlocks.SLEEPING_BAGS.put((EnumDyeColor)color, (Block)sleepingBag);
                BlockHammock hammock = new BlockHammock((EnumDyeColor)color);
                ComfortsBlocks.HAMMOCKS.put((EnumDyeColor)color, (Block)hammock);
                registry.registerAll((IForgeRegistryEntry[])new Block[]{sleepingBag, hammock});
            });
            registry.register((IForgeRegistryEntry)new BlockRopeAndNail());
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> evt) {
            IForgeRegistry registry = evt.getRegistry();
            ComfortsBlocks.SLEEPING_BAGS.values().forEach(block -> registry.register((IForgeRegistryEntry)new ItemSleepingBag((Block)block)));
            ComfortsBlocks.HAMMOCKS.values().forEach(block -> registry.register((IForgeRegistryEntry)new ItemHammock((Block)block)));
            registry.register((IForgeRegistryEntry)new ItemComfortsBase(ComfortsBlocks.ROPE_AND_NAIL));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> evt) {
            evt.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{ComfortsTileEntities.SLEEPING_BAG_TE, ComfortsTileEntities.HAMMOCK_TE});
        }
    }

    @Mod.EventBusSubscriber(modid="comforts", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent evt) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySleepingBag.class, (TileEntityRenderer)new TileEntitySleepingBagRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHammock.class, (TileEntityRenderer)new TileEntityHammockRenderer());
        }
    }
}

