/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.client.renderer;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.comforts.client.model.ModelComfortsBase;
import top.theillusivec4.comforts.common.tileentity.TileEntityComfortsBase;

public abstract class TileEntityComfortsRendererBase<T extends TileEntityComfortsBase>
extends TileEntityRenderer<T> {
    private final ResourceLocation[] textures = (ResourceLocation[])Arrays.stream(EnumDyeColor.values()).sorted(Comparator.comparingInt(EnumDyeColor::func_196059_a)).map(color -> new ResourceLocation("comforts", "textures/entity/" + textureName + "/" + color.func_176762_d() + ".png")).toArray(ResourceLocation[]::new);
    private final ModelComfortsBase model;
    private final float height;

    public TileEntityComfortsRendererBase(String textureName, ModelComfortsBase model, float height) {
        this.model = model;
        this.height = height;
    }

    public void render(T tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            ResourceLocation resourcelocation = this.textures[((TileEntityComfortsBase)((Object)tileEntityIn)).getColor().func_196059_a()];
            if (resourcelocation != null) {
                this.func_147499_a(resourcelocation);
            }
        }
        if (tileEntityIn.func_145830_o()) {
            IBlockState iblockstate = tileEntityIn.func_195044_w();
            this.func_199343_a(iblockstate.func_177229_b((IProperty)BlockBed.field_176472_a) == BedPart.HEAD, x, y, z, (EnumFacing)iblockstate.func_177229_b((IProperty)BlockBed.field_185512_D));
        } else {
            this.func_199343_a(true, x, y, z, EnumFacing.SOUTH);
            this.func_199343_a(false, x, y, z - 1.0, EnumFacing.SOUTH);
        }
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    private void func_199343_a(boolean p_199343_1_, double p_199343_2_, double p_199343_4_, double p_199343_6_, EnumFacing p_199343_8_) {
        this.model.preparePiece(p_199343_1_);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)p_199343_2_), (float)((float)p_199343_4_ + this.height), (float)((float)p_199343_6_));
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)(180.0f + p_199343_8_.func_185119_l()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.func_179091_B();
        this.model.render();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

