/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ComfortsConfig {
    private static final String CONFIG_PREFIX = "gui.comforts.config.";
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue autoUse;
        public final ForgeConfigSpec.BooleanValue wellRested;
        public final ForgeConfigSpec.DoubleValue sleepyFactor;
        public final ForgeConfigSpec.BooleanValue nightHammocks;
        public final ForgeConfigSpec.DoubleValue sleepingBagBreakage;
        public final ForgeConfigSpec.ConfigValue<List<String>> sleepingBagDebuffs;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            this.autoUse = builder.comment("Set to true to automatically use sleeping bags when placed").translation("gui.comforts.config.autoUse").define("autoUse", true);
            this.wellRested = builder.comment("Set to true to prevent sleeping depending on how long you previously slept").translation("gui.comforts.config.wellRested").define("wellRested", false);
            this.sleepyFactor = builder.comment("If well rested is true, this value is used to determine how long you need before being able to sleep again (larger numbers = can sleep sooner)").translation("gui.comforts.config.sleepyFactor").defineInRange("sleepyFactor", 2.0, 1.0, 20.0);
            this.nightHammocks = builder.comment("Set to true to enable sleeping in hammocks at night").translation("gui.comforts.config.nightHammocks").define("nightHammocks", false);
            this.sleepingBagBreakage = builder.comment("The chance that a sleeping bag will break upon usage").translation("gui.comforts.config.sleepingBagBreakage").defineInRange("sleepingBagBreakage", 0.0, 0.0, 1.0);
            this.sleepingBagDebuffs = builder.comment("List of debuffs to apply to players after using the sleeping bag\nFormat: [effect] [duration(secs)] [power]").translation("gui.comforts.config.sleepingBagDebuffs").worldRestart().define("sleepingBagDebuffs", new ArrayList());
        }
    }
}

