/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.comforts.Comforts;
import top.theillusivec4.comforts.common.ComfortsConfig;
import top.theillusivec4.comforts.common.block.BlockHammock;
import top.theillusivec4.comforts.common.block.BlockSleepingBag;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;

public class EventHandlerCommon {
    private static final Method WAKE_ALL_PLAYERS = ObfuscationReflectionHelper.findMethod(WorldServer.class, (String)"func_73053_d", (Class[])new Class[0]);
    public static List<PotionEffect> debuffs = new ArrayList<PotionEffect>();

    @SubscribeEvent
    public void onPlayerSetSpawn(PlayerSetSpawnEvent evt) {
        EntityPlayer player = evt.getEntityPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = evt.getNewSpawn();
        if (pos != null) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!world.field_72995_K && (block instanceof BlockSleepingBag || block instanceof BlockHammock)) {
                player.field_71081_bT = (BlockPos)ObfuscationReflectionHelper.getPrivateValue(EntityPlayer.class, (Object)player, (String)"field_71077_c");
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onSleepTimeCheck(SleepingTimeCheckEvent evt) {
        World world = evt.getEntityPlayer().func_130014_f_();
        long worldTime = world.func_72820_D() % 24000L;
        if (world.func_180495_p(evt.getSleepingLocation()).func_177230_c() instanceof BlockHammock) {
            if (worldTime > 500L && worldTime < 11500L) {
                evt.setResult(Event.Result.ALLOW);
            } else if (((Boolean)ComfortsConfig.SERVER.nightHammocks.get()).booleanValue()) {
                evt.setResult(Event.Result.DEFAULT);
            } else {
                evt.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onPreWorldTick(TickEvent.WorldTickEvent evt) {
        WorldServer world;
        if (evt.phase == TickEvent.Phase.START && evt.world instanceof WorldServer && (world = (WorldServer)evt.world).func_73056_e()) {
            boolean skipToNight = false;
            if (world.func_82736_K().func_82766_b("doDaylightCycle")) {
                for (EntityPlayer entityplayer : world.field_73010_i) {
                    BlockPos bedLocation = entityplayer.field_71081_bT;
                    if (!entityplayer.func_71026_bH() || bedLocation == null || !(world.func_180495_p(bedLocation).func_177230_c() instanceof BlockHammock)) continue;
                    long i = world.func_72820_D() + 24000L;
                    long worldTime = world.func_72820_D() % 24000L;
                    if (worldTime <= 500L || worldTime >= 11500L) break;
                    skipToNight = true;
                    world.func_72877_b(i - i % 24000L - 12001L);
                    break;
                }
            }
            if (skipToNight) {
                try {
                    WAKE_ALL_PLAYERS.invoke((Object)world, new Object[0]);
                }
                catch (Exception e) {
                    Comforts.LOGGER.error("Error trying to wake all players! " + e.getMessage());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPostPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.side == LogicalSide.SERVER) {
            EntityPlayer player = evt.player;
            CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> {
                if (!player.func_70608_bn() && sleepdata.isSleeping()) {
                    World world = player.field_70170_p;
                    BlockPos pos = sleepdata.getSleepingPos();
                    IBlockState state = world.func_180495_p(pos);
                    if (world.func_175667_e(pos) && state.func_177230_c() instanceof BlockSleepingBag) {
                        EntityPlayer.SleepResult sleepResult = player.func_180469_a(pos);
                        if (sleepResult != EntityPlayer.SleepResult.OK) {
                            sleepdata.setSleeping(false);
                            sleepdata.setSleepingPos(null);
                        }
                    } else {
                        sleepdata.setSleeping(false);
                        sleepdata.setSleepingPos(null);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
        EntityPlayer player = evt.getEntityPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> {
                long wakeTime;
                long timeSlept;
                BlockPos pos = sleepdata.getSleepingPos();
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof BlockSleepingBag) {
                    boolean broke = false;
                    List<PotionEffect> debuffs = EventHandlerCommon.getDebuffs();
                    if (!debuffs.isEmpty()) {
                        for (PotionEffect effect : debuffs) {
                            player.func_195064_c(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c()));
                        }
                    }
                    if (world.field_73012_v.nextDouble() < (Double)ComfortsConfig.SERVER.sleepingBagBreakage.get()) {
                        broke = true;
                        BlockPos blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176734_d());
                        world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("block.comforts.sleeping_bag.broke", new Object[0]), true);
                        world.func_184133_a(null, pos, SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    if (sleepdata.isSleeping()) {
                        sleepdata.setSleeping(false);
                        sleepdata.setSleepingPos(null);
                        if (!broke) {
                            ItemStack stack = new ItemStack(state.func_177230_c().func_199769_a(state, world, pos, 0));
                            BlockPos blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176734_d());
                            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
                            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
                            if (!player.field_71075_bZ.field_75098_d) {
                                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack, (int)player.field_71071_by.field_70461_c);
                            }
                        }
                    }
                }
                if ((timeSlept = (wakeTime = world.func_72820_D()) - sleepdata.getSleepTime()) > 500L) {
                    sleepdata.setWakeTime(wakeTime);
                    sleepdata.setTiredTime(wakeTime + (long)((double)timeSlept / (Double)ComfortsConfig.SERVER.sleepyFactor.get()));
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent evt) {
        EntityPlayer player = evt.getEntityPlayer();
        if (!player.field_70170_p.field_72995_K && ((Boolean)ComfortsConfig.SERVER.wellRested.get()).booleanValue()) {
            long dayTime = player.func_130014_f_().func_72820_D();
            CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> {
                if (sleepdata.getWakeTime() > dayTime) {
                    sleepdata.setWakeTime(0L);
                    sleepdata.setTiredTime(0L);
                }
                if (sleepdata.getTiredTime() > dayTime) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("capability.comforts.not_sleepy", new Object[0]), true);
                    evt.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                }
            });
        }
    }

    private static List<PotionEffect> getDebuffs() {
        List configDebuffs = (List)ComfortsConfig.SERVER.sleepingBagDebuffs.get();
        if (!configDebuffs.isEmpty()) {
            if (debuffs.isEmpty()) {
                for (String s : configDebuffs) {
                    String[] elements = s.split("\\s+");
                    Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(elements[0]));
                    if (potion == null) continue;
                    int duration = 0;
                    int amp = 0;
                    try {
                        duration = Math.max(1, Math.min(Integer.parseInt(elements[1]), 1600));
                        amp = Math.max(1, Math.min(Integer.parseInt(elements[2]), 4));
                    }
                    catch (Exception e) {
                        Comforts.LOGGER.error("Problem parsing sleeping bag debuffs in config!", (Throwable)e);
                    }
                    debuffs.add(new PotionEffect(potion, duration * 20, amp - 1));
                }
            }
            return debuffs;
        }
        return new ArrayList<PotionEffect>();
    }
}

