/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeDimension;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;

public class BlockComfortsBase
extends BlockBed {
    private final BedType type;

    public BlockComfortsBase(BedType type, EnumDyeColor colorIn, Block.Properties properties) {
        super(colorIn, properties);
        this.type = type;
    }

    public boolean func_196250_a(@Nonnull IBlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (state.func_177229_b((IProperty)field_176472_a) != BedPart.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)))).func_177230_c() != this) {
            return true;
        }
        IForgeDimension.SleepResult sleepResult = worldIn.field_73011_w.canSleepAt(player, pos);
        if (sleepResult != IForgeDimension.SleepResult.BED_EXPLODES) {
            EntityPlayer.SleepResult entityplayer$sleepresult;
            if (sleepResult == IForgeDimension.SleepResult.DENY) {
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)field_176471_b)).booleanValue()) {
                EntityPlayer entityplayer = this.getPlayerInBed(worldIn, pos);
                if (entityplayer != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("block.comforts." + this.type.name + "occupied", new Object[0]), true);
                    return true;
                }
                state = (IBlockState)state.func_206870_a((IProperty)field_176471_b, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 4);
            }
            if ((entityplayer$sleepresult = player.func_180469_a(pos)) == EntityPlayer.SleepResult.OK) {
                state = (IBlockState)state.func_206870_a((IProperty)field_176471_b, (Comparable)Boolean.valueOf(true));
                worldIn.func_180501_a(pos, state, 4);
                CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> {
                    if (sleepdata.getSleepingPos() == null) {
                        sleepdata.setSleepingPos(player.field_71081_bT);
                    }
                });
                return true;
            }
            if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                TextComponentTranslation text = this.type == BedType.HAMMOCK ? new TextComponentTranslation("block.comforts." + this.type.name + ".no_sleep", new Object[0]) : new TextComponentTranslation("block.minecraft.bed.no_sleep", new Object[0]);
                player.func_146105_b((ITextComponent)text, true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_SAFE) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("block.minecraft.bed.not_safe", new Object[0]), true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.TOO_FAR_AWAY) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("block.comforts." + this.type.name + "too_far_away", new Object[0]), true);
            }
            return true;
        }
        worldIn.func_175698_g(pos);
        BlockPos blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d());
        if (worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        worldIn.func_211529_a(null, DamageSource.func_199683_a(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, true);
        return true;
    }

    @Nullable
    private EntityPlayer getPlayerInBed(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!entityplayer.func_70608_bn() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    static enum BedType {
        HAMMOCK("hammock"),
        SLEEPING_BAG("sleeping_bag");

        private final String name;

        private BedType(String name) {
            this.name = name;
        }
    }
}

