/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import top.theillusivec4.comforts.common.block.BlockComfortsBase;
import top.theillusivec4.comforts.common.block.BlockRopeAndNail;
import top.theillusivec4.comforts.common.tileentity.TileEntityHammock;

public class BlockHammock
extends BlockComfortsBase {
    private static final VoxelShape HAMMOCK_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private final EnumDyeColor color;

    public BlockHammock(EnumDyeColor color) {
        super(BlockComfortsBase.BedType.HAMMOCK, color, Block.Properties.func_200945_a((Material)Material.field_151580_n).func_200947_a(SoundType.field_185854_g).func_200943_b(0.1f));
        this.color = color;
        this.setRegistryName("comforts", "hammock_" + color.func_176762_d());
    }

    @Nonnull
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return HAMMOCK_SHAPE;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, @Nonnull EntityPlayer player) {
        BedPart bedpart = (BedPart)state.func_177229_b((IProperty)field_176472_a);
        boolean flag = bedpart == BedPart.HEAD;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        BlockPos blockpos = pos.func_177972_a(BlockHammock.getDirectionToOther(bedpart, facing));
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() == this && iblockstate.func_177229_b((IProperty)field_176472_a) != bedpart) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_180498_a(player, 2001, blockpos, Block.func_196246_j((IBlockState)iblockstate));
            BlockPos posrope1 = flag ? pos.func_177972_a(facing) : pos.func_177972_a(facing.func_176734_d());
            BlockPos posrope2 = flag ? pos.func_177967_a(facing.func_176734_d(), 2) : pos.func_177967_a(facing, 2);
            IBlockState rope1 = worldIn.func_180495_p(posrope1);
            IBlockState rope2 = worldIn.func_180495_p(posrope2);
            if (rope1.func_177230_c() instanceof BlockRopeAndNail) {
                worldIn.func_175656_a(posrope1, (IBlockState)rope1.func_206870_a((IProperty)BlockRopeAndNail.SUPPORTING, (Comparable)Boolean.valueOf(false)));
            }
            if (rope2.func_177230_c() instanceof BlockRopeAndNail) {
                worldIn.func_175656_a(posrope2, (IBlockState)rope2.func_206870_a((IProperty)BlockRopeAndNail.SUPPORTING, (Comparable)Boolean.valueOf(false)));
            }
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                if (flag) {
                    state.func_196949_c(worldIn, pos, 0);
                } else {
                    iblockstate.func_196949_c(worldIn, blockpos, 0);
                }
            }
            player.func_71029_a(StatList.field_188065_ae.func_199076_b((Object)this));
        }
        worldIn.func_180498_a(player, 2001, pos, Block.func_196246_j((IBlockState)state));
    }

    public static EnumFacing getDirectionToOther(BedPart part, EnumFacing facing) {
        return part == BedPart.FOOT ? facing : facing.func_176734_d();
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        EnumFacing enumfacing = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(enumfacing);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (IBlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)enumfacing) : null;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityHammock(this.color);
    }
}

