/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilitySleepData {
    @CapabilityInject(value=ISleepData.class)
    public static final Capability<ISleepData> SLEEP_DATA_CAP = null;
    public static final ResourceLocation ID = new ResourceLocation("comforts", "sleep_data");
    private static final String WAKE_TAG = "wakeTime";
    private static final String TIRED_TAG = "tiredTime";
    private static final String SLEEP_TAG = "sleepTime";
    private static final String SLEEPING_TAG = "sleeping";
    private static final String LOC_TAG = "sleepingLocation";

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEvents());
        CapabilityManager.INSTANCE.register(ISleepData.class, (Capability.IStorage)new Capability.IStorage<ISleepData>(){

            public INBTBase writeNBT(Capability<ISleepData> capability, ISleepData instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74772_a(CapabilitySleepData.WAKE_TAG, instance.getWakeTime());
                compound.func_74772_a(CapabilitySleepData.TIRED_TAG, instance.getTiredTime());
                compound.func_74772_a(CapabilitySleepData.SLEEP_TAG, instance.getSleepTime());
                compound.func_74757_a(CapabilitySleepData.SLEEPING_TAG, instance.isSleeping());
                BlockPos pos = instance.getSleepingPos();
                if (pos != null) {
                    compound.func_74782_a(CapabilitySleepData.LOC_TAG, (INBTBase)NBTUtil.func_186859_a((BlockPos)pos));
                }
                return compound;
            }

            public void readNBT(Capability<ISleepData> capability, ISleepData instance, EnumFacing side, INBTBase nbt) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                instance.setWakeTime(compound.func_74763_f(CapabilitySleepData.WAKE_TAG));
                instance.setTiredTime(compound.func_74763_f(CapabilitySleepData.TIRED_TAG));
                instance.setSleepTime(compound.func_74763_f(CapabilitySleepData.SLEEP_TAG));
                instance.setSleeping(compound.func_74767_n(CapabilitySleepData.SLEEPING_TAG));
                if (compound.func_186855_b(CapabilitySleepData.LOC_TAG)) {
                    instance.setSleepingPos(NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(CapabilitySleepData.LOC_TAG)));
                }
            }
        }, SleepDataWrapper::new);
    }

    public static LazyOptional<ISleepData> getCapability(EntityPlayer player) {
        return player.getCapability(SLEEP_DATA_CAP);
    }

    public static class CapabilityEvents {
        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            Entity entity = (Entity)evt.getObject();
            if (entity instanceof EntityPlayer) {
                evt.addCapability(ID, (ICapabilityProvider)new Provider());
            }
        }

        @SubscribeEvent
        public void onPlayerDeath(PlayerEvent.Clone evt) {
            if (evt.isWasDeath()) {
                EntityPlayer player = evt.getEntityPlayer();
                EntityPlayer original = evt.getOriginal();
                CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> CapabilitySleepData.getCapability(original).ifPresent(originaldata -> {
                    sleepdata.setSleepingPos(originaldata.getSleepingPos());
                    sleepdata.setSleeping(originaldata.isSleeping());
                    sleepdata.setSleepTime(originaldata.getSleepTime());
                    sleepdata.setTiredTime(originaldata.getTiredTime());
                    sleepdata.setWakeTime(originaldata.getWakeTime());
                }));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<INBTBase> {
        final LazyOptional<ISleepData> optional;
        final ISleepData data = new SleepDataWrapper();

        Provider() {
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, EnumFacing facing) {
            return SLEEP_DATA_CAP.orEmpty(capability, this.optional);
        }

        public INBTBase serializeNBT() {
            return SLEEP_DATA_CAP.writeNBT((Object)this.data, null);
        }

        public void deserializeNBT(INBTBase nbt) {
            SLEEP_DATA_CAP.readNBT((Object)this.data, null, nbt);
        }
    }

    public static class SleepDataWrapper
    implements ISleepData {
        long sleepTime = 0L;
        long wakeTime = 0L;
        long tiredTime = 0L;
        boolean isSleeping = false;
        BlockPos sleepLocation = null;
        BlockPos bedLocation = null;

        @Override
        public long getSleepTime() {
            return this.sleepTime;
        }

        @Override
        public void setSleepTime(long time) {
            this.sleepTime = time;
        }

        @Override
        public long getWakeTime() {
            return this.wakeTime;
        }

        @Override
        public void setWakeTime(long time) {
            this.wakeTime = time;
        }

        @Override
        public long getTiredTime() {
            return this.tiredTime;
        }

        @Override
        public void setTiredTime(long time) {
            this.tiredTime = time;
        }

        @Override
        public boolean isSleeping() {
            return this.isSleeping;
        }

        @Override
        public void setSleeping(boolean value) {
            this.isSleeping = value;
        }

        @Override
        public BlockPos getSleepingPos() {
            return this.sleepLocation;
        }

        @Override
        public void setSleepingPos(BlockPos pos) {
            this.sleepLocation = pos;
        }
    }

    public static interface ISleepData {
        public long getSleepTime();

        public void setSleepTime(long var1);

        public long getWakeTime();

        public void setWakeTime(long var1);

        public long getTiredTime();

        public void setTiredTime(long var1);

        public boolean isSleeping();

        public void setSleeping(boolean var1);

        public BlockPos getSleepingPos();

        public void setSleepingPos(BlockPos var1);
    }
}

