/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.comforts.common.ComfortsConfig;
import top.theillusivec4.comforts.common.block.HammockBlock;
import top.theillusivec4.comforts.common.block.SleepingBagBlock;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;

public class CommonEventHandler {
    public static List<EffectInstance> debuffs = new ArrayList<EffectInstance>();

    @SubscribeEvent
    public void onPlayerSetSpawn(PlayerSetSpawnEvent evt) {
        Block block;
        PlayerEntity player = evt.getPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = evt.getNewSpawn();
        if (pos != null && !world.field_72995_K && ((block = world.func_180495_p(pos).func_177230_c()) instanceof SleepingBagBlock || block instanceof HammockBlock)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSleepTimeCheck(SleepingTimeCheckEvent evt) {
        World world = evt.getPlayer().func_130014_f_();
        long worldTime = world.func_72820_D() % 24000L;
        evt.getSleepingLocation().ifPresent(sleepingLocation -> {
            if (world.func_180495_p(sleepingLocation).func_177230_c() instanceof HammockBlock) {
                if (worldTime > 500L && worldTime < 11500L) {
                    evt.setResult(Event.Result.ALLOW);
                } else if (((Boolean)ComfortsConfig.SERVER.nightHammocks.get()).booleanValue()) {
                    evt.setResult(Event.Result.DEFAULT);
                } else {
                    evt.setResult(Event.Result.DENY);
                }
            }
        });
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent evt) {
        IWorld world = evt.getWorld();
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            boolean[] activeHammock = new boolean[]{false};
            List players = world.func_217369_A();
            for (PlayerEntity player : players) {
                player.func_213374_dv().ifPresent(bedPos -> {
                    if (player.func_71026_bH() && world.func_180495_p(bedPos).func_177230_c() instanceof HammockBlock) {
                        activeHammock[0] = true;
                    }
                });
                if (!activeHammock[0]) continue;
                break;
            }
            if (activeHammock[0] && world.func_201672_e().func_72935_r()) {
                long i = serverWorld.func_72820_D() + 24000L;
                evt.setTimeAddition(i - i % 24000L - 12001L);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
        PlayerEntity player = evt.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> player.func_213374_dv().ifPresent(bedPos -> {
                long wakeTime = world.func_72820_D();
                long timeSlept = wakeTime - sleepdata.getSleepTime();
                BlockState state = world.func_180495_p(bedPos);
                if (state.func_177230_c() instanceof SleepingBagBlock) {
                    boolean broke = false;
                    if (timeSlept > 500L) {
                        List<EffectInstance> debuffs = ComfortsConfig.sleepingBagDebuffs;
                        if (!debuffs.isEmpty()) {
                            for (EffectInstance effect : debuffs) {
                                player.func_195064_c(new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c()));
                            }
                        }
                        if (world.field_73012_v.nextDouble() < (Double)ComfortsConfig.SERVER.sleepingBagBreakage.get()) {
                            broke = true;
                            BlockPos blockpos = bedPos.func_177972_a(((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176734_d());
                            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
                            world.func_180501_a(bedPos, Blocks.field_150350_a.func_176223_P(), 35);
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("block.comforts.sleeping_bag.broke"), true);
                            world.func_184133_a(null, bedPos, SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            player.func_213372_dw();
                        }
                    }
                    if (!broke && sleepdata.getAutoSleepPos() != null) {
                        BlockPos blockpos = bedPos.func_177972_a(((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176734_d());
                        world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
                        world.func_180501_a(bedPos, Blocks.field_150350_a.func_176223_P(), 35);
                        player.func_213372_dw();
                    }
                }
                sleepdata.setWakeTime(wakeTime);
                sleepdata.setTiredTime(wakeTime + (long)((double)timeSlept / (Double)ComfortsConfig.SERVER.sleepyFactor.get()));
                sleepdata.setAutoSleepPos(null);
            }));
        }
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent evt) {
        PlayerEntity player = evt.getPlayer();
        CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> {
            if (!player.field_70170_p.field_72995_K) {
                long dayTime = player.func_130014_f_().func_72820_D();
                sleepdata.setSleepTime(dayTime);
                if (((Boolean)ComfortsConfig.SERVER.wellRested.get()).booleanValue()) {
                    if (sleepdata.getWakeTime() > dayTime) {
                        sleepdata.setWakeTime(0L);
                        sleepdata.setTiredTime(0L);
                    }
                    if (sleepdata.getTiredTime() > dayTime) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("capability.comforts.not_sleepy"), true);
                        evt.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
                    }
                }
            }
        });
    }
}

