/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.handler;

import java.util.Random;
import net.dark_roleplay.core.api.storage.DynamicStorageTileEntity;
import net.dark_roleplay.core_modules.maarg.api.arg.MaterialRequirements;
import net.dark_roleplay.core_modules.maarg.handler.MaterialRegistry;
import net.dark_roleplay.library.experimental.blocks.BlockSettings;
import net.dark_roleplay.library.experimental.blocks.DRPBlock;
import net.dark_roleplay.library.experimental.blocks.behaviors.IBlockBehavior;
import net.dark_roleplay.library.experimental.blocks.behaviors.IBoundingBoxBehavior;
import net.dark_roleplay.library.experimental.variables.wrappers.IntegerWrapper;
import net.dark_roleplay.medieval.handler.ItemRegistryHandler;
import net.dark_roleplay.medieval.handler.ModelRegistryHandler;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.holders.MedievalCreativeTabs;
import net.dark_roleplay.medieval.holders.configs.Miscellaneous;
import net.dark_roleplay.medieval.objects.blocks.building.advanced_ore.AdvancedOre;
import net.dark_roleplay.medieval.objects.blocks.building.dirt_stairs.DirtStairs;
import net.dark_roleplay.medieval.objects.blocks.building.double_arch.DoubleArch;
import net.dark_roleplay.medieval.objects.blocks.building.double_arch.behaviors.StoneArchPlacement;
import net.dark_roleplay.medieval.objects.blocks.building.dry_clay.DryClay;
import net.dark_roleplay.medieval.objects.blocks.building.dry_clay.DryClayGrass;
import net.dark_roleplay.medieval.objects.blocks.building.hanging_bridge.HangingBridge;
import net.dark_roleplay.medieval.objects.blocks.building.mossy_log.MossyLog;
import net.dark_roleplay.medieval.objects.blocks.building.roofs.Roof;
import net.dark_roleplay.medieval.objects.blocks.building.simple_wood_stairs.SimpleWoodStairs;
import net.dark_roleplay.medieval.objects.blocks.building.timbered_clay.TimberedClay;
import net.dark_roleplay.medieval.objects.blocks.building.wood_supports.WoodSupport;
import net.dark_roleplay.medieval.objects.blocks.building.wooden_window.WoodenWindow;
import net.dark_roleplay.medieval.objects.blocks.decoration.advent_wreath.AdventWreath;
import net.dark_roleplay.medieval.objects.blocks.decoration.advent_wreath.behaviors.CandleLighting;
import net.dark_roleplay.medieval.objects.blocks.decoration.advent_wreath.behaviors.CandleParticles;
import net.dark_roleplay.medieval.objects.blocks.decoration.barrels.SidewayBarrel;
import net.dark_roleplay.medieval.objects.blocks.decoration.barrels.TileEntityFluidBarrel;
import net.dark_roleplay.medieval.objects.blocks.decoration.barrels.behaviors.Behavior_EmptyBarrel;
import net.dark_roleplay.medieval.objects.blocks.decoration.barrels.behaviors.Behavior_FluidFill;
import net.dark_roleplay.medieval.objects.blocks.decoration.candles.BeesWaxCandle;
import net.dark_roleplay.medieval.objects.blocks.decoration.chairs.ChairBlock;
import net.dark_roleplay.medieval.objects.blocks.decoration.clock_dial.ClockDial;
import net.dark_roleplay.medieval.objects.blocks.decoration.flower_container.TileEntityFlowerContainer;
import net.dark_roleplay.medieval.objects.blocks.decoration.flower_container.behaviors.FlowerContainer;
import net.dark_roleplay.medieval.objects.blocks.decoration.lantern.Lantern;
import net.dark_roleplay.medieval.objects.blocks.decoration.log_bench.LogBench;
import net.dark_roleplay.medieval.objects.blocks.decoration.rope.Rope;
import net.dark_roleplay.medieval.objects.blocks.decoration.rope.RopeAnchor;
import net.dark_roleplay.medieval.objects.blocks.decoration.rope_fence.RopeFence;
import net.dark_roleplay.medieval.objects.blocks.decoration.shop_signs.ShopSign;
import net.dark_roleplay.medieval.objects.blocks.decoration.shop_signs.TileEntityShopSign;
import net.dark_roleplay.medieval.objects.blocks.decoration.tables.simple_table.SimpleTable;
import net.dark_roleplay.medieval.objects.blocks.decoration.tables.simple_table.SolidSimpleTable;
import net.dark_roleplay.medieval.objects.blocks.decoration.target.Target;
import net.dark_roleplay.medieval.objects.blocks.decoration.wall_mounted.EmptyWallMount;
import net.dark_roleplay.medieval.objects.blocks.decoration.wall_mounted.LitWallMount;
import net.dark_roleplay.medieval.objects.blocks.decoration.wall_mounted.UnlitWallMount;
import net.dark_roleplay.medieval.objects.blocks.decoration.wall_mounted.WallMounted;
import net.dark_roleplay.medieval.objects.blocks.general.AxisBlock;
import net.dark_roleplay.medieval.objects.blocks.general.FacedBlock;
import net.dark_roleplay.medieval.objects.blocks.general.PillarBlock;
import net.dark_roleplay.medieval.objects.blocks.general.behaviors.AxisBoundingBox;
import net.dark_roleplay.medieval.objects.blocks.general.behaviors.Behavior_Bell;
import net.dark_roleplay.medieval.objects.blocks.general.behaviors.Behavior_CanPlaceChains;
import net.dark_roleplay.medieval.objects.blocks.general.behaviors.Behavior_Chair;
import net.dark_roleplay.medieval.objects.blocks.general.behaviors.Behavior_ClockCore;
import net.dark_roleplay.medieval.objects.blocks.general.behaviors.Behavior_Container;
import net.dark_roleplay.medieval.objects.blocks.general.behaviors.Behavior_CraftingStation;
import net.dark_roleplay.medieval.objects.blocks.general.behaviors.FacedBoundingBox;
import net.dark_roleplay.medieval.objects.blocks.general.behaviors.placing.CeilingRequired;
import net.dark_roleplay.medieval.objects.blocks.other.old_tesr.TileEntityAnvil;
import net.dark_roleplay.medieval.objects.blocks.other.old_tesr.TileEntityCauldron;
import net.dark_roleplay.medieval.objects.blocks.other.old_tesr.TileEntityChain;
import net.dark_roleplay.medieval.objects.blocks.other.old_tesr.TileEntityFirepit;
import net.dark_roleplay.medieval.objects.blocks.other.old_tesr.TileEntityHook;
import net.dark_roleplay.medieval.objects.blocks.other.old_tesr.TileEntityKeyHanging;
import net.dark_roleplay.medieval.objects.blocks.other.old_tesr.TileEntityTarget;
import net.dark_roleplay.medieval.objects.blocks.plants.hops.Hops;
import net.dark_roleplay.medieval.objects.blocks.plants.mushrooms.Mushrooms;
import net.dark_roleplay.medieval.objects.blocks.utility.crafting.carpenter_workbench.simple_carpenter_workbench.SimpleCarpenterWorkbench;
import net.dark_roleplay.medieval.objects.blocks.utility.crafting.cauldron.HangingCauldron;
import net.dark_roleplay.medieval.objects.blocks.utility.crafting.chopping_block.TileEntityChoppingBlock;
import net.dark_roleplay.medieval.objects.blocks.utility.crafting.firepit.FirepitParticles;
import net.dark_roleplay.medieval.objects.blocks.utility.crafting.forge.Forge;
import net.dark_roleplay.medieval.objects.blocks.utility.crafting.grindstone.Grindstone;
import net.dark_roleplay.medieval.objects.blocks.utility.crafting.grindstone.TileEntityGrindstone;
import net.dark_roleplay.medieval.objects.blocks.utility.crafting.honey_centrifuge.HoneyCentrifuge;
import net.dark_roleplay.medieval.objects.blocks.utility.crafting.juice_press.JuicePress;
import net.dark_roleplay.medieval.objects.blocks.utility.other.clock_core.TileEntityClockCore;
import net.dark_roleplay.medieval.objects.blocks.utility.other.lecterns.large_lectern.LargeLectern;
import net.dark_roleplay.medieval.objects.blocks.utility.other.regenerating_ore.RegeneratingOre;
import net.dark_roleplay.medieval.objects.blocks.utility.other.work_table.WorkTable;
import net.dark_roleplay.medieval.objects.blocks.utility.storage.chests.simple_chest.SimpleChest;
import net.dark_roleplay.medieval.objects.blocks.utility.storage.chests.simple_chest.TileEntitySimpleChest;
import net.dark_roleplay.medieval.objects.blocks.utility.storage.shelfs.Shelf;
import net.dark_roleplay.medieval.objects.blocks.utility.storage.shelfs.TileEntityShelf;
import net.dark_roleplay.medieval.objects.items.DRPItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="drpmedieval")
public class BlockRegistryHandler {
    private static final MaterialRequirements logRequired = new MaterialRequirements(new String[]{"log_side", "log_top"});
    private static final MaterialRequirements plankRequired = new MaterialRequirements(new String[]{"planks"});
    private static final MaterialRequirements cleanPlankRequired = new MaterialRequirements(new String[]{"clean_planks"});

    @SubscribeEvent
    public static final void register(RegistryEvent.Register<Block> registryEvent) {
        IForgeRegistry reg = registryEvent.getRegistry();
        BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.BUILDING_MATS, new Block[]{new Roof("clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("white_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("orange_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("magenta_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("light_blue_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("yellow_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("light_green_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("pink_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("gray_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("light_gray_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("cyan_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("purple_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("blue_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("brown_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("green_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("red_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new Roof("black_clay_shingle_roof", MedievalBlockProperties.Settings.WOOD_ROOF), new DirtStairs("dirt_stairs", MedievalBlockProperties.Settings.STONE_DECO), new DoubleArch("stone_brick_double_arch", MedievalBlockProperties.Settings.STONE_DECO).addBehaviors(new IBlockBehavior[]{StoneArchPlacement.INSTANCE}), new DRPBlock("andesite_bricks", MedievalBlockProperties.Settings.STONE_SOLID), new DRPBlock("diorite_bricks", MedievalBlockProperties.Settings.STONE_SOLID), new DRPBlock("granite_bricks", MedievalBlockProperties.Settings.STONE_SOLID), new PillarBlock("andesite_pillar", MedievalBlockProperties.Settings.STONE_SOLID), new PillarBlock("diorite_pillar", MedievalBlockProperties.Settings.STONE_SOLID), new PillarBlock("granite_pillar", MedievalBlockProperties.Settings.STONE_SOLID), new DRPBlock("snow_bricks", MedievalBlockProperties.Settings.SNOW_SOLID), new DRPBlock("packed_ice_bricks", MedievalBlockProperties.Settings.PACKED_ICE), new DryClay("dry_clay"), new DryClayGrass("dry_clay_grass"), new AdvancedOre("tin_ore", 1), new AdvancedOre("copper_ore", 1), new AdvancedOre("salpeter_ore", 1), new AdvancedOre("sulfur_ore", 1), new AdvancedOre("silver_ore", 2), new DRPBlock("obsidian_glass", MedievalBlockProperties.Settings.OBSIDIAN_GLASS.setBlockRenderLayer(BlockRenderLayer.TRANSLUCENT)){

            @SideOnly(value=Side.CLIENT)
            public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                return blockState != iblockstate;
            }
        }});
        BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.DECORATION, new Block[]{new FacedBlock("minecart_stopper", MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 1.0, 0.875))}), new DRPBlock("mistletoe", MedievalBlockProperties.Settings.PLANT_DECO){

            public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
                return field_185506_k;
            }
        }.addBehaviors(new IBlockBehavior[]{CeilingRequired.INSTANCE, new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.25, 0.1875, 0.25, 0.75, 1.0, 0.75))}), new AdventWreath("advent_wreath", MedievalBlockProperties.Settings.PLANT_DECO).addBehaviors(new IBlockBehavior[]{new CandleLighting(), new CandleParticles(), new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.6825f, 1.0))})});
        BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.UTILITY, new Block[]{new FacedBlock("butter_churn", MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new Behavior_CraftingStation(), new FacedBoundingBox(new AxisAlignedBB(0.4375, 0.0, 0.3125, 0.8125, 0.75, 0.6875))}), new FacedBlock("spinning_wheel", MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.3125, 0.0, 0.0, 1.0, 0.6875, 1.0)), new Behavior_CraftingStation()}), new Grindstone("grindstone", MedievalBlockProperties.Settings.STONE_DECO).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375)), new Behavior_CraftingStation()}).setTileEntityFactory(TileEntityGrindstone::new), new DRPBlock("firepit_lit", MedievalBlockProperties.Settings.STONE_DECO_TESR.copy().setLightLevel(13)).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)), new Behavior_CraftingStation(), new FirepitParticles()}).setTileEntityFactory(TileEntityFirepit::new), new FacedBlock("cauldron", MedievalBlockProperties.Settings.METAL_DECO_TESR).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375)), new Behavior_CraftingStation()}).setTileEntityFactory(TileEntityCauldron::new), new FacedBlock("anvil", MedievalBlockProperties.Settings.METAL_DECO_TESR).addBehaviors(new IBlockBehavior[]{new Behavior_CraftingStation(), new FacedBoundingBox(new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 1.0, 0.8125))}).setTileEntityFactory(TileEntityAnvil::new), new FacedBlock("stone_mortar_and_pestle", MedievalBlockProperties.Settings.STONE_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75)), new Behavior_CraftingStation()}), new FacedBlock("wooden_mortar_and_pestle", MedievalBlockProperties.Settings.STONE_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75)), new Behavior_CraftingStation()}), new FacedBlock("clock_core", MedievalBlockProperties.Settings.WOOD_DECO).setTileEntityFactory(TileEntityClockCore::new).addBehaviors(new IBlockBehavior[]{new Behavior_ClockCore()}), new FacedBlock("pottery_turntable", MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 0.9375, 0.9375)), new Behavior_CraftingStation()}), new HangingCauldron("hanging_cauldron"), new JuicePress("juice_press", MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new Behavior_CraftingStation()})});
        BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.DECORATION, new Block[]{new FacedBlock("chain", MedievalBlockProperties.Settings.METAL_DECO_TESR).setTileEntityFactory(TileEntityChain::new).addBehaviors(new IBlockBehavior[]{new Behavior_CanPlaceChains(), new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625))}), new FacedBlock("iron_hook", MedievalBlockProperties.Settings.METAL_DECO_TESR).setTileEntityFactory(TileEntityHook::new).addBehaviors(new IBlockBehavior[]{new Behavior_CanPlaceChains(), new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.3125, 0.375, 0.3125, 0.6875, 1.0, 0.6875))}), new FacedBlock("golden_scale", MedievalBlockProperties.Settings.METAL_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 0.75))}), new FacedBlock("mug_beer", MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.4375, 0.6875))}), new FacedBlock("mug_empty", MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.4375, 0.6875))}), new Rope("rope"), new RopeAnchor("rope_anchor"), new WallMounted("key_hanging", MedievalBlockProperties.Settings.METAL_DECO_TESR, new AxisAlignedBB(0.3125, 0.125, 0.8125, 0.6875, 0.875, 1.0)).setTileEntityFactory(TileEntityKeyHanging::new), new DRPBlock("unfired_vase", MedievalBlockProperties.Settings.UNFIRED_POTTERY).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.59375, 0.6875))}), new DRPBlock("fired_vase", MedievalBlockProperties.Settings.FIRED_POTTERY).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.59375, 0.6875))}), new Mushrooms("mushroom_brown", MedievalBlockProperties.Settings.PLANT_DECO).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0))}), new Mushrooms("mushroom_red", MedievalBlockProperties.Settings.PLANT_DECO).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0))}), new BeesWaxCandle("beeswax_candle"), new RopeFence("rope_fence"), new FacedBlock("head_cutting_block", MedievalBlockProperties.Settings.STONE_DECO).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0))}), new ClockDial("clock_dial", new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0)), new DRPBlock("bee_hive", MedievalBlockProperties.Settings.PAPER_DECO).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 1.0, 0.8125))}), new EmptyWallMount("candle_holder_empty", MedievalBlockProperties.Settings.METAL_DECO, new AxisAlignedBB(0.3125, 0.0, 0.5, 0.6875, 0.9375, 1.0)), new LitWallMount("candle_holder_lit", MedievalBlockProperties.Settings.METAL_DECO, new AxisAlignedBB(0.3125, 0.0, 0.5, 0.6875, 0.9375, 1.0), 0.19, 1.05), new UnlitWallMount("candle_holder_unlit", MedievalBlockProperties.Settings.METAL_DECO, new AxisAlignedBB(0.3125, 0.0, 0.5, 0.6875, 0.9375, 1.0)), new EmptyWallMount("torch_holder_empty", MedievalBlockProperties.Settings.METAL_DECO, new AxisAlignedBB(0.375, (double)0.2f, 0.75, 0.625, (double)0.8f, 1.0)), new LitWallMount("torch_holder_lit", MedievalBlockProperties.Settings.METAL_DECO, new AxisAlignedBB(0.375, (double)0.2f, 0.75, 0.625, (double)0.8f, 1.0), 0.23, 0.82), new UnlitWallMount("torch_holder_unlit", MedievalBlockProperties.Settings.METAL_DECO, new AxisAlignedBB(0.375, (double)0.2f, 0.75, 0.625, (double)0.8f, 1.0)), new ShopSign("wall_shop_sign", MedievalBlockProperties.Settings.METAL_DECO).setTileEntityFactory(TileEntityShopSign::new), new Lantern("lantern", new Material(MapColor.field_151668_h), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75)), new FacedBlock("golden_ship_bell", MedievalBlockProperties.Settings.METAL_DECO).addBehaviors(new IBlockBehavior[]{new Behavior_Bell(), new FacedBoundingBox(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75))})});
        BlockRegistryHandler.registerNoItems((IForgeRegistry<Block>)reg, new Block[]{new Target("target", MedievalBlockProperties.Settings.WOOD_DECO_TESR).setTileEntityFactory(TileEntityTarget::new), new Hops("hops"), new HangingBridge("hanging_bridge_bottom", 0.0f), new HangingBridge("hanging_bridge_top", 0.5f), new Forge("forge", MedievalBlockProperties.Settings.METAL_DECO).addBehaviors(new IBlockBehavior[]{new Behavior_CraftingStation()}), new SimpleCarpenterWorkbench("simple_carpenter_workbench", MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new Behavior_CraftingStation()})});
        BlockSettings vanillaOre = new BlockSettings(Material.field_151576_e, SoundType.field_185851_d, 3.0f, 5.0f);
        BlockRegistryHandler.registerWithMeta((IForgeRegistry<Block>)reg, MedievalCreativeTabs.CREATIVE, (Block)new RegeneratingOre("regenerating_emerald_ore", vanillaOre, 2, new IntegerWrapper(Miscellaneous.REGEN_TIME_EMERALD)), "poor_emerald_ore", "emerald_ore", "rich_emerald_ore");
        BlockRegistryHandler.registerWithMeta((IForgeRegistry<Block>)reg, MedievalCreativeTabs.CREATIVE, (Block)new RegeneratingOre("regenerating_diamond_ore", vanillaOre, 2, new IntegerWrapper(Miscellaneous.REGEN_TIME_DIAMOND)), "poor_diamond_ore", "diamond_ore", "rich_diamond_ore");
        BlockRegistryHandler.registerWithMeta((IForgeRegistry<Block>)reg, MedievalCreativeTabs.CREATIVE, (Block)new RegeneratingOre("regenerating_lapis_ore", vanillaOre, 1, new IntegerWrapper(Miscellaneous.REGEN_TIME_LAPIS)), "poor_lapis_ore", "lapis_ore", "rich_lapis_ore");
        BlockRegistryHandler.registerWithMeta((IForgeRegistry<Block>)reg, MedievalCreativeTabs.CREATIVE, (Block)new RegeneratingOre("regenerating_redstone_ore", vanillaOre, 2, new IntegerWrapper(Miscellaneous.REGEN_TIME_REDSTONE)), "poor_redstone_ore", "redstone_ore", "rich_redstone_ore");
        BlockRegistryHandler.registerWithMeta((IForgeRegistry<Block>)reg, MedievalCreativeTabs.CREATIVE, (Block)new RegeneratingOre("regenerating_gold_ore", vanillaOre, 2, new IntegerWrapper(Miscellaneous.REGEN_TIME_GOLD)), "poor_gold_ore", "gold_ore", "rich_gold_ore");
        BlockRegistryHandler.registerWithMeta((IForgeRegistry<Block>)reg, MedievalCreativeTabs.CREATIVE, (Block)new RegeneratingOre("regenerating_iron_ore", vanillaOre, 1, new IntegerWrapper(Miscellaneous.REGEN_TIME_IRON)), "poor_iron_ore", "iron_ore", "rich_iron_ore");
        BlockRegistryHandler.registerWithMeta((IForgeRegistry<Block>)reg, MedievalCreativeTabs.CREATIVE, (Block)new RegeneratingOre("regenerating_coal_ore", vanillaOre, 0, new IntegerWrapper(Miscellaneous.REGEN_TIME_COAL)), "poor_coal_ore", "coal_ore", "rich_coal_ore");
        BlockRegistryHandler.registerWithMeta((IForgeRegistry<Block>)reg, MedievalCreativeTabs.CREATIVE, (Block)new RegeneratingOre("regenerating_quartz_ore", vanillaOre, 0, new IntegerWrapper(Miscellaneous.REGEN_TIME_QUARTZ)), "poor_quartz_ore", "quartz_ore", "rich_quartz_ore");
        MaterialRegistry.getMaterialsForType((String)"wood").forEach(mat -> {
            if (logRequired.doesFulfillRequirements(mat)) {
                if (plankRequired.doesFulfillRequirements(mat)) {
                    BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.UTILITY, new Block[]{new DRPBlock(mat.getNamed("%wood%_crate"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new Behavior_Container()}).setTileEntityFactory(() -> new DynamicStorageTileEntity(18)), new SimpleChest(mat.getNamed("simple_%wood%_chest"), MedievalBlockProperties.Settings.WOOD_DECO).setTileEntityFactory(TileEntitySimpleChest::new)});
                    BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.DECORATION, new Block[]{new WallMounted(mat.getNamed("%wood%_ships_helm"), MedievalBlockProperties.Settings.WOOD_DECO, new AxisAlignedBB(0.0, 0.0, 0.625, 1.0, 1.0, 1.0))});
                }
                if (cleanPlankRequired.doesFulfillRequirements(mat)) {
                    BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.BUILDING_MATS, new Block[]{new SimpleWoodStairs(mat.getNamed("simple_%wood%_stairs"), MedievalBlockProperties.Settings.WOOD_DECO)});
                    BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.UTILITY, new WorkTable(mat.getNamed("%wood%_work_table")));
                }
                BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.UTILITY, new Block[]{new FacedBlock(mat.getNamed("%wood%_chopping_block"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new Behavior_CraftingStation(), new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.75, 0.9375))}).setTileEntityFactory(TileEntityChoppingBlock::new)});
                BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.BUILDING_MATS, new Block[]{new MossyLog(mat.getNamed("mossy_%wood%_log"))});
                BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.DECORATION, new Block[]{new LogBench(mat.getNamed("%wood%_log_bench"), MedievalBlockProperties.Settings.WOOD_DECO, 7).addBehaviors(new IBlockBehavior[]{new Behavior_Chair(0.25f)}), new ChairBlock(mat.getNamed("%wood%_log_chair"), MedievalBlockProperties.Settings.WOOD_DECO, 6).addBehaviors(new IBlockBehavior[]{new Behavior_Chair(0.1875f)}), new AxisBlock(mat.getNamed("%wood%_firewood_pile"), MedievalBlockProperties.Settings.WOOD_DECO, (net.dark_roleplay.core_modules.maarg.api.materials.Material)mat){
                    final /* synthetic */ net.dark_roleplay.core_modules.maarg.api.materials.Material val$mat;
                    {
                        this.val$mat = material;
                        super(name, settings);
                    }

                    public int func_149745_a(Random random) {
                        return 16;
                    }

                    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
                        return Item.func_111206_d((String)this.val$mat.getNamed("drpmedieval:%wood%_firewood"));
                    }
                }});
            }
            if (plankRequired.doesFulfillRequirements(mat)) {
                BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.DECORATION, new Block[]{new ChairBlock(mat.getNamed("%wood%_barrel_chair"), MedievalBlockProperties.Settings.WOOD_DECO, 8).addBehaviors(new IBlockBehavior[]{new Behavior_Chair(0.3125f)}), new AxisBlock(mat.getNamed("%wood%_barrel_table"), MedievalBlockProperties.Settings.WOOD_DECO), new DRPBlock(mat.getNamed("%wood%_empty_barrel"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new Behavior_EmptyBarrel("drpmedieval:%wood%_fluid_barrel", (net.dark_roleplay.core_modules.maarg.api.materials.Material)mat)}), new DRPBlock(mat.getNamed("%wood%_closed_barrel"), MedievalBlockProperties.Settings.WOOD_DECO), new DRPBlock(mat.getNamed("%wood%_gunpowder_barrel"), MedievalBlockProperties.Settings.WOOD_DECO), new DRPBlock(mat.getNamed("%wood%_fluid_barrel"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new Behavior_FluidFill()}).setTileEntityFactory(TileEntityFluidBarrel::new), new SidewayBarrel(mat.getNamed("laying_%wood%_barrel"), MedievalBlockProperties.Settings.WOOD_DECO)});
            }
            if (cleanPlankRequired.doesFulfillRequirements(mat)) {
                SolidSimpleTable solidSimpleTable = new SolidSimpleTable(mat.getNamed("simple_solid_%wood%_table"));
                SimpleTable plankSimpleTable = new SimpleTable(mat.getNamed("simple_plank_%wood%_table"));
                BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.BUILDING_MATS, new Block[]{new Roof(mat.getNamed("%wood%_shingle_roof"), MedievalBlockProperties.Settings.WOOD_ROOF), new DRPBlock(mat.getNamed("%wood%_clean_plank"), MedievalBlockProperties.Settings.WOOD_SOLID), new WoodenWindow(mat.getNamed("%wood%_window_cross"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 0.9375))}), new WoodenWindow(mat.getNamed("%wood%_window_vertical"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 0.9375))}), new WoodenWindow(mat.getNamed("%wood%_window_dense_diamond"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 0.9375))}), new WoodenWindow(mat.getNamed("%wood%_window_dense_vertical"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 0.9375))}), new WoodenWindow(mat.getNamed("%wood%_window_grid"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new FacedBoundingBox(new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 0.9375))}), new WoodSupport(mat.getNamed("%wood%_wood_support"), MedievalBlockProperties.Settings.WOOD_DECO)});
                BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.UTILITY, new Block[]{new Shelf(mat.getNamed("simple_%wood%_shelf"), MedievalBlockProperties.Settings.WOOD_DECO).setTileEntityFactory(TileEntityShelf::new), new LargeLectern(mat.getNamed("large_%wood%_lectern")), new HoneyCentrifuge(mat.getNamed("%wood%_honey_centrifuge"), MedievalBlockProperties.Settings.WOOD_DECO)});
                BlockRegistryHandler.register((IForgeRegistry<Block>)reg, MedievalCreativeTabs.DECORATION, new Block[]{new ChairBlock(mat.getNamed("simple_plank_%wood%_chair"), MedievalBlockProperties.Settings.WOOD_DECO, 8).addBehaviors(new IBlockBehavior[]{new Behavior_Chair(0.3125f)}).addBehaviors(new IBlockBehavior[]{new IBoundingBoxBehavior.SimpleImpl(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375))}), new AxisBlock(mat.getNamed("%wood%_empty_bucket"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new AxisBoundingBox(new AxisAlignedBB(0.21875, 0.0, 0.21875, 0.78125, 0.5625, 0.78125))}), new AxisBlock(mat.getNamed("%wood%_water_bucket"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new AxisBoundingBox(new AxisAlignedBB(0.21875, 0.0, 0.21875, 0.78125, 0.5625, 0.78125))}), new AxisBlock(mat.getNamed("%wood%_dirt_bucket"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new AxisBoundingBox(new AxisAlignedBB(0.21875, 0.0, 0.21875, 0.78125, 0.5625, 0.78125)), new FlowerContainer()}).setTileEntityFactory(() -> new TileEntityFlowerContainer(3)), new AxisBlock(mat.getNamed("%wood%_flower_pot"), MedievalBlockProperties.Settings.WOOD_DECO).addBehaviors(new IBlockBehavior[]{new AxisBoundingBox(new AxisAlignedBB(0.21875, 0.0, 0.0, 0.78125, 0.5625, 1.0)), new FlowerContainer()}).setTileEntityFactory(() -> new TileEntityFlowerContainer(3)), solidSimpleTable, plankSimpleTable});
                BlockRegistryHandler.registerNoItems((IForgeRegistry<Block>)reg, new TimberedClay(mat.getNamed("%wood%_timbered_clay_clean"), 0), new TimberedClay(mat.getNamed("%wood%_timbered_clay_diagonal_bt"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_diagonal_tb"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_cross"), 2), new TimberedClay(mat.getNamed("%wood%_timbered_clay_double_diagonal_t_bt"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_double_diagonal_b_bt"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_double_diagonal_t_tb"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_double_diagonal_b_tb"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_arrow_b"), 2), new TimberedClay(mat.getNamed("%wood%_timbered_clay_arrow_t"), 2), new TimberedClay(mat.getNamed("%wood%_timbered_clay_arrow_r"), 2), new TimberedClay(mat.getNamed("%wood%_timbered_clay_arrow_l"), 2), new TimberedClay(mat.getNamed("%wood%_timbered_clay_double_diagonal_l_lr"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_double_diagonal_r_lr"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_double_diagonal_l_rl"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_double_diagonal_r_rl"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_vertical"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_horizontal"), 1), new TimberedClay(mat.getNamed("%wood%_timbered_clay_straight_cross"), 1));
            }
        });
    }

    private static void register(IForgeRegistry<Block> reg, CreativeTabs creativeTab, Block ... blocks) {
        for (Block block : blocks) {
            block.func_149647_a(creativeTab);
            ItemBlock itemBlock = (ItemBlock)new ItemBlock(block).setRegistryName(block.getRegistryName());
            ItemRegistryHandler.addItem((Item)itemBlock);
            ModelRegistryHandler.addItemToRegisterMesh((Item)itemBlock);
        }
        reg.registerAll((IForgeRegistryEntry[])blocks);
    }

    private static void registerWithMeta(IForgeRegistry<Block> reg, CreativeTabs creativeTab, Block block, String ... subNames) {
        block.func_149647_a(creativeTab);
        DRPItemBlock itemBlock = new DRPItemBlock(block.getRegistryName().func_110623_a(), block, "blocks", 64, subNames);
        itemBlock.func_77637_a(creativeTab);
        ItemRegistryHandler.addItem((Item)itemBlock);
        reg.register((IForgeRegistryEntry)block);
    }

    private static void registerNoItems(IForgeRegistry<Block> reg, Block ... blocks) {
        reg.registerAll((IForgeRegistryEntry[])blocks);
    }
}

