/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.handler;

import java.util.HashSet;
import java.util.Set;
import net.dark_roleplay.core.api.old.items.DRPFood;
import net.dark_roleplay.core_modules.maarg.api.arg.MaterialRequirements;
import net.dark_roleplay.core_modules.maarg.api.materials.Material;
import net.dark_roleplay.core_modules.maarg.handler.MaterialRegistry;
import net.dark_roleplay.library.util.InDevUtil;
import net.dark_roleplay.library_old.items.DRPItem;
import net.dark_roleplay.medieval.holders.MedievalBlocks;
import net.dark_roleplay.medieval.holders.MedievalCreativeTabs;
import net.dark_roleplay.medieval.objects.items.blocks.ItemHangingBridge;
import net.dark_roleplay.medieval.objects.items.blocks.ItemMultiBlock;
import net.dark_roleplay.medieval.objects.items.consumables.BarkAndGlue;
import net.dark_roleplay.medieval.objects.items.consumables.DRPMStew;
import net.dark_roleplay.medieval.objects.items.consumables.ItemFirewood;
import net.dark_roleplay.medieval.objects.items.consumables.Key;
import net.dark_roleplay.medieval.objects.items.consumables.Lock;
import net.dark_roleplay.medieval.objects.items.consumables.drinks.SpruceTea;
import net.dark_roleplay.medieval.objects.items.consumables.tools.FlintKnife;
import net.dark_roleplay.medieval.objects.items.consumables.tools.StreetStomper;
import net.dark_roleplay.medieval.objects.items.consumables.tools.Telescope;
import net.dark_roleplay.medieval.objects.items.consumables.tools.WarHorn;
import net.dark_roleplay.medieval.testing.purse.DRPCoin;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="drpmedieval")
public class ItemRegistryHandler {
    private static Set<Item> scheduledItems = new HashSet<Item>();

    @SubscribeEvent
    public static final void registerItems(RegistryEvent.Register<Item> registryEvent) {
        IForgeRegistry reg = registryEvent.getRegistry();
        ItemRegistryHandler.registerItems((IForgeRegistry<Item>)reg, MedievalCreativeTabs.EQUIPMENT, new Item[]{new FlintKnife("flint_knife", "equipment/tools/knifes", 1, new String[0]), new DRPItem("wood_wrench", "equipment/tools/wrenches", 1, new String[0]), new StreetStomper("wood_street_stomper", "equipment/tools/street_stompers", 1, 256, new String[0]), new StreetStomper("stone_street_stomper", "equipment/tools/street_stompers", 1, 512, new String[0]), new DRPItem("clean_paintbrush", "equipment/tools/paintbrushes", 1, new String[0]), new DRPItem("dirty_paintbrush", "equipment/tools/paintbrushes", 1, new String[0]), new Telescope("golden_telescope", "equipment/other/telescopes"), new Telescope("silver_telescope", "equipment/other/telescopes"), new WarHorn("bone_war_horn", "equipment/instruments/horns", 1, new String[0])});
        ItemRegistryHandler.registerItems((IForgeRegistry<Item>)reg, MedievalCreativeTabs.FOOD, new Item[]{new DRPFood(6, 0.5f, "honey_comb", "food/other/honey", 64, new String[0]), new DRPFood(3, 0.5f, "butter", "food/other/butter", 64, new String[0]), new DRPFood(4, 0.3f, "apple_green", "food/fruits/apples", 64, new String[0]), new DRPFood(4, 0.3f, "apple_yellow", "food/fruits/apples", 64, new String[0]), new DRPFood(1, 0.1f, "blue_berries", "food/fruits/berries", 64, new String[0]), new DRPFood(2, 0.2f, "grapes", "food/fruits/berries", 64, new String[0]), new DRPFood(4, 0.3f, "pear_green", "food/fruits/pears", 64, new String[0]), new DRPFood(4, 0.3f, "pear_yellow", "food/fruits/pears", 64, new String[0]), new DRPFood(6, 0.6f, "cooked_catfish", "food/fish/catfish", 64, new String[0]), new DRPFood(2, 0.3f, "raw_catfish", "food/fish/catfish", 64, new String[0]), new DRPFood(6, 0.4f, "cooked_wolf", "food/meat/wolf", 64, new String[0]), new DRPFood(2, 0.15f, "raw_wolf", "food/meat/wolf", 64, new String[0]), new DRPFood(2, 0.4f, "turnip", "food/vegetables", 64, new String[0]), new DRPFood(2, 0.4f, "eggplant", "food/vegetables", 64, new String[0]), new DRPFood(2, 0.4f, "hops", "food/vegetables", 64, new String[0]), new DRPFood(4, 0.6f, "cauliflower", "food/vegetables", 64, new String[0]), new DRPFood(2, 0.4f, "garlic", "food/vegetables", 64, new String[0]), new DRPFood(2, 0.4f, "onion", "food/vegetables", 64, new String[0]), new DRPFood(2, 0.4f, "bell_pepper", "food/vegetables", 64, new String[0]), new DRPFood(6, 0.5f, "pumpkin_bread", "food/bakewares/breads", 64, new String[0]), new DRPMStew(8, 0.5f, "chicken_stew", "food/stews"), new DRPMStew(7, 0.5f, "cod_stew", "food/stews"), new DRPMStew(6, 0.3f, "vegie_stew", "food/stews"), new DRPMStew(6, 0.3f, "pumpkin_stew", "food/stews"), new SpruceTea(1, 0.4f, "spruce_tea", "drinks"), new DRPFood(6, 0.8f, "caramelized_red_apple", "food/fruits/apples", 64, new String[0]), new DRPFood(6, 0.8f, "caramelized_green_apple", "food/fruits/apples", 64, new String[0]), new DRPFood(6, 0.8f, "caramelized_yellow_apple", "food/fruits/apples", 64, new String[0])});
        ItemRegistryHandler.registerItems((IForgeRegistry<Item>)reg, MedievalCreativeTabs.MATERIALS, new Item[]{new DRPItem("grass", "materials/plants", 64, new String[0]), new DRPItem("hay", "materials/plants", 64, new String[0]), new DRPItem("wheat_pumpkin_dough", "materials/cooking/doughs", 64, new String[0]), new DRPItem("barley_pumpkin_dough", "materials/cooking/doughs", 64, new String[0]), new DRPItem("barley", "materials/cooking/cereals", 64, new String[0]), new DRPItem("wheat_flour", "materials/cooking/flours", 64, new String[0]), new DRPItem("barley_flour", "materials/cooking/flours", 64, new String[0]), new DRPItem("wheat_dough", "materials/cooking/doughs", 64, new String[0]), new DRPItem("barley_dough", "materials/cooking/doughs", 64, new String[0]), new DRPCoin("bronze_coin", "consumables/currencies", 50, new String[0]), new DRPCoin("silver_coin", "consumables/currencies", 50, new String[0]), new DRPCoin("gold_coin", "consumables/currencies", 50, new String[0]), new DRPItem("bat_ear", "materials/mob_drops/bat", 64, new String[0]), new DRPItem("wolf_fur", "materials/mob_drops/wolf", 64, new String[0]), new DRPItem("tap", "consumables/attachments", 64, new String[0]), new DRPItem("trigger_trap", "consumables/attachments", 64, new String[0]), new DRPItem("leather_string", "materials/leather", 64, new String[0]), new DRPItem("tanned_leather_string", "materials/leather", 64, new String[0]), new DRPItem("tanned_leather", "materials/leather", 64, new String[0]), new DRPItem("leather_book_cover", "materials/books", 64, new String[0]), new DRPItem("thik_leather_book_cover", "materials/books", 64, new String[0]), new DRPItem("thin_leather_book_cover", "materials/books", 64, new String[0]), new DRPItem("dry_clay_chunk", "materials/minerals", 64, new String[0]), new DRPItem("silver_ore_chunk", "materials/minerals", 64, new String[0]), new DRPItem("tin_ore_chunk", "materials/minerals", 64, new String[0]), new DRPItem("copper_ore_chunk", "materials/minerals", 64, new String[0]), new DRPItem("sulfur_ore_chunk", "materials/minerals", 64, new String[0]), new DRPItem("salpeter_ore_chunk", "materials/minerals", 64, new String[0]), new DRPItem("charcoal_powder", "materials/processed_minerals", 64, new String[0]), new BarkAndGlue("bark_and_glue", "consumables/other", 64), new DRPItem("wood_cup", "consumables/other", 16, new String[0])});
        ItemRegistryHandler.registerItems((IForgeRegistry<Item>)reg, MedievalCreativeTabs.DECORATION, new Item[]{new ItemHangingBridge("hanging_bridge", "blocks", 64, new String[0])});
        ItemRegistryHandler.registerItems((IForgeRegistry<Item>)reg, MedievalCreativeTabs.CREATIVE, new Item[]{new Lock("wooden_lock", "consumables/locks", 16, new String[0]), new Key("wooden_key", "consumables/keys", 16, new String[0])});
        ItemRegistryHandler.registerItems((IForgeRegistry<Item>)reg, MedievalCreativeTabs.UTILITY, (Item)new ItemMultiBlock(MedievalBlocks.SIMPLE_CARPENTER_WORKBENCH).setRegistryName("simple_carpenter_workbench"), (Item)new ItemMultiBlock(MedievalBlocks.FORGE).setRegistryName("forge"));
        ItemRegistryHandler.registerItems((IForgeRegistry<Item>)reg, MedievalCreativeTabs.BUILDING_MATS, (Item)new ItemBlock(MedievalBlocks.OAK_TIMBERED_CLAY_CLEAN).setRegistryName("timbered_clay"));
        if (InDevUtil.isDevEnv()) {
            // empty if block
        }
        MaterialRequirements logRequired = new MaterialRequirements(new String[]{"log_side", "log_top"});
        MaterialRequirements planksRequired = new MaterialRequirements(new String[]{"planks"});
        MaterialRequirements cleanPlankRequired = new MaterialRequirements(new String[]{"clean_planks"});
        for (Material mat : MaterialRegistry.getMaterialsForType((String)"wood")) {
            if (cleanPlankRequired.doesFulfillRequirements(mat)) {
                ItemRegistryHandler.registerItems((IForgeRegistry<Item>)reg, MedievalCreativeTabs.MATERIALS, new Item[]{new DRPItem(mat.getName() + "_wood_beam", "materials/processed_materials/wood_beams", 64, new String[0]){

                    public int getItemBurnTime(ItemStack itemStack) {
                        return 400;
                    }
                }, new DRPItem(mat.getName() + "_planks", "materials/processed_materials/planks", 64, new String[0]){

                    public int getItemBurnTime(ItemStack itemStack) {
                        return 400;
                    }
                }});
            }
            if (!logRequired.doesFulfillRequirements(mat)) continue;
            ItemRegistryHandler.registerItems((IForgeRegistry<Item>)reg, MedievalCreativeTabs.MATERIALS, new Item[]{new ItemFirewood(mat.getName() + "_firewood", "materials/processed_materials/firewood", 64, new String[0])});
        }
        for (Item item : scheduledItems) {
            reg.register((IForgeRegistryEntry)item);
        }
    }

    protected static void registerItems(IForgeRegistry<Item> reg, CreativeTabs creativeTab, Item ... items) {
        for (Item item : items) {
            item.func_77637_a(creativeTab);
        }
        reg.registerAll((IForgeRegistryEntry[])items);
    }

    public static void addItem(Item item) {
        scheduledItems.add(item);
    }
}

