/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.handler;

import java.util.ArrayList;
import net.dark_roleplay.core_modules.maarg.api.arg.MaterialRequirements;
import net.dark_roleplay.core_modules.maarg.api.materials.Material;
import net.dark_roleplay.core_modules.maarg.handler.MaterialRegistry;
import net.dark_roleplay.library.experimental.connected_model.ConnectedModelLoader;
import net.dark_roleplay.library_old.items.DRPItem;
import net.dark_roleplay.library_old.items.ItemUtil;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.holders.MedievalBlocks;
import net.dark_roleplay.medieval.holders.MedievalItems;
import net.dark_roleplay.medieval.objects.blocks.building.roofs.StateMapperRoofs;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="drpmedieval", value={Side.CLIENT})
public class ModelRegistryHandler {
    static ArrayList<Item> toRegisterMeshes = new ArrayList();

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        ItemUtil.registerItemMeshs();
        for (Item item : toRegisterMeshes) {
            ModelRegistryHandler.registerItemMesh(item);
        }
        toRegisterMeshes = null;
        ModelRegistryHandler.registerItemMesh("old_blocks", MedievalBlocks.ANVIL);
        ModelRegistryHandler.registerItemMesh("old_blocks", MedievalBlocks.GRINDSTONE);
        ModelRegistryHandler.registerItemMesh("old_blocks", MedievalBlocks.HANGING_CAULDRON);
        ModelRegistryHandler.registerItemMesh("old_blocks", MedievalBlocks.MORTAR);
        ModelRegistryHandler.registerItemMesh("old_blocks", MedievalBlocks.CAULDRON);
        ModelRegistryHandler.registerItemMesh("old_blocks", MedievalBlocks.ROPE_ANCHOR);
        ModelRegistryHandler.registerItemMesh("old_blocks", MedievalBlocks.FIREPIT_LIT);
        ModelRegistryHandler.registerItemMesh("blocks", MedievalItems.TIMBERED_CLAY);
        StateMapperRoofs roofMapper = StateMapperRoofs.INSTANCE;
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.WHITE_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.ORANGE_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.MAGENTA_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.LIGHT_BLUE_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.YELLOW_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.LIGHT_GREEN_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.PINK_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.GRAY_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.LIGHT_GRAY_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.CYAN_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.PURPLE_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.BLUE_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.BROWN_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.GREEN_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.RED_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.Roofs.BLACK_CLAY_SHINGLE_ROOF, (IStateMapper)roofMapper);
        StateMap candlesRemover = new StateMap.Builder().func_178442_a(new IProperty[]{MedievalBlockProperties.BURNING_CANDLES}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)MedievalBlocks.ADVENT_WREATH, (IStateMapper)candlesRemover);
        MaterialRequirements cleanPlankRequired = new MaterialRequirements(new String[]{"clean_planks"});
        for (Material mat : MaterialRegistry.getMaterialsForType((String)"wood")) {
            if (!cleanPlankRequired.doesFulfillRequirements(mat)) continue;
            Block b = Block.func_149684_b((String)("drpmedieval:" + mat.getName() + "_shingle_roof"));
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)roofMapper);
            ModelLoader.setCustomStateMapper((Block)MedievalBlocks.ADVENT_WREATH, (IStateMapper)candlesRemover);
        }
        ModelLoader.registerItemVariants((Item)MedievalItems.TIMBERED_CLAY, (ResourceLocation[])new ResourceLocation[]{MedievalItems.TIMBERED_CLAY.getRegistryName()});
        ModelLoader.setCustomModelResourceLocation((Item)MedievalItems.TIMBERED_CLAY, (int)0, (ModelResourceLocation)new ModelResourceLocation(MedievalItems.TIMBERED_CLAY.getRegistryName().toString(), "inventory"));
        new ModelRegistryHandler().registerTables();
    }

    private void registerTables() {
        MaterialRequirements cleanPlankRequired = new MaterialRequirements(new String[]{"clean_planks"});
        for (Material mat : MaterialRegistry.getMaterialsForType((String)"wood")) {
            if (!cleanPlankRequired.doesFulfillRequirements(mat)) continue;
            Block solidSimpleTable = Block.func_149684_b((String)("drpmedieval:simple_solid_" + mat.getName() + "_table"));
            Block plankSimpleTable = Block.func_149684_b((String)("drpmedieval:simple_plank_" + mat.getName() + "_table"));
            ConnectedModelLoader.registerConnectedModelBlock((Block)solidSimpleTable);
            ConnectedModelLoader.registerConnectedModelBlock((Block)plankSimpleTable);
        }
    }

    public static void registerItemMesh(Block block) {
        ModelRegistryHandler.registerItemMesh(null, Item.func_150898_a((Block)block));
    }

    public static void registerItemMesh(String folder, Block block) {
        ModelRegistryHandler.registerItemMesh(folder, Item.func_150898_a((Block)block));
    }

    public static void registerItemMesh(Item item) {
        if (!(item instanceof DRPItem)) {
            ModelRegistryHandler.registerItemMesh(null, item);
        }
    }

    public static void addItemToRegisterMesh(Item item) {
        toRegisterMeshes.add(item);
    }

    public static void registerItemMesh(String folder, Item item) {
        String path = ModelRegistryHandler.stringParseName(item.getRegistryName().func_110623_a());
        if (folder != null) {
            path = ModelRegistryHandler.stringParseName(folder) + "/" + path;
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("drpmedieval:" + path)});
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("drpmedieval:" + path, "inventory"));
    }

    private static String stringParseName(String name) {
        char[] nameArray = name.toCharArray();
        ArrayList<Character> nameList = new ArrayList<Character>();
        for (int i = 0; i < nameArray.length; ++i) {
            if (Character.isUpperCase(nameArray[i])) {
                if (i > 0) {
                    nameList.add(Character.valueOf('_'));
                }
                nameList.add(Character.valueOf(Character.toLowerCase(nameArray[i])));
                continue;
            }
            nameList.add(Character.valueOf(nameArray[i]));
        }
        StringBuilder builder = new StringBuilder(nameList.size());
        for (Character ch : nameList) {
            builder.append(ch);
        }
        return builder.toString();
    }
}

