/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.block_properties;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import net.minecraftforge.common.property.IUnlistedProperty;

public class UnlistedPropertyBool
implements IUnlistedProperty<Boolean> {
    private final String name;
    private final ImmutableSet<Boolean> allowedValues = ImmutableSet.of((Object)true, (Object)false);

    protected UnlistedPropertyBool(String name) {
        this.name = name;
    }

    public static UnlistedPropertyBool create(String name) {
        return new UnlistedPropertyBool(name);
    }

    public Collection<Boolean> getAllowedValues() {
        return this.allowedValues;
    }

    public Optional<Boolean> parseValue(String value) {
        return !"true".equals(value) && !"false".equals(value) ? Optional.absent() : Optional.of((Object)Boolean.valueOf(value));
    }

    public String getName(Boolean value) {
        return value.toString();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof UnlistedPropertyBool && super.equals(p_equals_1_)) {
            UnlistedPropertyBool propertybool = (UnlistedPropertyBool)p_equals_1_;
            return this.allowedValues.equals(propertybool.allowedValues);
        }
        return false;
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.allowedValues.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid(Boolean value) {
        return this.allowedValues.contains((Object)value);
    }

    public Class<Boolean> getType() {
        return Boolean.class;
    }

    public String valueToString(Boolean value) {
        return String.valueOf(value);
    }
}

