/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.block_properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import net.minecraftforge.common.property.IUnlistedProperty;

public class UnlistedPropertyInteger
implements IUnlistedProperty<Integer> {
    private final String name;
    private final ImmutableSet<Integer> allowedValues;

    protected UnlistedPropertyInteger(String name, int min, int max) {
        this.name = name;
        if (min < 0) {
            throw new IllegalArgumentException("Min value of " + name + " must be 0 or greater");
        }
        if (max <= min) {
            throw new IllegalArgumentException("Max value of " + name + " must be greater than min (" + min + ")");
        }
        HashSet set = Sets.newHashSet();
        for (int i = min; i <= max; ++i) {
            set.add(i);
        }
        this.allowedValues = ImmutableSet.copyOf((Collection)set);
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid(Integer value) {
        return this.allowedValues.contains((Object)value);
    }

    public Class<Integer> getType() {
        return Integer.class;
    }

    public String valueToString(Integer value) {
        return String.valueOf(value);
    }

    public static UnlistedPropertyInteger create(String name, int min, int max) {
        return new UnlistedPropertyInteger(name, min, max);
    }
}

