/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.building.dry_clay;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.holders.MedievalBlocks;
import net.dark_roleplay.medieval.objects.blocks.building.hanging_bridge.HangingBridge;
import net.dark_roleplay.medieval.objects.other.DelayedBaker;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ModelLoaderHangingBridge
extends DelayedBaker
implements ICustomModelLoader {
    protected static final Map<IBlockState, List<BakedQuad>> CACHE = Maps.newHashMap();
    protected static ImmutableList<ResourceLocation> textures;
    protected static IModel[] planks;
    protected static IModel[] post_left;
    protected static IModel[] post_right;
    protected static IModel[] rope_side;

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        side = null;
        if (CACHE.containsKey(state)) {
            return CACHE.get(state);
        }
        ArrayList result = Lists.newArrayList();
        int yRot = state.func_177229_b(MedievalBlockProperties.AXIS_HORIZONTAL) == EnumFacing.Axis.Z ? 90 : 0;
        int height = (Integer)state.func_177229_b((IProperty)HangingBridge.HEIGHT) + (((HangingBridge)state.func_177230_c()).getRegistryName().func_110623_a().contains("top") ? 8 : 0);
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            boolean north = (Boolean)ext.getValue((IUnlistedProperty)HangingBridge.NORTH);
            boolean east = (Boolean)ext.getValue((IUnlistedProperty)HangingBridge.EAST);
            boolean south = (Boolean)ext.getValue((IUnlistedProperty)HangingBridge.SOUTH);
            boolean west = (Boolean)ext.getValue((IUnlistedProperty)HangingBridge.WEST);
            this.addQuads(result, planks[height], yRot, 0, state, side, rand);
            if (east) {
                this.addQuads(result, rope_side[height], yRot + 180, 0, state, side, rand);
                if (north) {
                    this.addQuads(result, post_right[height], yRot, 0, state, side, rand);
                }
                if (south) {
                    this.addQuads(result, post_left[height], yRot + 180, 0, state, side, rand);
                }
            }
            if (west) {
                this.addQuads(result, rope_side[height], yRot, 0, state, side, rand);
                if (north) {
                    this.addQuads(result, post_left[height], yRot, 0, state, side, rand);
                }
                if (south) {
                    this.addQuads(result, post_right[height], yRot + 180, 0, state, side, rand);
                }
            }
        }
        CACHE.put(state, result);
        return result;
    }

    public Collection<ResourceLocation> getTextures() {
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.bakeInfo(format, bakedTextureGetter, new ResourceLocation("drpmedieval", "blocks/clean_plank_spruce"));
        return this;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        CACHE.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation instanceof ModelResourceLocation && MedievalBlocks.HANGING_BRIDGE_BOTTOM.getRegistryName().equals((Object)modelLocation) || MedievalBlocks.HANGING_BRIDGE_TOP.getRegistryName().equals((Object)modelLocation);
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        int i;
        if (planks == null) {
            planks = new IModel[16];
            for (i = 0; i < 16; ++i) {
                ModelLoaderHangingBridge.planks[i] = ModelLoaderHangingBridge.getModel("planks_" + i);
            }
        }
        if (post_left == null) {
            post_left = new IModel[16];
            for (i = 0; i < 16; ++i) {
                ModelLoaderHangingBridge.post_left[i] = ModelLoaderHangingBridge.getModel("post_left_" + i);
            }
        }
        if (post_right == null) {
            post_right = new IModel[16];
            for (i = 0; i < 16; ++i) {
                ModelLoaderHangingBridge.post_right[i] = ModelLoaderHangingBridge.getModel("post_right_" + i);
            }
        }
        if (rope_side == null) {
            rope_side = new IModel[16];
            for (i = 0; i < 16; ++i) {
                ModelLoaderHangingBridge.rope_side[i] = ModelLoaderHangingBridge.getModel("rope_side_" + i);
            }
        }
        if (textures == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i2 = 0; i2 < 16; ++i2) {
                builder.addAll((Iterable)planks[i2].getTextures());
                builder.addAll((Iterable)post_left[i2].getTextures());
                builder.addAll((Iterable)post_right[i2].getTextures());
                builder.addAll((Iterable)rope_side[i2].getTextures());
            }
            textures = builder.build();
        }
        return this;
    }

    protected static IModel getModel(String modelName) {
        return ModelLoaderRegistry.getModelOrLogError((ResourceLocation)new ResourceLocation("drpmedieval", "block/hanging_bridge/" + modelName), (String)("A problem occured while trying to load: drpmedieval:block/hanging_bridge/" + modelName));
    }
}

