/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.building.hanging_bridge;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.holders.MedievalBlocks;
import net.dark_roleplay.medieval.holders.MedievalItems;
import net.dark_roleplay.medieval.objects.block_properties.UnlistedPropertyBool;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class HangingBridge
extends Block {
    public static final PropertyInteger HEIGHT = PropertyInteger.func_177719_a((String)"height", (int)0, (int)7);
    public static final UnlistedPropertyBool NORTH = UnlistedPropertyBool.create("north");
    public static final UnlistedPropertyBool SOUTH = UnlistedPropertyBool.create("south");
    public static final UnlistedPropertyBool WEST = UnlistedPropertyBool.create("west");
    public static final UnlistedPropertyBool EAST = UnlistedPropertyBool.create("east");
    public static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private float initialOffset = 0.0f;

    public HangingBridge(String registryName, float initialOffset) {
        super(Material.field_151575_d);
        this.setRegistryName(registryName);
        this.func_149663_c(registryName);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.0f);
        this.initialOffset = initialOffset;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return MedievalItems.HANGING_BRIDGE;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOTTOM_AABB.func_191194_a(new Vec3d(0.0, (double)(0.0625f * (float)((Integer)state.func_177229_b((IProperty)HEIGHT)).intValue() + this.initialOffset), 0.0)));
        if (state instanceof IExtendedBlockState) {
            boolean west;
            IExtendedBlockState ext = (IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos);
            boolean east = ext.getValue((IUnlistedProperty)EAST) == null ? false : (Boolean)ext.getValue((IUnlistedProperty)EAST);
            boolean bl = west = ext.getValue((IUnlistedProperty)WEST) == null ? false : (Boolean)ext.getValue((IUnlistedProperty)WEST);
            if (state.func_177229_b(MedievalBlockProperties.AXIS_HORIZONTAL) == EnumFacing.Axis.X) {
                if (west) {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.875, 0.0, 0.0625, 1.0, 1.0).func_191194_a(new Vec3d(0.0, (double)(0.0625f * (float)((Integer)state.func_177229_b((IProperty)HEIGHT)).intValue() + this.initialOffset), 0.0)));
                }
                if (east) {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.9375, 0.875, 0.0, 1.0, 1.0, 1.0).func_191194_a(new Vec3d(0.0, (double)(0.0625f * (float)((Integer)state.func_177229_b((IProperty)HEIGHT)).intValue() + this.initialOffset), 0.0)));
                }
            } else if (state.func_177229_b(MedievalBlockProperties.AXIS_HORIZONTAL) == EnumFacing.Axis.Z) {
                if (east) {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.875, 0.9375, 1.0, 1.0, 1.0).func_191194_a(new Vec3d(0.0, (double)(0.0625f * (float)((Integer)state.func_177229_b((IProperty)HEIGHT)).intValue() + this.initialOffset), 0.0)));
                }
                if (west) {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 0.0625).func_191194_a(new Vec3d(0.0, (double)(0.0625f * (float)((Integer)state.func_177229_b((IProperty)HEIGHT)).intValue() + this.initialOffset), 0.0)));
                }
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return MedievalItems.HANGING_BRIDGE.func_190903_i().func_77946_l();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOTTOM_AABB.func_191194_a(new Vec3d(0.0, (double)(0.0625f * (float)((Integer)state.func_177229_b((IProperty)HEIGHT)).intValue() + this.initialOffset), 0.0));
    }

    public IBlockState func_176203_a(int meta) {
        if (Math.floor(meta / 8) == 0.0) {
            return this.func_176223_P().func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)EnumFacing.Axis.X).func_177226_a((IProperty)HEIGHT, (Comparable)Integer.valueOf(meta));
        }
        return this.func_176223_P().func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)EnumFacing.Axis.Z).func_177226_a((IProperty)HEIGHT, (Comparable)Integer.valueOf(meta % 8));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (state.func_177229_b(MedievalBlockProperties.AXIS_HORIZONTAL) == EnumFacing.Axis.Z) {
            meta += 8;
        }
        return meta += ((Integer)state.func_177229_b((IProperty)HEIGHT)).intValue();
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{MedievalBlockProperties.AXIS_HORIZONTAL, HEIGHT}, new IUnlistedProperty[]{NORTH, SOUTH, EAST, WEST});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        switch (placer.func_174811_aO().func_176734_d()) {
            case EAST: 
            case WEST: {
                return this.func_176223_P().func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)EnumFacing.Axis.Z);
            }
            case NORTH: 
            case SOUTH: {
                return this.func_176223_P().func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)EnumFacing.Axis.X);
            }
        }
        return this.func_176223_P().func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)EnumFacing.Axis.X);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            boolean north = true;
            boolean east = true;
            boolean south = true;
            boolean west = true;
            if (((EnumFacing.Axis)state.func_177229_b(MedievalBlockProperties.AXIS_HORIZONTAL)).equals((Object)EnumFacing.Axis.X)) {
                if (this.doesBlockAlign(world, pos.func_177978_c())) {
                    north = false;
                }
                if (this.doesBlockAlign(world, pos.func_177974_f())) {
                    east = false;
                }
                if (this.doesBlockAlign(world, pos.func_177968_d())) {
                    south = false;
                }
                if (this.doesBlockAlign(world, pos.func_177976_e())) {
                    west = false;
                }
            } else if (((EnumFacing.Axis)state.func_177229_b(MedievalBlockProperties.AXIS_HORIZONTAL)).equals((Object)EnumFacing.Axis.Z)) {
                if (this.doesBlockAlign(world, pos.func_177974_f())) {
                    north = false;
                }
                if (this.doesBlockAlign(world, pos.func_177968_d())) {
                    east = false;
                }
                if (this.doesBlockAlign(world, pos.func_177976_e())) {
                    south = false;
                }
                if (this.doesBlockAlign(world, pos.func_177978_c())) {
                    west = false;
                }
            }
            ext = ext.withProperty((IUnlistedProperty)NORTH, (Object)north).withProperty((IUnlistedProperty)EAST, (Object)east).withProperty((IUnlistedProperty)SOUTH, (Object)south).withProperty((IUnlistedProperty)WEST, (Object)west);
            state = ext;
        }
        return state;
    }

    private boolean doesBlockAlign(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().equals(MedievalBlocks.HANGING_BRIDGE_BOTTOM) || world.func_180495_p(pos).func_177230_c().equals(MedievalBlocks.HANGING_BRIDGE_TOP) || world.func_180495_p(pos.func_177984_a()).func_177230_c().equals(MedievalBlocks.HANGING_BRIDGE_BOTTOM) || world.func_180495_p(pos.func_177984_a()).func_177230_c().equals(MedievalBlocks.HANGING_BRIDGE_TOP) || world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(MedievalBlocks.HANGING_BRIDGE_BOTTOM) || world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(MedievalBlocks.HANGING_BRIDGE_TOP);
    }

    private void breakBridge(World world, BlockPos pos, BlockPos prevPos, EnumFacing.Axis axis) {
        if (world.func_180495_p(pos).func_177230_c() instanceof HangingBridge) {
            world.func_175655_b(pos, true);
            if (axis == EnumFacing.Axis.X) {
                boolean dir = pos.func_177952_p() > prevPos.func_177952_p();
                this.breakBridge(world, pos.func_177982_a(0, 0, dir ? 1 : -1), pos, axis);
                this.breakBridge(world, pos.func_177982_a(0, 1, dir ? 1 : -1), pos, axis);
                this.breakBridge(world, pos.func_177982_a(0, -1, dir ? 1 : -1), pos, axis);
            } else {
                boolean dir = pos.func_177958_n() > prevPos.func_177958_n();
                this.breakBridge(world, pos.func_177982_a(dir ? 1 : -1, 0, 0), pos, axis);
                this.breakBridge(world, pos.func_177982_a(dir ? 1 : -1, 1, 0), pos, axis);
                this.breakBridge(world, pos.func_177982_a(dir ? 1 : -1, -1, 0), pos, axis);
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(MedievalBlockProperties.AXIS_HORIZONTAL);
        switch (rot) {
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: {
                axis = axis == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
                break;
            }
        }
        return state.func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)axis);
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state;
    }
}

