/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.building.roofs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.dark_roleplay.library.experimental.blocks.BlockSettings;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.objects.blocks.building.roofs.TileEntityRoof;
import net.dark_roleplay.medieval.objects.blocks.general.FacedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Roof
extends FacedBlock {
    protected static final AxisAlignedBB AABB_QTR_TOP_WEST = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_EAST = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_NORTH = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_QTR_TOP_SOUTH = new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_NW = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_NE = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_SW = new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_SE = new AxisAlignedBB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_EAST = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_QTR_BOT_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_NE = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_SW = new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_SE = new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 0.5, 1.0);

    public Roof(String name, BlockSettings settings) {
        super(name, settings);
        this.func_180632_j(this.func_176223_P().func_177226_a(MedievalBlockProperties.STAIR_TYPE, (Comparable)((Object)MedievalBlockProperties.StairType.STRAIGHT)).func_177226_a((IProperty)MedievalBlockProperties.SNOWED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.HAS_TE, (Comparable)Boolean.valueOf(false)));
        this.field_149783_u = true;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MedievalBlockProperties.FACING_HORIZONTAL, MedievalBlockProperties.STAIR_TYPE, MedievalBlockProperties.HAS_TE, MedievalBlockProperties.SNOWED});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)MedievalBlockProperties.HAS_TE, (Comparable)Boolean.valueOf((meta & 8) == 8)).func_177226_a((IProperty)MedievalBlockProperties.SNOWED, (Comparable)Boolean.valueOf((meta & 4) == 4));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.SNOWED) != false ? 4 : 0) | ((Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.HAS_TE) != false ? 8 : 0);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        IBlockState otherBlock = world.func_180495_p(pos.func_177972_a(facing));
        IBlockState otherBlock2 = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        IBlockState otherBlock3 = world.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
        IBlockState otherBlock4 = world.func_180495_p(pos.func_177972_a(facing.func_176735_f()));
        if (otherBlock.func_177230_c() instanceof Roof && otherBlock.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL) == facing.func_176746_e()) {
            return state.func_177226_a(MedievalBlockProperties.STAIR_TYPE, (Comparable)((Object)MedievalBlockProperties.StairType.INNER_LEFT));
        }
        if (otherBlock.func_177230_c() instanceof Roof && otherBlock.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL) == facing.func_176735_f()) {
            return state.func_177226_a(MedievalBlockProperties.STAIR_TYPE, (Comparable)((Object)MedievalBlockProperties.StairType.INNER_RIGHT));
        }
        if (otherBlock2.func_177230_c() instanceof Roof && otherBlock2.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL) == facing.func_176746_e() && (!(otherBlock3.func_177230_c() instanceof Roof) || otherBlock3.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL) != facing)) {
            return state.func_177226_a(MedievalBlockProperties.STAIR_TYPE, (Comparable)((Object)MedievalBlockProperties.StairType.OUTER_LEFT));
        }
        if (otherBlock2.func_177230_c() instanceof Roof && otherBlock2.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL) == facing.func_176735_f() && (!(otherBlock4.func_177230_c() instanceof Roof) || otherBlock4.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL) != facing)) {
            return state.func_177226_a(MedievalBlockProperties.STAIR_TYPE, (Comparable)((Object)MedievalBlockProperties.StairType.OUTER_RIGHT));
        }
        return state;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)MedievalBlockProperties.HAS_TE, (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177977_b()).func_185917_h()));
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)MedievalBlockProperties.HAS_TE, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177977_b()).func_185917_h())));
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.HAS_TE);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityRoof();
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : Roof.getCollisionBoxList(state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)((EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)).func_176734_d()))) {
            Roof.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.SNOWED)).booleanValue() && player.func_184586_b(hand).func_77973_b() instanceof ItemTool) {
            ItemStack held = player.func_184586_b(hand);
            ItemTool tool = (ItemTool)held.func_77973_b();
            if (tool.getToolClasses(held).contains("shovel")) {
                if (!player.func_184812_l_()) {
                    held.func_77972_a(1, (EntityLivingBase)player);
                }
                world.func_175656_a(pos, state.func_177226_a((IProperty)MedievalBlockProperties.SNOWED, (Comparable)Boolean.valueOf(false)));
                for (int i = 0; i < 15; ++i) {
                    world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.8f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150431_aC.func_176223_P())});
                }
                world.func_184133_a(null, pos, Blocks.field_150431_aC.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, 2.0f, 1.0f);
                return true;
            }
        } else if (!((Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.SNOWED)).booleanValue() && player.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150431_aC)) {
            if (!player.func_184812_l_()) {
                player.func_184586_b(hand).func_190918_g(1);
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)MedievalBlockProperties.SNOWED, (Comparable)Boolean.valueOf(true)));
            world.func_184133_a(null, pos, Blocks.field_150431_aC.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, 2.0f, 1.0f);
            return true;
        }
        return false;
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState bstate) {
        ArrayList list = Lists.newArrayList();
        list.add(AABB_SLAB_BOTTOM);
        MedievalBlockProperties.StairType stairType = (MedievalBlockProperties.StairType)((Object)bstate.func_177229_b(MedievalBlockProperties.STAIR_TYPE));
        if (stairType == MedievalBlockProperties.StairType.STRAIGHT || stairType == MedievalBlockProperties.StairType.INNER_LEFT || stairType == MedievalBlockProperties.StairType.INNER_RIGHT) {
            list.add(Roof.getCollQuarterBlock(bstate));
        }
        if (stairType != MedievalBlockProperties.StairType.STRAIGHT) {
            list.add(Roof.getCollEighthBlock(bstate));
        }
        return list;
    }

    private static AxisAlignedBB getCollQuarterBlock(IBlockState bstate) {
        switch ((EnumFacing)bstate.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)) {
            default: {
                return AABB_QTR_TOP_NORTH;
            }
            case SOUTH: {
                return AABB_QTR_TOP_SOUTH;
            }
            case WEST: {
                return AABB_QTR_TOP_WEST;
            }
            case EAST: 
        }
        return AABB_QTR_TOP_EAST;
    }

    private static AxisAlignedBB getCollEighthBlock(IBlockState bstate) {
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)bstate.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        switch ((MedievalBlockProperties.StairType)((Object)bstate.func_177229_b(MedievalBlockProperties.STAIR_TYPE))) {
            default: {
                enumfacing1 = enumfacing.func_176746_e();
                break;
            }
            case OUTER_RIGHT: {
                enumfacing1 = enumfacing;
                break;
            }
            case INNER_RIGHT: {
                enumfacing1 = enumfacing;
                break;
            }
            case INNER_LEFT: {
                enumfacing1 = enumfacing.func_176746_e();
            }
        }
        switch (enumfacing1) {
            default: {
                return AABB_OCT_TOP_NW;
            }
            case SOUTH: {
                return AABB_OCT_TOP_SE;
            }
            case WEST: {
                return AABB_OCT_TOP_SW;
            }
            case EAST: 
        }
        return AABB_OCT_TOP_NE;
    }
}

