/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.building.roofs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.objects.blocks.building.roofs.TileEntityRoof;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.FastTESR;
import org.apache.commons.lang3.ArrayUtils;

public class SpecialRendererRoof
extends FastTESR<TileEntityRoof> {
    public static Map<IBlockState, TextureAtlasSprite> north = new HashMap<IBlockState, TextureAtlasSprite>();
    public static Map<IBlockState, TextureAtlasSprite> east = new HashMap<IBlockState, TextureAtlasSprite>();
    public static Map<IBlockState, TextureAtlasSprite> south = new HashMap<IBlockState, TextureAtlasSprite>();
    public static Map<IBlockState, TextureAtlasSprite> west = new HashMap<IBlockState, TextureAtlasSprite>();
    private BakedRoof model = null;

    public void renderTileEntityFast(TileEntityRoof te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        try {
            BlockRendererDispatcher blockRenderDispatcher = Minecraft.func_71410_x().func_175602_ab();
            World world = te.func_145831_w();
            BlockPos pos = te.func_174877_v();
            IBlockState otherState = world.func_180495_p(pos.func_177977_b());
            if (!otherState.func_185917_h()) {
                return;
            }
            if (!north.containsKey(otherState)) {
                IBakedModel modelOther = blockRenderDispatcher.func_184389_a(otherState);
                north.put(otherState, ((BakedQuad)modelOther.func_188616_a(otherState, EnumFacing.NORTH, 0L).get(0)).func_187508_a());
                east.put(otherState, ((BakedQuad)modelOther.func_188616_a(otherState, EnumFacing.EAST, 0L).get(0)).func_187508_a());
                south.put(otherState, ((BakedQuad)modelOther.func_188616_a(otherState, EnumFacing.SOUTH, 0L).get(0)).func_187508_a());
                west.put(otherState, ((BakedQuad)modelOther.func_188616_a(otherState, EnumFacing.WEST, 0L).get(0)).func_187508_a());
            }
            EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
            TextureAtlasSprite sprite = north.get(otherState);
            this.model = new BakedRoof(facing, sprite, (MedievalBlockProperties.StairType)((Object)world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos).func_177229_b(MedievalBlockProperties.STAIR_TYPE)));
            BlockPos offset = pos;
            if (world.func_175623_d(pos.func_177977_b())) {
                return;
            }
            buffer.func_178969_c(x - (double)offset.func_177958_n(), y - (double)offset.func_177956_o() - 1.0, z - (double)offset.func_177952_p());
            blockRenderDispatcher.func_175019_b().func_178267_a((IBlockAccess)world, (IBakedModel)this.model, world.func_180495_p(pos), pos, buffer, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), 0};
    }

    private static int[] createFullQuad(EnumFacing facing, TextureAtlasSprite sprite) {
        int[] output = new int[]{};
        switch (facing) {
            case DOWN: {
                break;
            }
            case EAST: {
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 0.0f, -1, sprite, 0.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 1.0f, -1, sprite, 16.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 2.0f, 1.0f, -1, sprite, 16.0f, 0.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 2.0f, 0.0f, -1, sprite, 0.0f, 0.0f));
                break;
            }
            case NORTH: {
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 1.0f, -1, sprite, 0.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 1.0f, -1, sprite, 16.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 2.0f, 1.0f, -1, sprite, 16.0f, 0.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 2.0f, 1.0f, -1, sprite, 0.0f, 0.0f));
                break;
            }
            case SOUTH: {
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 0.0f, -1, sprite, 16.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 0.0f, -1, sprite, 0.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 2.0f, 0.0f, -1, sprite, 0.0f, 0.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 2.0f, 0.0f, -1, sprite, 16.0f, 0.0f));
                break;
            }
            case UP: {
                break;
            }
            case WEST: {
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 0.0f, -1, sprite, 16.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 1.0f, -1, sprite, 0.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 2.0f, 1.0f, -1, sprite, 0.0f, 0.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 2.0f, 0.0f, -1, sprite, 16.0f, 0.0f));
                break;
            }
        }
        return output;
    }

    private static int[] createTriangleQuad(EnumFacing facing, boolean inverted, TextureAtlasSprite sprite) {
        int[] output = new int[]{};
        switch (facing) {
            case DOWN: {
                break;
            }
            case EAST: {
                if (inverted) {
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 0.0f, -1, sprite, 0.0f, 16.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 1.0f, -1, sprite, 16.0f, 16.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 2.0f, 1.0f, -1, sprite, 16.0f, 0.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.5f, 0.5f, -1, sprite, 8.0f, 8.0f));
                    break;
                }
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 0.0f, -1, sprite, 0.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 1.0f, -1, sprite, 16.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.5f, 0.5f, -1, sprite, 8.0f, 8.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 2.0f, 0.0f, -1, sprite, 0.0f, 0.0f));
                break;
            }
            case NORTH: {
                if (inverted) {
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 1.0f, -1, sprite, 0.0f, 16.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 1.0f, -1, sprite, 16.0f, 16.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 2.0f, 1.0f, -1, sprite, 16.0f, 0.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.5f, 1.5f, 1.0f, -1, sprite, 8.0f, 8.0f));
                    break;
                }
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 1.0f, -1, sprite, 0.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 1.0f, -1, sprite, 16.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.5f, 1.5f, 1.0f, -1, sprite, 8.0f, 8.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 2.0f, 1.0f, -1, sprite, 0.0f, 0.0f));
                break;
            }
            case SOUTH: {
                if (inverted) {
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 0.0f, -1, sprite, 16.0f, 16.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 0.0f, -1, sprite, 0.0f, 16.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.5f, 1.5f, 0.0f, -1, sprite, 8.0f, 8.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 2.0f, 0.0f, -1, sprite, 16.0f, 0.0f));
                    break;
                }
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.0f, 1.0f, 0.0f, -1, sprite, 16.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 0.0f, -1, sprite, 0.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 2.0f, 0.0f, -1, sprite, 0.0f, 0.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(0.5f, 1.5f, 0.0f, -1, sprite, 8.0f, 8.0f));
                break;
            }
            case UP: {
                break;
            }
            case WEST: {
                if (inverted) {
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 0.0f, -1, sprite, 16.0f, 16.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 1.0f, -1, sprite, 0.0f, 16.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.5f, 0.5f, -1, sprite, 8.0f, 8.0f));
                    output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 2.0f, 0.0f, -1, sprite, 16.0f, 0.0f));
                    break;
                }
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 0.0f, -1, sprite, 16.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.0f, 1.0f, -1, sprite, 0.0f, 16.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 2.0f, 1.0f, -1, sprite, 0.0f, 0.0f));
                output = ArrayUtils.addAll((int[])output, (int[])SpecialRendererRoof.vertexToInts(1.0f, 1.5f, 0.5f, -1, sprite, 8.0f, 8.0f));
                break;
            }
        }
        return output;
    }

    private class BakedRoof
    implements IBakedModel {
        List<BakedQuad> facingCWQ = new ArrayList<BakedQuad>();
        List<BakedQuad> facingQ = new ArrayList<BakedQuad>();
        List<BakedQuad> facingCCWQ = new ArrayList<BakedQuad>();
        List<BakedQuad> facingMQ = new ArrayList<BakedQuad>();
        EnumFacing facing = null;

        public BakedRoof(EnumFacing facing, TextureAtlasSprite sprite, MedievalBlockProperties.StairType type) {
            this.facing = facing.func_176734_d();
            switch (type) {
                case INNER_LEFT: {
                    this.facingQ.add(new BakedQuad(SpecialRendererRoof.createFullQuad(facing, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingCWQ.add(new BakedQuad(SpecialRendererRoof.createFullQuad(facing.func_176746_e(), sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingCCWQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing.func_176735_f(), false, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingMQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing.func_176734_d(), true, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    break;
                }
                case INNER_RIGHT: {
                    this.facingQ.add(new BakedQuad(SpecialRendererRoof.createFullQuad(facing, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingCCWQ.add(new BakedQuad(SpecialRendererRoof.createFullQuad(facing.func_176735_f(), sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingCWQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing.func_176746_e(), true, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingMQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing.func_176734_d(), false, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    break;
                }
                case OUTER_LEFT: {
                    this.facingQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing, false, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingCWQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing.func_176746_e(), true, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    break;
                }
                case OUTER_RIGHT: {
                    this.facingQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing, true, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingCWQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing.func_176735_f(), false, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    break;
                }
                case STRAIGHT: {
                    this.facingQ.add(new BakedQuad(SpecialRendererRoof.createFullQuad(facing, sprite), 1, facing, sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingCWQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing.func_176746_e(), true, sprite), 1, facing.func_176746_e(), sprite, true, DefaultVertexFormats.field_176600_a));
                    this.facingCCWQ.add(new BakedQuad(SpecialRendererRoof.createTriangleQuad(facing.func_176735_f(), false, sprite), 1, facing.func_176735_f(), sprite, true, DefaultVertexFormats.field_176600_a));
                    break;
                }
            }
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == this.facing) {
                return this.facingQ;
            }
            if (side == this.facing.func_176746_e()) {
                return this.facingCWQ;
            }
            if (side == this.facing.func_176735_f()) {
                return this.facingCCWQ;
            }
            if (side == this.facing.func_176734_d()) {
                return this.facingMQ;
            }
            return new ArrayList<BakedQuad>();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemOverrideList func_188617_f() {
            return null;
        }
    }
}

