/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.building.timbered_clay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.dark_roleplay.medieval.holders.MedievalItems;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TimberedClay
extends Block {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final Map<EntityPlayer, ClickInfo> clicks = new WeakHashMap<EntityPlayer, ClickInfo>();
    public static final Map<String, List<TimberRecipe>> recipes = new HashMap<String, List<TimberRecipe>>();
    private int woodBeamAmount = 0;
    private Item woodBeamItem = null;

    public TimberedClay(String name, int woodBeamAmount) {
        super(Material.field_151576_e);
        this.woodBeamAmount = woodBeamAmount;
        this.setRegistryName(name);
        this.func_149663_c("timbered_clay");
        this.func_149711_c(1.25f);
        this.func_149752_b(7.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf((meta & 8) == 8)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf((meta & 4) == 4)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf((meta & 2) == 2)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            meta |= 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)RIGHT)).booleanValue()) {
            meta |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)LEFT)).booleanValue()) {
            meta |= 1;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, RIGHT, LEFT});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList stacks = NonNullList.func_191196_a();
        int frameAmount = 0;
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            ++frameAmount;
        }
        if (((Boolean)state.func_177229_b((IProperty)LEFT)).booleanValue()) {
            ++frameAmount;
        }
        if (((Boolean)state.func_177229_b((IProperty)RIGHT)).booleanValue()) {
            ++frameAmount;
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            ++frameAmount;
        }
        if (this.woodBeamAmount + frameAmount > 0) {
            stacks.add((Object)new ItemStack(this.woodBeamItem == null ? (this.woodBeamItem = Item.func_111206_d((String)(this.getRegistryName().toString().split("_timbered_clay")[0] + "_wood_beam"))) : this.woodBeamItem, this.woodBeamAmount + frameAmount));
        }
        stacks.add((Object)new ItemStack(MedievalItems.TIMBERED_CLAY, 1));
        return stacks;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            return false;
        }
        if (player.func_184586_b(hand).func_77973_b().getRegistryName().toString().endsWith("_wood_beam")) {
            if (world.field_72995_K) {
                return true;
            }
            if (clicks.containsKey(player)) {
                ClickInfo info = clicks.get(player);
                if (!info.equals(pos)) {
                    clicks.replace(player, new ClickInfo(pos, ClickLoc.getLoc(facing, hitX, hitY, hitZ)));
                    return true;
                }
                clicks.remove(player);
                ClickLoc pos1 = info.getLoc();
                ClickLoc pos2 = ClickLoc.getLoc(facing, hitX, hitY, hitZ);
                String[] types = state.func_177230_c().getRegistryName().func_110623_a().split("_timbered_clay_");
                String[] itemTypes = player.func_184586_b(hand).func_77973_b().getRegistryName().func_110623_a().split("_wood_beam");
                if (!(!this.getRegistryName().func_110623_a().contains("clean") || ((Boolean)state.func_177229_b((IProperty)UP)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)RIGHT)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)LEFT)).booleanValue())) {
                    if (!types[0].equals(itemTypes[0])) {
                        IBlockState newState = ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(state.func_177230_c().getRegistryName().toString().replace(types[0], itemTypes[0])))).func_176223_P();
                        world.func_175656_a(pos, newState);
                        state = newState;
                        types = state.func_177230_c().getRegistryName().func_110623_a().split("_timbering_");
                    }
                } else if (!types[0].equals(itemTypes[0])) {
                    return false;
                }
                boolean succes = false;
                if (!((Boolean)state.func_177229_b((IProperty)UP)).booleanValue() && (pos1 == ClickLoc.TOP_LEFT && pos2 == ClickLoc.TOP_RIGHT || pos1 == ClickLoc.TOP_RIGHT && pos2 == ClickLoc.TOP_LEFT)) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(true)));
                    succes = true;
                } else if (!((Boolean)state.func_177229_b((IProperty)RIGHT)).booleanValue() && (pos1 == ClickLoc.BOTTOM_RIGHT && pos2 == ClickLoc.TOP_RIGHT || pos1 == ClickLoc.TOP_RIGHT && pos2 == ClickLoc.BOTTOM_RIGHT)) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(true)));
                    succes = true;
                } else if (!((Boolean)state.func_177229_b((IProperty)LEFT)).booleanValue() && (pos1 == ClickLoc.TOP_LEFT && pos2 == ClickLoc.BOTTOM_LEFT || pos1 == ClickLoc.BOTTOM_LEFT && pos2 == ClickLoc.TOP_LEFT)) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(true)));
                    succes = true;
                } else if (!((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue() && (pos1 == ClickLoc.BOTTOM_LEFT && pos2 == ClickLoc.BOTTOM_RIGHT || pos1 == ClickLoc.BOTTOM_RIGHT && pos2 == ClickLoc.BOTTOM_LEFT)) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(true)));
                    succes = true;
                } else if (recipes.containsKey(types[1])) {
                    List<TimberRecipe> recipes = TimberedClay.recipes.get(types[1]);
                    for (TimberRecipe recipe : recipes) {
                        if (!recipe.equals(pos1, pos2)) continue;
                        world.func_175656_a(pos, ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(state.func_177230_c().getRegistryName().func_110624_b(), types[0] + "_timbered_clay_" + recipe.getOutput()))).func_176223_P().func_177226_a((IProperty)UP, state.func_177229_b((IProperty)UP)).func_177226_a((IProperty)DOWN, state.func_177229_b((IProperty)DOWN)).func_177226_a((IProperty)LEFT, state.func_177229_b((IProperty)LEFT)).func_177226_a((IProperty)RIGHT, state.func_177229_b((IProperty)RIGHT)));
                        succes = true;
                        break;
                    }
                }
                if (succes && !player.field_71075_bZ.field_75098_d) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                return true;
            }
            clicks.put(player, new ClickInfo(pos, ClickLoc.getLoc(facing, hitX, hitY, hitZ)));
            return true;
        }
        return false;
    }

    static {
        recipes.put("clean", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.TOP, ClickLoc.BOTTOM, "vertical"));
                this.add(new TimberRecipe(ClickLoc.LEFT, ClickLoc.RIGHT, "horizontal"));
                this.add(new TimberRecipe(ClickLoc.BOTTOM_LEFT, ClickLoc.TOP_RIGHT, "diagonal_bt"));
                this.add(new TimberRecipe(ClickLoc.TOP_LEFT, ClickLoc.BOTTOM_RIGHT, "diagonal_tb"));
                this.add(new TimberRecipe(ClickLoc.BOTTOM, ClickLoc.TOP_RIGHT, "double_diagonal_t_bt"));
                this.add(new TimberRecipe(ClickLoc.BOTTOM_LEFT, ClickLoc.TOP, "double_diagonal_b_bt"));
                this.add(new TimberRecipe(ClickLoc.BOTTOM, ClickLoc.TOP_LEFT, "double_diagonal_t_tb"));
                this.add(new TimberRecipe(ClickLoc.TOP, ClickLoc.BOTTOM_RIGHT, "double_diagonal_b_tb"));
                this.add(new TimberRecipe(ClickLoc.BOTTOM_LEFT, ClickLoc.RIGHT, "double_diagonal_l_lr"));
                this.add(new TimberRecipe(ClickLoc.LEFT, ClickLoc.TOP_RIGHT, "double_diagonal_r_lr"));
                this.add(new TimberRecipe(ClickLoc.TOP_LEFT, ClickLoc.RIGHT, "double_diagonal_l_rl"));
                this.add(new TimberRecipe(ClickLoc.LEFT, ClickLoc.BOTTOM_RIGHT, "double_diagonal_r_rl"));
            }
        });
        recipes.put("diagonal_bt", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.TOP_LEFT, ClickLoc.BOTTOM_RIGHT, "cross"));
            }
        });
        recipes.put("diagonal_tb", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.BOTTOM_LEFT, ClickLoc.TOP_RIGHT, "cross"));
            }
        });
        recipes.put("double_diagonal_t_bt", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.TOP_LEFT, ClickLoc.BOTTOM, "arrow_b"));
            }
        });
        recipes.put("double_diagonal_t_tb", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.BOTTOM, ClickLoc.TOP_RIGHT, "arrow_b"));
            }
        });
        recipes.put("double_diagonal_b_bt", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.TOP, ClickLoc.BOTTOM_RIGHT, "arrow_t"));
            }
        });
        recipes.put("double_diagonal_b_tb", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.TOP, ClickLoc.BOTTOM_LEFT, "arrow_t"));
            }
        });
        recipes.put("double_diagonal_l_lr", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.TOP_LEFT, ClickLoc.RIGHT, "arrow_r"));
            }
        });
        recipes.put("double_diagonal_l_rl", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.BOTTOM_LEFT, ClickLoc.RIGHT, "arrow_r"));
            }
        });
        recipes.put("double_diagonal_r_lr", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.LEFT, ClickLoc.BOTTOM_RIGHT, "arrow_l"));
            }
        });
        recipes.put("double_diagonal_r_rl", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.LEFT, ClickLoc.TOP_RIGHT, "arrow_l"));
            }
        });
        recipes.put("horizontal", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.TOP, ClickLoc.BOTTOM, "straight_cross"));
            }
        });
        recipes.put("vertical", (List<TimberRecipe>)new ArrayList<TimberRecipe>(){
            {
                this.add(new TimberRecipe(ClickLoc.LEFT, ClickLoc.RIGHT, "straight_cross"));
            }
        });
    }

    public static enum ClickLoc {
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        RIGHT,
        BOTTOM_RIGHT,
        BOTTOM,
        BOTTOM_LEFT,
        LEFT,
        CENTER;


        public static ClickLoc getLoc(EnumFacing facing, float hitX, float hitY, float hitZ) {
            ClickLoc[] locations = ClickLoc.getLocationsForHeight(hitY);
            switch (facing) {
                case EAST: {
                    return hitZ < 0.25f ? locations[2] : (hitZ > 0.75f ? locations[0] : locations[1]);
                }
                case NORTH: {
                    return hitX < 0.25f ? locations[0] : (hitX > 0.75f ? locations[2] : locations[1]);
                }
                case SOUTH: {
                    return hitX < 0.25f ? locations[0] : (hitX > 0.75f ? locations[2] : locations[1]);
                }
                case WEST: {
                    return hitZ < 0.25f ? locations[2] : (hitZ > 0.75f ? locations[0] : locations[1]);
                }
            }
            return null;
        }

        private static ClickLoc[] getLocationsForHeight(float hitY) {
            if (hitY > 0.75f) {
                return new ClickLoc[]{TOP_LEFT, TOP, TOP_RIGHT};
            }
            if (hitY < 0.25f) {
                return new ClickLoc[]{BOTTOM_LEFT, BOTTOM, BOTTOM_RIGHT};
            }
            return new ClickLoc[]{LEFT, CENTER, RIGHT};
        }
    }

    public static class ClickInfo {
        BlockPos pos;
        ClickLoc loc;

        public ClickInfo(BlockPos pos, ClickLoc loc) {
            this.pos = pos;
            this.loc = loc;
        }

        public boolean equals(BlockPos pos) {
            return this.pos.equals((Object)pos);
        }

        public ClickLoc getLoc() {
            return this.loc;
        }

        public BlockPos getPos() {
            return this.pos;
        }
    }

    public static class TimberRecipe {
        private ClickLoc loc1;
        private ClickLoc loc2;
        private String output;

        public TimberRecipe(ClickLoc loc1, ClickLoc loc2, String output) {
            this.loc1 = loc1;
            this.loc2 = loc2;
            this.output = output;
        }

        public boolean equals(ClickLoc loc1, ClickLoc loc2) {
            return this.loc1 == loc1 && this.loc2 == loc2 || this.loc1 == loc2 && this.loc2 == loc1;
        }

        public String getOutput() {
            return this.output;
        }

        public ClickLoc getLoc1() {
            return this.loc1;
        }

        public ClickLoc getLoc2() {
            return this.loc2;
        }
    }
}

