/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.building.wood_supports;

import net.dark_roleplay.library.experimental.blocks.BlockSettings;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.objects.blocks.general.FacedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WoodSupport
extends FacedBlock {
    public static PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)5);
    public static AxisAlignedBB[] boundingBoxes = new AxisAlignedBB[9];

    public WoodSupport(String registryName, BlockSettings settings) {
        super(registryName, settings);
        WoodSupport.boundingBoxes[0] = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        WoodSupport.boundingBoxes[1] = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.25);
        WoodSupport.boundingBoxes[2] = new AxisAlignedBB(0.75, 0.0, 0.75, 1.0, 1.0, 1.0);
        WoodSupport.boundingBoxes[3] = this.rotateAABB(boundingBoxes[1], 1);
        WoodSupport.boundingBoxes[4] = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 0.25);
        WoodSupport.boundingBoxes[5] = this.rotateAABB(boundingBoxes[1], 2);
        WoodSupport.boundingBoxes[6] = this.rotateAABB(boundingBoxes[2], 2);
        WoodSupport.boundingBoxes[7] = this.rotateAABB(boundingBoxes[1], 3);
        WoodSupport.boundingBoxes[8] = this.rotateAABB(boundingBoxes[4], 2);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta % 4)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)(meta / 4)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE) % 3 + ((EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)).func_176736_b() * 4;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, MedievalBlockProperties.FACING_HORIZONTAL});
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)TYPE, (Comparable)(world.func_180495_p(pos.func_177984_a()).isSideSolid(world, pos.func_177977_b(), EnumFacing.DOWN) ? Integer.valueOf((Integer)state.func_177229_b((IProperty)TYPE) + 3) : (Integer)state.func_177229_b((IProperty)TYPE)));
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P();
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            state = state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0));
        } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            if ((double)hitX <= 0.2) {
                state = state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)(facing == EnumFacing.NORTH ? facing.func_176734_d() : facing.func_176735_f().func_176734_d()));
                state = state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(2));
            } else if ((double)hitX >= 0.8) {
                state = state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)(facing == EnumFacing.NORTH ? facing.func_176735_f().func_176734_d() : facing.func_176734_d()));
                state = state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(2));
            } else {
                state = state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing.func_176734_d());
                state = state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(1));
            }
        } else if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
            if ((double)hitZ <= 0.2) {
                state = state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)(facing == EnumFacing.EAST ? facing.func_176734_d() : facing.func_176735_f().func_176734_d()));
                state = state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(2));
            } else if ((double)hitZ >= 0.8) {
                state = state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)(facing == EnumFacing.EAST ? facing.func_176735_f().func_176734_d() : facing.func_176734_d()));
                state = state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(2));
            } else {
                state = state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing.func_176734_d());
                state = state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(1));
            }
        }
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        if ((Integer)state.func_177229_b((IProperty)TYPE) == 0) {
            return boundingBoxes[0];
        }
        if ((Integer)state.func_177229_b((IProperty)TYPE) == 1) {
            return facing == EnumFacing.NORTH ? boundingBoxes[1] : (facing == EnumFacing.EAST ? boundingBoxes[7] : (facing == EnumFacing.WEST ? boundingBoxes[3] : boundingBoxes[5]));
        }
        if ((Integer)state.func_177229_b((IProperty)TYPE) == 2) {
            return facing == EnumFacing.NORTH ? boundingBoxes[4] : (facing == EnumFacing.EAST ? boundingBoxes[2] : (facing == EnumFacing.WEST ? boundingBoxes[6] : boundingBoxes[8]));
        }
        return boundingBoxes[2];
    }

    private AxisAlignedBB rotateAABB(AxisAlignedBB bb, int amount) {
        switch (amount) {
            case 0: {
                return bb;
            }
            case 1: {
                return new AxisAlignedBB(bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
            }
            case 2: {
                return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
            }
            case 3: {
                return new AxisAlignedBB(1.0 - bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
            }
        }
        return bb;
    }

    @Override
    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        int type = (Integer)state.func_177229_b((IProperty)TYPE);
        if (type == 0) {
            return state;
        }
        switch (mirror) {
            case FRONT_BACK: {
                if (type == 2 || type == 5) {
                    facing = facing.func_176746_e();
                    break;
                }
                if (facing != EnumFacing.EAST && facing != EnumFacing.WEST) break;
                facing = facing.func_176734_d();
                break;
            }
            case LEFT_RIGHT: {
                if (type == 2 || type == 5) {
                    facing = facing.func_176735_f();
                    break;
                }
                if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH) break;
                facing = facing.func_176734_d();
            }
        }
        return state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing);
    }
}

