/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.decoration.clock_dial;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.holders.MedievalBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClockDial
extends Block {
    public static final PropertyInteger POSITION = PropertyInteger.func_177719_a((String)"position", (int)0, (int)8);
    private AxisAlignedBB northBB;
    private AxisAlignedBB eastBB;
    private AxisAlignedBB southBB;
    private AxisAlignedBB westBB;

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MedievalBlockProperties.FACING_HORIZONTAL, POSITION});
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public ClockDial(String registreName, AxisAlignedBB northBB) {
        super(Material.field_151575_d);
        this.setRegistryName(registreName);
        this.func_149663_c(registreName);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.northBB = northBB;
        this.westBB = this.rotateAABB(this.northBB, 1);
        this.southBB = this.rotateAABB(this.northBB, 2);
        this.eastBB = this.rotateAABB(this.northBB, 3);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta % 4));
        return this.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing).func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(meta / 4));
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        int i = facing.func_176736_b();
        int pos = (Integer)state.func_177229_b((IProperty)POSITION);
        if (pos != 0) {
            i += 4 * (pos % 2 + 1);
        }
        return i;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        world.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
        world.func_175656_a(pos.func_177977_b(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
        switch (facing.func_176740_k()) {
            case X: {
                world.func_175656_a(pos.func_177978_c(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177968_d(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177978_c().func_177984_a(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177968_d().func_177984_a(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177978_c().func_177977_b(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177968_d().func_177977_b(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                break;
            }
            case Z: {
                world.func_175656_a(pos.func_177974_f(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177976_e(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177974_f().func_177984_a(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177976_e().func_177984_a(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177974_f().func_177977_b(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                world.func_175656_a(pos.func_177976_e().func_177977_b(), this.func_176223_P().func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing));
                break;
            }
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (world.func_180495_p(pos.func_177972_a(side.func_176734_d())).func_177230_c() != MedievalBlocks.CLOCK_CORE) {
            return false;
        }
        if (side.func_176740_k() == EnumFacing.Axis.X) {
            return this.canPlacePart(world, pos) && this.canPlacePart(world, pos.func_177984_a()) && this.canPlacePart(world, pos.func_177977_b()) && this.canPlacePart(world, pos.func_177978_c()) && this.canPlacePart(world, pos.func_177968_d());
        }
        if (side.func_176740_k() == EnumFacing.Axis.Z) {
            return this.canPlacePart(world, pos) && this.canPlacePart(world, pos.func_177984_a()) && this.canPlacePart(world, pos.func_177977_b()) && this.canPlacePart(world, pos.func_177974_f()) && this.canPlacePart(world, pos.func_177976_e());
        }
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if ((Integer)state.func_177229_b((IProperty)POSITION) == 0) {
            return Item.func_150898_a((Block)this);
        }
        return null;
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        int position = (Integer)state.func_177229_b((IProperty)POSITION);
        for (int i = 0; i < 14 && position != 0; ++i) {
            switch (i) {
                case 0: 
                case 6: 
                case 7: 
                case 12: 
                case 13: {
                    pos = pos.func_177984_a();
                    break;
                }
                case 1: {
                    pos = pos.func_177976_e();
                    break;
                }
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    pos = pos.func_177977_b();
                    break;
                }
                case 4: 
                case 5: {
                    pos = pos.func_177974_f();
                    break;
                }
                case 8: {
                    pos = pos.func_177976_e().func_177978_c();
                    break;
                }
                case 11: {
                    pos = pos.func_177968_d().func_177968_d();
                }
            }
            position = world.func_180495_p(pos).func_177230_c() == this ? (Integer)world.func_180495_p(pos).func_177229_b((IProperty)POSITION) : 2;
        }
        if (position == 0) {
            world.func_175655_b(pos, true);
            world.func_175655_b(pos.func_177984_a(), true);
            world.func_175655_b(pos.func_177977_b(), true);
            switch (facing.func_176740_k()) {
                case X: {
                    world.func_175655_b(pos.func_177978_c(), true);
                    world.func_175655_b(pos.func_177968_d(), true);
                    world.func_175655_b(pos.func_177978_c().func_177984_a(), true);
                    world.func_175655_b(pos.func_177968_d().func_177984_a(), true);
                    world.func_175655_b(pos.func_177978_c().func_177977_b(), true);
                    world.func_175655_b(pos.func_177968_d().func_177977_b(), true);
                    break;
                }
                case Z: {
                    world.func_175655_b(pos.func_177974_f(), true);
                    world.func_175655_b(pos.func_177976_e(), true);
                    world.func_175655_b(pos.func_177974_f().func_177984_a(), true);
                    world.func_175655_b(pos.func_177976_e().func_177984_a(), true);
                    world.func_175655_b(pos.func_177974_f().func_177977_b(), true);
                    world.func_175655_b(pos.func_177976_e().func_177977_b(), true);
                    break;
                }
            }
        }
    }

    private boolean canPlacePart(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int position = (Integer)state.func_177229_b((IProperty)POSITION);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        if (position == 0) {
            return state;
        }
        if (position == 1) {
            if (this.checkSide(world, pos.func_177972_a(facing.func_176746_e()))) {
                return state.func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(3));
            }
            if (this.checkSide(world, pos.func_177972_a(facing.func_176746_e().func_176734_d()))) {
                return state.func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(7));
            }
            if (this.checkSide(world, pos.func_177984_a())) {
                return state.func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(5));
            }
        } else if (position == 2) {
            if (this.checkCorner(world, pos.func_177972_a(facing.func_176746_e())) && this.checkCorner(world, pos.func_177984_a())) {
                return state.func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(4));
            }
            if (this.checkCorner(world, pos.func_177972_a(facing.func_176735_f())) && this.checkCorner(world, pos.func_177984_a())) {
                return state.func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(6));
            }
            if (this.checkCorner(world, pos.func_177972_a(facing.func_176735_f())) && this.checkCorner(world, pos.func_177977_b())) {
                return state.func_177226_a((IProperty)POSITION, (Comparable)Integer.valueOf(8));
            }
            return state;
        }
        return state;
    }

    private boolean checkSide(IBlockAccess world, BlockPos pos) {
        IBlockState state2 = world.func_180495_p(pos);
        return state2.func_177230_c() == this && (Integer)state2.func_177229_b((IProperty)POSITION) == 0;
    }

    private boolean checkCorner(IBlockAccess world, BlockPos pos) {
        IBlockState state2 = world.func_180495_p(pos);
        return state2.func_177230_c() == this && (Integer)state2.func_177229_b((IProperty)POSITION) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"drpmedieval.item.clock_dial.tooltip", (Object[])new Object[]{I18n.func_135052_a((String)"tile.drpmedieval.clock_core.name", (Object[])new Object[0])}));
    }

    private AxisAlignedBB rotateAABB(AxisAlignedBB bb, int amount) {
        switch (amount) {
            case 0: {
                return bb;
            }
            case 1: {
                return new AxisAlignedBB(bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
            }
            case 2: {
                return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
            }
            case 3: {
                return new AxisAlignedBB(1.0 - bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
            }
        }
        return bb;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)) {
            case NORTH: {
                return this.northBB;
            }
            case EAST: {
                return this.eastBB;
            }
            case SOUTH: {
                return this.southBB;
            }
            case WEST: {
                return this.westBB;
            }
        }
        return this.northBB;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        switch (rot) {
            case CLOCKWISE_180: {
                facing = facing.func_176746_e().func_176746_e();
                break;
            }
            case CLOCKWISE_90: {
                facing = facing.func_176746_e();
                break;
            }
            case COUNTERCLOCKWISE_90: {
                facing = facing.func_176735_f();
                break;
            }
            case NONE: {
                break;
            }
        }
        return state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing);
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        switch (mirror) {
            case FRONT_BACK: {
                if (facing != EnumFacing.EAST && facing != EnumFacing.WEST) break;
                facing = facing.func_176734_d();
                break;
            }
            case LEFT_RIGHT: {
                if (facing != EnumFacing.SOUTH && facing != EnumFacing.NORTH) break;
                facing = facing.func_176734_d();
            }
        }
        return state.func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing);
    }
}

