/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.decoration.flower_container;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityFlowerContainer
extends TileEntity {
    private FlowerData[] flowers = new FlowerData[0];

    public TileEntityFlowerContainer() {
    }

    public TileEntityFlowerContainer(int flowersAmount) {
        this.flowers = new FlowerData[flowersAmount];
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (!compound.func_74764_b("FlowerAmount")) {
            return;
        }
        this.flowers = new FlowerData[compound.func_74762_e("FlowerAmount")];
        NBTTagList flowersList = compound.func_150295_c("Flowers", 10);
        for (int i = 0; i < flowersList.func_74745_c(); ++i) {
            NBTTagCompound flowerTag = flowersList.func_150305_b(i);
            FlowerData flower = new FlowerData(null);
            flower.readFromNBT(flowerTag);
            this.flowers[flowerTag.func_74771_c((String)"Position")] = flower;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        NBTTagList flowerList = new NBTTagList();
        for (byte i = 0; i < this.flowers.length; i = (byte)((byte)(i + 1))) {
            FlowerData flower = this.flowers[i];
            if (flower == null) continue;
            NBTTagCompound flowerTag = flower.writeToNBT();
            flowerTag.func_74774_a("Position", i);
            flowerList.func_74742_a((NBTBase)flowerTag);
        }
        compound.func_74768_a("FlowerAmount", this.flowers.length);
        compound.func_74782_a("Flowers", (NBTBase)flowerList);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public boolean addFlower(ItemStack stack) {
        for (int i = 0; i < this.flowers.length; ++i) {
            stack.func_190920_e(1);
            if (this.flowers[i] != null) continue;
            this.flowers[i] = new FlowerData(stack);
            return true;
        }
        return false;
    }

    public ItemStack removeFlower() {
        for (int i = 0; i < this.flowers.length; ++i) {
            if (this.flowers[i] == null) continue;
            ItemStack stack = this.flowers[i].getStack();
            this.flowers[i] = null;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public FlowerData[] getFlowerData() {
        return this.flowers;
    }

    public static class FlowerData {
        protected ItemStack stack;
        IBakedModel model;
        IBlockState state;

        public FlowerData(ItemStack stack) {
            this.stack = stack;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.stack = new ItemStack(compound);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound = this.stack.func_77955_b(compound);
            return compound;
        }

        public IBakedModel getModel() {
            return this.model;
        }

        public IBlockState getState() {
            return this.state;
        }

        public void gatherBakedModel() {
            IBlockState state;
            Item item = this.stack.func_77973_b();
            if (!(item instanceof ItemBlock)) {
                return;
            }
            ItemBlock block = (ItemBlock)item;
            this.state = state = block.func_179223_d().func_176203_a(item.getMetadata(this.stack));
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            this.model = blockrendererdispatcher.func_184389_a(state);
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

