/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.decoration.lantern;

import java.util.List;
import java.util.Random;
import net.dark_roleplay.medieval.holders.MedievalBlocks;
import net.dark_roleplay.medieval.holders.MedievalItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Lantern
extends Block {
    public static final PropertyBool CANDLE = PropertyBool.func_177716_a((String)"candle");
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    private AxisAlignedBB northBB;

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.55f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public Lantern(String registryName, Material material, AxisAlignedBB northBB) {
        super(material);
        this.setRegistryName(registryName);
        this.func_149663_c(registryName);
        this.northBB = northBB;
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.northBB;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)CANDLE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CANDLE, (Comparable)Boolean.valueOf(meta > 0)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta / 2 == 1));
    }

    public int func_176201_c(IBlockState state) {
        int meta;
        int n = meta = (Boolean)state.func_177229_b((IProperty)CANDLE) != false ? 1 : 0;
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta *= 2;
        }
        return meta;
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList stacks = NonNullList.func_191196_a();
        stacks.add((Object)new ItemStack(MedievalItems.LANTERN));
        if (((Boolean)state.func_177229_b((IProperty)CANDLE)).booleanValue()) {
            stacks.add((Object)new ItemStack(MedievalItems.BEESWAX_CANDLE));
        }
        return stacks;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CANDLE, LIT});
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            boolean hasCandle = (Boolean)state.func_177229_b((IProperty)CANDLE);
            ItemStack heldStack = player.func_184586_b(hand);
            if (heldStack.func_190926_b() && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && player.func_70093_af()) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            } else if (!hasCandle && heldStack.func_77973_b() == Item.func_150898_a((Block)MedievalBlocks.BEESWAX_CANDLE)) {
                player.func_184586_b(hand).func_190918_g(1);
                world.func_175656_a(pos, state.func_177226_a((IProperty)CANDLE, (Comparable)Boolean.valueOf(true)));
            } else if (hasCandle && heldStack.func_77973_b() == Items.field_151033_d) {
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            }
        }
        return true;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }
}

