/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.decoration.rope_fence;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.dark_roleplay.medieval.holders.MedievalBlocks;
import net.dark_roleplay.medieval.objects.blocks.decoration.rope_fence.RopeFence;
import net.dark_roleplay.medieval.objects.other.DelayedBaker;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ModelLoaderRopeFence
extends DelayedBaker
implements ICustomModelLoader {
    protected static final Map<String, List<BakedQuad>> CACHE = Maps.newHashMap();
    protected static ImmutableList<ResourceLocation> textures;
    protected static IModel pole;
    protected static IModel straight_rope0;
    protected static IModel straight_rope1;
    protected static IModel straight_rope2;
    protected static IModel diagonal_rope;

    public void func_110549_a(IResourceManager resourceManager) {
        CACHE.clear();
        pole = null;
        straight_rope0 = null;
        straight_rope1 = null;
        straight_rope2 = null;
        diagonal_rope = null;
        textures = null;
    }

    public Collection<ResourceLocation> getTextures() {
        return textures;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        String stateKey;
        side = null;
        if (state == null || !(state instanceof IExtendedBlockState)) {
            ArrayList result = Lists.newArrayList();
            this.addQuads(result, pole, 0, 0, state, side, rand);
            return result;
        }
        int north = 3;
        int east = 3;
        int south = 3;
        int west = 3;
        boolean north_east = (Boolean)state.func_177229_b((IProperty)RopeFence.NORTH_EAST);
        boolean south_east = (Boolean)state.func_177229_b((IProperty)RopeFence.SOUTH_EAST);
        boolean south_west = (Boolean)state.func_177229_b((IProperty)RopeFence.SOUTH_WEST);
        boolean north_west = (Boolean)state.func_177229_b((IProperty)RopeFence.NORTH_WEST);
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)state;
            if (exState.getUnlistedNames().contains(RopeFence.NORTH) && exState.getValue((IUnlistedProperty)RopeFence.NORTH) != null) {
                north = (Integer)exState.getValue((IUnlistedProperty)RopeFence.NORTH);
            }
            if (exState.getUnlistedNames().contains(RopeFence.EAST)) {
                east = (Integer)exState.getValue((IUnlistedProperty)RopeFence.EAST);
            }
            if (exState.getUnlistedNames().contains(RopeFence.SOUTH)) {
                south = (Integer)exState.getValue((IUnlistedProperty)RopeFence.SOUTH);
            }
            if (exState.getUnlistedNames().contains(RopeFence.WEST)) {
                west = (Integer)exState.getValue((IUnlistedProperty)RopeFence.WEST);
            }
        }
        if (CACHE.containsKey(stateKey = north_east + "" + south_east + south_west + north_west + "" + north + east + south + west)) {
            return CACHE.get(stateKey);
        }
        ArrayList result = Lists.newArrayList();
        this.addQuads(result, pole, 0, 0, state, side, rand);
        if (north == 2) {
            this.addQuads(result, straight_rope2, 180, 0, state, side, rand);
        } else if (north == 1) {
            this.addQuads(result, straight_rope1, 0, 0, state, side, rand);
        } else if (north == 0) {
            this.addQuads(result, straight_rope0, 0, 0, state, side, rand);
        }
        if (east == 2) {
            this.addQuads(result, straight_rope2, 270, 0, state, side, rand);
        } else if (east == 1) {
            this.addQuads(result, straight_rope1, 90, 0, state, side, rand);
        } else if (east == 0) {
            this.addQuads(result, straight_rope0, 90, 0, state, side, rand);
        }
        if (south == 2) {
            this.addQuads(result, straight_rope2, 0, 0, state, side, rand);
        } else if (south == 1) {
            this.addQuads(result, straight_rope1, 180, 0, state, side, rand);
        } else if (south == 0) {
            this.addQuads(result, straight_rope0, 180, 0, state, side, rand);
        }
        if (west == 2) {
            this.addQuads(result, straight_rope2, 90, 0, state, side, rand);
        } else if (west == 1) {
            this.addQuads(result, straight_rope1, 270, 0, state, side, rand);
        } else if (west == 0) {
            this.addQuads(result, straight_rope0, 270, 0, state, side, rand);
        }
        if (north_east) {
            this.addQuads(result, diagonal_rope, 0, 0, state, side, rand);
        }
        if (south_east) {
            this.addQuads(result, diagonal_rope, 90, 0, state, side, rand);
        }
        if (south_west) {
            this.addQuads(result, diagonal_rope, 180, 0, state, side, rand);
        }
        if (north_west) {
            this.addQuads(result, diagonal_rope, 270, 0, state, side, rand);
        }
        CACHE.put(stateKey, result);
        return result;
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        if (pole == null) {
            pole = ModelLoaderRopeFence.getModel("rope_fence_pole");
        }
        if (straight_rope0 == null) {
            straight_rope0 = ModelLoaderRopeFence.getModel("rope_fence_rope_straight_0");
        }
        if (straight_rope1 == null) {
            straight_rope1 = ModelLoaderRopeFence.getModel("rope_fence_rope_straight_1");
        }
        if (straight_rope2 == null) {
            straight_rope2 = ModelLoaderRopeFence.getModel("rope_fence_rope_straight_2");
        }
        if (diagonal_rope == null) {
            diagonal_rope = ModelLoaderRopeFence.getModel("rope_fence_rope_diagonal");
        }
        if (textures == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)pole.getTextures());
            builder.addAll((Iterable)straight_rope1.getTextures());
            builder.addAll((Iterable)diagonal_rope.getTextures());
            textures = builder.build();
        }
        return this;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.bakeInfo(format, bakedTextureGetter, new ResourceLocation("drpmedieval", "blocks/clean_plank_spruce"));
        return this;
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation instanceof ModelResourceLocation && MedievalBlocks.ROPE_FENCE.getRegistryName().equals((Object)modelLocation) && !modelLocation.toString().contains("inventory");
    }

    protected static IModel getModel(String modelName) {
        return ModelLoaderRegistry.getModelOrLogError((ResourceLocation)new ResourceLocation("drpmedieval", "block/rope_fence/" + modelName), (String)("A problem occured while trying to load: drpmedieval:block/rope_fence/" + modelName));
    }
}

